<?php

namespace Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CountrySeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
	{
		$entries = [
			[
				'code'                  => 'AD',
				'iso3'                  => 'AND',
				'iso_numeric'           => '20',
				'fips'                  => 'AN',
				'name'                  => ['en' => 'Andorra'],
				'capital'               => 'Andorra la Vella',
				'area'                  => '468',
				'population'            => '84000',
				'continent_code'        => 'EU',
				'tld'                   => '.ad',
				'currency_code'         => 'EUR',
				'phone'                 => '376',
				'postal_code_format'    => 'AD###',
				'postal_code_regex'     => '^(?:AD)*(d{3})$',
				'languages'             => 'ca',
				'neighbours'            => 'ES,FR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AE',
				'iso3'                  => 'ARE',
				'iso_numeric'           => '784',
				'fips'                  => 'AE',
				'name'                  => ['en' => 'United Arab Emirates'],
				'capital'               => 'Abu Dhabi',
				'area'                  => '82880',
				'population'            => '4975593',
				'continent_code'        => 'AS',
				'tld'                   => '.ae',
				'currency_code'         => 'AED',
				'phone'                 => '971',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar-AE,fa,en,hi,ur',
				'neighbours'            => 'SA,OM',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AF',
				'iso3'                  => 'AFG',
				'iso_numeric'           => '4',
				'fips'                  => 'AF',
				'name'                  => ['en' => 'Afghanistan'],
				'capital'               => 'Kabul',
				'area'                  => '647500',
				'population'            => '29121286',
				'continent_code'        => 'AS',
				'tld'                   => '.af',
				'currency_code'         => 'AFN',
				'phone'                 => '93',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fa-AF,ps,uz-AF,tk',
				'neighbours'            => 'TM,CN,IR,TJ,PK,UZ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AG',
				'iso3'                  => 'ATG',
				'iso_numeric'           => '28',
				'fips'                  => 'AC',
				'name'                  => ['en' => 'Antigua and Barbuda'],
				'capital'               => 'St. John\'s',
				'area'                  => '443',
				'population'            => '86754',
				'continent_code'        => 'NA',
				'tld'                   => '.ag',
				'currency_code'         => 'XCD',
				'phone'                 => '+1-268',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-AG',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AI',
				'iso3'                  => 'AIA',
				'iso_numeric'           => '660',
				'fips'                  => 'AV',
				'name'                  => ['en' => 'Anguilla'],
				'capital'               => 'The Valley',
				'area'                  => '102',
				'population'            => '13254',
				'continent_code'        => 'NA',
				'tld'                   => '.ai',
				'currency_code'         => 'XCD',
				'phone'                 => '+1-264',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-AI',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AL',
				'iso3'                  => 'ALB',
				'iso_numeric'           => '8',
				'fips'                  => 'AL',
				'name'                  => ['en' => 'Albania'],
				'capital'               => 'Tirana',
				'area'                  => '28748',
				'population'            => '2986952',
				'continent_code'        => 'EU',
				'tld'                   => '.al',
				'currency_code'         => 'ALL',
				'phone'                 => '355',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'sq,el',
				'neighbours'            => 'MK,GR,ME,RS,XK',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AM',
				'iso3'                  => 'ARM',
				'iso_numeric'           => '51',
				'fips'                  => 'AM',
				'name'                  => ['en' => 'Armenia'],
				'capital'               => 'Yerevan',
				'area'                  => '29800',
				'population'            => '2968000',
				'continent_code'        => 'AS',
				'tld'                   => '.am',
				'currency_code'         => 'AMD',
				'phone'                 => '374',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'hy',
				'neighbours'            => 'GE,IR,AZ,TR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AN',
				'iso3'                  => 'ANT',
				'iso_numeric'           => '530',
				'fips'                  => 'NT',
				'name'                  => ['en' => 'Netherlands Antilles'],
				'capital'               => 'Willemstad',
				'area'                  => '960',
				'population'            => '136197',
				'continent_code'        => 'NA',
				'tld'                   => '.an',
				'currency_code'         => 'ANG',
				'phone'                 => '599',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'nl-AN,en,es',
				'neighbours'            => 'GP',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AO',
				'iso3'                  => 'AGO',
				'iso_numeric'           => '24',
				'fips'                  => 'AO',
				'name'                  => ['en' => 'Angola'],
				'capital'               => 'Luanda',
				'area'                  => '1246700',
				'population'            => '13068161',
				'continent_code'        => 'AF',
				'tld'                   => '.ao',
				'currency_code'         => 'AOA',
				'phone'                 => '244',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'pt-AO',
				'neighbours'            => 'CD,NA,ZM,CG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AR',
				'iso3'                  => 'ARG',
				'iso_numeric'           => '32',
				'fips'                  => 'AR',
				'name'                  => ['en' => 'Argentina'],
				'capital'               => 'Buenos Aires',
				'area'                  => '2766890',
				'population'            => '41343201',
				'continent_code'        => 'SA',
				'tld'                   => '.ar',
				'currency_code'         => 'ARS',
				'phone'                 => '54',
				'postal_code_format'    => '@####@@@',
				'postal_code_regex'     => '^([A-Z]d{4}[A-Z]{3})$',
				'languages'             => 'es-AR,en,it,de,fr,gn',
				'neighbours'            => 'CL,BO,UY,PY,BR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AS',
				'iso3'                  => 'ASM',
				'iso_numeric'           => '16',
				'fips'                  => 'AQ',
				'name'                  => ['en' => 'American Samoa'],
				'capital'               => 'Pago Pago',
				'area'                  => '199',
				'population'            => '57881',
				'continent_code'        => 'OC',
				'tld'                   => '.as',
				'currency_code'         => 'USD',
				'phone'                 => '+1-684',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-AS,sm,to',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AT',
				'iso3'                  => 'AUT',
				'iso_numeric'           => '40',
				'fips'                  => 'AU',
				'name'                  => ['en' => 'Austria'],
				'capital'               => 'Vienna',
				'area'                  => '83858',
				'population'            => '8205000',
				'continent_code'        => 'EU',
				'tld'                   => '.at',
				'currency_code'         => 'EUR',
				'phone'                 => '43',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'de-AT,hr,hu,sl',
				'neighbours'            => 'CH,DE,HU,SK,CZ,IT,SI,LI',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AU',
				'iso3'                  => 'AUS',
				'iso_numeric'           => '36',
				'fips'                  => 'AS',
				'name'                  => ['en' => 'Australia'],
				'capital'               => 'Canberra',
				'area'                  => '7686850',
				'population'            => '21515754',
				'continent_code'        => 'OC',
				'tld'                   => '.au',
				'currency_code'         => 'AUD',
				'phone'                 => '61',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'en-AU',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AW',
				'iso3'                  => 'ABW',
				'iso_numeric'           => '533',
				'fips'                  => 'AA',
				'name'                  => ['en' => 'Aruba'],
				'capital'               => 'Oranjestad',
				'area'                  => '193',
				'population'            => '71566',
				'continent_code'        => 'NA',
				'tld'                   => '.aw',
				'currency_code'         => 'AWG',
				'phone'                 => '297',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'nl-AW,es,en',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AX',
				'iso3'                  => 'ALA',
				'iso_numeric'           => '248',
				'fips'                  => '',
				'name'                  => ['en' => 'Aland Islands'],
				'capital'               => 'Mariehamn',
				'area'                  => '1580',
				'population'            => '26711',
				'continent_code'        => 'EU',
				'tld'                   => '.ax',
				'currency_code'         => 'EUR',
				'phone'                 => '+358-18',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(?:FI)*(d{5})$',
				'languages'             => 'sv-AX',
				'neighbours'            => '',
				'equivalent_fips_code'  => 'FI',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'AZ',
				'iso3'                  => 'AZE',
				'iso_numeric'           => '31',
				'fips'                  => 'AJ',
				'name'                  => ['en' => 'Azerbaijan'],
				'capital'               => 'Baku',
				'area'                  => '86600',
				'population'            => '8303512',
				'continent_code'        => 'AS',
				'tld'                   => '.az',
				'currency_code'         => 'AZN',
				'phone'                 => '994',
				'postal_code_format'    => 'AZ ####',
				'postal_code_regex'     => '^(?:AZ)*(d{4})$',
				'languages'             => 'az,ru,hy',
				'neighbours'            => 'GE,IR,AM,TR,RU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BA',
				'iso3'                  => 'BIH',
				'iso_numeric'           => '70',
				'fips'                  => 'BK',
				'name'                  => ['en' => 'Bosnia and Herzegovina'],
				'capital'               => 'Sarajevo',
				'area'                  => '51129',
				'population'            => '4590000',
				'continent_code'        => 'EU',
				'tld'                   => '.ba',
				'currency_code'         => 'BAM',
				'phone'                 => '387',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'bs,hr-BA,sr-BA',
				'neighbours'            => 'HR,ME,RS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BB',
				'iso3'                  => 'BRB',
				'iso_numeric'           => '52',
				'fips'                  => 'BB',
				'name'                  => ['en' => 'Barbados'],
				'capital'               => 'Bridgetown',
				'area'                  => '431',
				'population'            => '285653',
				'continent_code'        => 'NA',
				'tld'                   => '.bb',
				'currency_code'         => 'BBD',
				'phone'                 => '+1-246',
				'postal_code_format'    => 'BB#####',
				'postal_code_regex'     => '^(?:BB)*(d{5})$',
				'languages'             => 'en-BB',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BD',
				'iso3'                  => 'BGD',
				'iso_numeric'           => '50',
				'fips'                  => 'BG',
				'name'                  => ['en' => 'Bangladesh'],
				'capital'               => 'Dhaka',
				'area'                  => '144000',
				'population'            => '156118464',
				'continent_code'        => 'AS',
				'tld'                   => '.bd',
				'currency_code'         => 'BDT',
				'phone'                 => '880',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'bn-BD,en',
				'neighbours'            => 'MM,IN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BE',
				'iso3'                  => 'BEL',
				'iso_numeric'           => '56',
				'fips'                  => 'BE',
				'name'                  => ['en' => 'Belgium'],
				'capital'               => 'Brussels',
				'area'                  => '30510',
				'population'            => '10403000',
				'continent_code'        => 'EU',
				'tld'                   => '.be',
				'currency_code'         => 'EUR',
				'phone'                 => '32',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'nl-BE,fr-BE,de-BE',
				'neighbours'            => 'DE,NL,LU,FR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BF',
				'iso3'                  => 'BFA',
				'iso_numeric'           => '854',
				'fips'                  => 'UV',
				'name'                  => ['en' => 'Burkina Faso'],
				'capital'               => 'Ouagadougou',
				'area'                  => '274200',
				'population'            => '16241811',
				'continent_code'        => 'AF',
				'tld'                   => '.bf',
				'currency_code'         => 'XOF',
				'phone'                 => '226',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-BF',
				'neighbours'            => 'NE,BJ,GH,CI,TG,ML',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BG',
				'iso3'                  => 'BGR',
				'iso_numeric'           => '100',
				'fips'                  => 'BU',
				'name'                  => ['en' => 'Bulgaria'],
				'capital'               => 'Sofia',
				'area'                  => '110910',
				'population'            => '7148785',
				'continent_code'        => 'EU',
				'tld'                   => '.bg',
				'currency_code'         => 'BGN',
				'phone'                 => '359',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'bg,tr-BG,rom',
				'neighbours'            => 'MK,GR,RO,TR,RS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BH',
				'iso3'                  => 'BHR',
				'iso_numeric'           => '48',
				'fips'                  => 'BA',
				'name'                  => ['en' => 'Bahrain'],
				'capital'               => 'Manama',
				'area'                  => '665',
				'population'            => '738004',
				'continent_code'        => 'AS',
				'tld'                   => '.bh',
				'currency_code'         => 'BHD',
				'phone'                 => '973',
				'postal_code_format'    => '####|###',
				'postal_code_regex'     => '^(d{3}d?)$',
				'languages'             => 'ar-BH,en,fa,ur',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BI',
				'iso3'                  => 'BDI',
				'iso_numeric'           => '108',
				'fips'                  => 'BY',
				'name'                  => ['en' => 'Burundi'],
				'capital'               => 'Bujumbura',
				'area'                  => '27830',
				'population'            => '9863117',
				'continent_code'        => 'AF',
				'tld'                   => '.bi',
				'currency_code'         => 'BIF',
				'phone'                 => '257',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-BI,rn',
				'neighbours'            => 'TZ,CD,RW',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BJ',
				'iso3'                  => 'BEN',
				'iso_numeric'           => '204',
				'fips'                  => 'BN',
				'name'                  => ['en' => 'Benin'],
				'capital'               => 'Porto-Novo',
				'area'                  => '112620',
				'population'            => '9056010',
				'continent_code'        => 'AF',
				'tld'                   => '.bj',
				'currency_code'         => 'XOF',
				'phone'                 => '+229',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-BJ',
				'neighbours'            => 'NE,TG,BF,NG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BL',
				'iso3'                  => 'BLM',
				'iso_numeric'           => '652',
				'fips'                  => 'TB',
				'name'                  => ['en' => 'Saint Barthelemy'],
				'capital'               => 'Gustavia',
				'area'                  => '21',
				'population'            => '8450',
				'continent_code'        => 'NA',
				'tld'                   => '.gp',
				'currency_code'         => 'EUR',
				'phone'                 => '590',
				'postal_code_format'    => '### ###',
				'postal_code_regex'     => '',
				'languages'             => 'fr',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BM',
				'iso3'                  => 'BMU',
				'iso_numeric'           => '60',
				'fips'                  => 'BD',
				'name'                  => ['en' => 'Bermuda'],
				'capital'               => 'Hamilton',
				'area'                  => '53',
				'population'            => '65365',
				'continent_code'        => 'NA',
				'tld'                   => '.bm',
				'currency_code'         => 'BMD',
				'phone'                 => '+1-441',
				'postal_code_format'    => '@@ ##',
				'postal_code_regex'     => '^([A-Z]{2}d{2})$',
				'languages'             => 'en-BM,pt',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BN',
				'iso3'                  => 'BRN',
				'iso_numeric'           => '96',
				'fips'                  => 'BX',
				'name'                  => ['en' => 'Brunei'],
				'capital'               => 'Bandar Seri Begawan',
				'area'                  => '5770',
				'population'            => '395027',
				'continent_code'        => 'AS',
				'tld'                   => '.bn',
				'currency_code'         => 'BND',
				'phone'                 => '673',
				'postal_code_format'    => '@@####',
				'postal_code_regex'     => '^([A-Z]{2}d{4})$',
				'languages'             => 'ms-BN,en-BN',
				'neighbours'            => 'MY',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BO',
				'iso3'                  => 'BOL',
				'iso_numeric'           => '68',
				'fips'                  => 'BL',
				'name'                  => ['en' => 'Bolivia'],
				'capital'               => 'Sucre',
				'area'                  => '1098580',
				'population'            => '9947418',
				'continent_code'        => 'SA',
				'tld'                   => '.bo',
				'currency_code'         => 'BOB',
				'phone'                 => '591',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'es-BO,qu,ay',
				'neighbours'            => 'PE,CL,PY,BR,AR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BQ',
				'iso3'                  => 'BES',
				'iso_numeric'           => '535',
				'fips'                  => '',
				'name'                  => ['en' => 'Bonaire, Saint Eustatius and Saba '],
				'capital'               => '',
				'area'                  => '328',
				'population'            => '18012',
				'continent_code'        => 'NA',
				'tld'                   => '.bq',
				'currency_code'         => 'USD',
				'phone'                 => '599',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'nl,pap,en',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BR',
				'iso3'                  => 'BRA',
				'iso_numeric'           => '76',
				'fips'                  => 'BR',
				'name'                  => ['en' => 'Brazil'],
				'capital'               => 'Brasilia',
				'area'                  => '8511965',
				'population'            => '201103330',
				'continent_code'        => 'SA',
				'tld'                   => '.br',
				'currency_code'         => 'BRL',
				'phone'                 => '55',
				'postal_code_format'    => '#####-###',
				'postal_code_regex'     => '^(d{8})$',
				'languages'             => 'pt-BR,es,en,fr',
				'neighbours'            => 'SR,PE,BO,UY,GY,PY,GF,VE,CO,AR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BS',
				'iso3'                  => 'BHS',
				'iso_numeric'           => '44',
				'fips'                  => 'BF',
				'name'                  => ['en' => 'Bahamas'],
				'capital'               => 'Nassau',
				'area'                  => '13940',
				'population'            => '301790',
				'continent_code'        => 'NA',
				'tld'                   => '.bs',
				'currency_code'         => 'BSD',
				'phone'                 => '+1-242',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-BS',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BT',
				'iso3'                  => 'BTN',
				'iso_numeric'           => '64',
				'fips'                  => 'BT',
				'name'                  => ['en' => 'Bhutan'],
				'capital'               => 'Thimphu',
				'area'                  => '47000',
				'population'            => '699847',
				'continent_code'        => 'AS',
				'tld'                   => '.bt',
				'currency_code'         => 'BTN',
				'phone'                 => '975',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'dz',
				'neighbours'            => 'CN,IN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BV',
				'iso3'                  => 'BVT',
				'iso_numeric'           => '74',
				'fips'                  => 'BV',
				'name'                  => ['en' => 'Bouvet Island'],
				'capital'               => '',
				'area'                  => '49',
				'population'            => '0',
				'continent_code'        => 'AN',
				'tld'                   => '.bv',
				'currency_code'         => 'NOK',
				'phone'                 => '',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => '',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BW',
				'iso3'                  => 'BWA',
				'iso_numeric'           => '72',
				'fips'                  => 'BC',
				'name'                  => ['en' => 'Botswana'],
				'capital'               => 'Gaborone',
				'area'                  => '600370',
				'population'            => '2029307',
				'continent_code'        => 'AF',
				'tld'                   => '.bw',
				'currency_code'         => 'BWP',
				'phone'                 => '267',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-BW,tn-BW',
				'neighbours'            => 'ZW,ZA,NA',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BY',
				'iso3'                  => 'BLR',
				'iso_numeric'           => '112',
				'fips'                  => 'BO',
				'name'                  => ['en' => 'Belarus'],
				'capital'               => 'Minsk',
				'area'                  => '207600',
				'population'            => '9685000',
				'continent_code'        => 'EU',
				'tld'                   => '.by',
				'currency_code'         => 'BYR',
				'phone'                 => '375',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'be,ru',
				'neighbours'            => 'PL,LT,UA,RU,LV',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'BZ',
				'iso3'                  => 'BLZ',
				'iso_numeric'           => '84',
				'fips'                  => 'BH',
				'name'                  => ['en' => 'Belize'],
				'capital'               => 'Belmopan',
				'area'                  => '22966',
				'population'            => '314522',
				'continent_code'        => 'NA',
				'tld'                   => '.bz',
				'currency_code'         => 'BZD',
				'phone'                 => '501',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-BZ,es',
				'neighbours'            => 'GT,MX',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CA',
				'iso3'                  => 'CAN',
				'iso_numeric'           => '124',
				'fips'                  => 'CA',
				'name'                  => ['en' => 'Canada'],
				'capital'               => 'Ottawa',
				'area'                  => '9984670',
				'population'            => '33679000',
				'continent_code'        => 'NA',
				'tld'                   => '.ca',
				'currency_code'         => 'CAD',
				'phone'                 => '1',
				'postal_code_format'    => '@#@ #@#',
				'postal_code_regex'     => '^([ABCEGHJKLMNPRSTVXY]d[ABCEGHJKLMNPRSTVWXYZ]) ?(d[ABCEGHJKLMNPRSTVWXYZ]d)$ ',
				'languages'             => 'en-CA,fr-CA,iu',
				'neighbours'            => 'US',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CC',
				'iso3'                  => 'CCK',
				'iso_numeric'           => '166',
				'fips'                  => 'CK',
				'name'                  => ['en' => 'Cocos Islands'],
				'capital'               => 'West Island',
				'area'                  => '14',
				'population'            => '628',
				'continent_code'        => 'AS',
				'tld'                   => '.cc',
				'currency_code'         => 'AUD',
				'phone'                 => '61',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ms-CC,en',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CD',
				'iso3'                  => 'COD',
				'iso_numeric'           => '180',
				'fips'                  => 'CG',
				'name'                  => ['en' => 'Democratic Republic of the Congo'],
				'capital'               => 'Kinshasa',
				'area'                  => '2345410',
				'population'            => '70916439',
				'continent_code'        => 'AF',
				'tld'                   => '.cd',
				'currency_code'         => 'CDF',
				'phone'                 => '243',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-CD,ln,kg',
				'neighbours'            => 'TZ,CF,SS,RW,ZM,BI,UG,CG,AO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CF',
				'iso3'                  => 'CAF',
				'iso_numeric'           => '140',
				'fips'                  => 'CT',
				'name'                  => ['en' => 'Central African Republic'],
				'capital'               => 'Bangui',
				'area'                  => '622984',
				'population'            => '4844927',
				'continent_code'        => 'AF',
				'tld'                   => '.cf',
				'currency_code'         => 'XAF',
				'phone'                 => '236',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-CF,sg,ln,kg',
				'neighbours'            => 'TD,SD,CD,SS,CM,CG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CG',
				'iso3'                  => 'COG',
				'iso_numeric'           => '178',
				'fips'                  => 'CF',
				'name'                  => ['en' => 'Republic of the Congo'],
				'capital'               => 'Brazzaville',
				'area'                  => '342000',
				'population'            => '3039126',
				'continent_code'        => 'AF',
				'tld'                   => '.cg',
				'currency_code'         => 'XAF',
				'phone'                 => '242',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-CG,kg,ln-CG',
				'neighbours'            => 'CF,GA,CD,CM,AO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CH',
				'iso3'                  => 'CHE',
				'iso_numeric'           => '756',
				'fips'                  => 'SZ',
				'name'                  => ['en' => 'Switzerland'],
				'capital'               => 'Berne',
				'area'                  => '41290',
				'population'            => '7581000',
				'continent_code'        => 'EU',
				'tld'                   => '.ch',
				'currency_code'         => 'CHF',
				'phone'                 => '41',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'de-CH,fr-CH,it-CH,rm',
				'neighbours'            => 'DE,IT,LI,FR,AT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CI',
				'iso3'                  => 'CIV',
				'iso_numeric'           => '384',
				'fips'                  => 'IV',
				'name'                  => ['en' => 'Ivory Coast'],
				'capital'               => 'Yamoussoukro',
				'area'                  => '322460',
				'population'            => '21058798',
				'continent_code'        => 'AF',
				'tld'                   => '.ci',
				'currency_code'         => 'XOF',
				'phone'                 => '225',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-CI',
				'neighbours'            => 'LR,GH,GN,BF,ML',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CK',
				'iso3'                  => 'COK',
				'iso_numeric'           => '184',
				'fips'                  => 'CW',
				'name'                  => ['en' => 'Cook Islands'],
				'capital'               => 'Avarua',
				'area'                  => '240',
				'population'            => '21388',
				'continent_code'        => 'OC',
				'tld'                   => '.ck',
				'currency_code'         => 'NZD',
				'phone'                 => '682',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-CK,mi',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CL',
				'iso3'                  => 'CHL',
				'iso_numeric'           => '152',
				'fips'                  => 'CI',
				'name'                  => ['en' => 'Chile'],
				'capital'               => 'Santiago',
				'area'                  => '756950',
				'population'            => '16746491',
				'continent_code'        => 'SA',
				'tld'                   => '.cl',
				'currency_code'         => 'CLP',
				'phone'                 => '56',
				'postal_code_format'    => '#######',
				'postal_code_regex'     => '^(d{7})$',
				'languages'             => 'es-CL',
				'neighbours'            => 'PE,BO,AR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CM',
				'iso3'                  => 'CMR',
				'iso_numeric'           => '120',
				'fips'                  => 'CM',
				'name'                  => ['en' => 'Cameroon'],
				'capital'               => 'Yaounde',
				'area'                  => '475440',
				'population'            => '19294149',
				'continent_code'        => 'AF',
				'tld'                   => '.cm',
				'currency_code'         => 'XAF',
				'phone'                 => '237',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-CM,en-CM',
				'neighbours'            => 'TD,CF,GA,GQ,CG,NG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CN',
				'iso3'                  => 'CHN',
				'iso_numeric'           => '156',
				'fips'                  => 'CH',
				'name'                  => ['en' => 'China'],
				'capital'               => 'Beijing',
				'area'                  => '9596960',
				'population'            => '1330044000',
				'continent_code'        => 'AS',
				'tld'                   => '.cn',
				'currency_code'         => 'CNY',
				'phone'                 => '86',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'zh-CN,yue,wuu,dta,ug,za',
				'neighbours'            => 'LA,BT,TJ,KZ,MN,AF,NP,MM,KG,PK,KP,RU,VN,IN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CO',
				'iso3'                  => 'COL',
				'iso_numeric'           => '170',
				'fips'                  => 'CO',
				'name'                  => ['en' => 'Colombia'],
				'capital'               => 'Bogota',
				'area'                  => '1138910',
				'population'            => '47790000',
				'continent_code'        => 'SA',
				'tld'                   => '.co',
				'currency_code'         => 'COP',
				'phone'                 => '57',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'es-CO',
				'neighbours'            => 'EC,PE,PA,BR,VE',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CR',
				'iso3'                  => 'CRI',
				'iso_numeric'           => '188',
				'fips'                  => 'CS',
				'name'                  => ['en' => 'Costa Rica'],
				'capital'               => 'San Jose',
				'area'                  => '51100',
				'population'            => '4516220',
				'continent_code'        => 'NA',
				'tld'                   => '.cr',
				'currency_code'         => 'CRC',
				'phone'                 => '506',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'es-CR,en',
				'neighbours'            => 'PA,NI',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CU',
				'iso3'                  => 'CUB',
				'iso_numeric'           => '192',
				'fips'                  => 'CU',
				'name'                  => ['en' => 'Cuba'],
				'capital'               => 'Havana',
				'area'                  => '110860',
				'population'            => '11423000',
				'continent_code'        => 'NA',
				'tld'                   => '.cu',
				'currency_code'         => 'CUP',
				'phone'                 => '53',
				'postal_code_format'    => 'CP #####',
				'postal_code_regex'     => '^(?:CP)*(d{5})$',
				'languages'             => 'es-CU',
				'neighbours'            => 'US',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CV',
				'iso3'                  => 'CPV',
				'iso_numeric'           => '132',
				'fips'                  => 'CV',
				'name'                  => ['en' => 'Cape Verde'],
				'capital'               => 'Praia',
				'area'                  => '4033',
				'population'            => '508659',
				'continent_code'        => 'AF',
				'tld'                   => '.cv',
				'currency_code'         => 'CVE',
				'phone'                 => '238',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'pt-CV',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CW',
				'iso3'                  => 'CUW',
				'iso_numeric'           => '531',
				'fips'                  => 'UC',
				'name'                  => ['en' => 'Curacao'],
				'capital'               => ' Willemstad',
				'area'                  => '444',
				'population'            => '141766',
				'continent_code'        => 'NA',
				'tld'                   => '.cw',
				'currency_code'         => 'ANG',
				'phone'                 => '599',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'nl,pap',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CX',
				'iso3'                  => 'CXR',
				'iso_numeric'           => '162',
				'fips'                  => 'KT',
				'name'                  => ['en' => 'Christmas Island'],
				'capital'               => 'Flying Fish Cove',
				'area'                  => '135',
				'population'            => '1500',
				'continent_code'        => 'AS',
				'tld'                   => '.cx',
				'currency_code'         => 'AUD',
				'phone'                 => '61',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'en,zh,ms-CC',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CY',
				'iso3'                  => 'CYP',
				'iso_numeric'           => '196',
				'fips'                  => 'CY',
				'name'                  => ['en' => 'Cyprus'],
				'capital'               => 'Nicosia',
				'area'                  => '9250',
				'population'            => '1102677',
				'continent_code'        => 'EU',
				'tld'                   => '.cy',
				'currency_code'         => 'EUR',
				'phone'                 => '357',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'el-CY,tr-CY,en',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'CZ',
				'iso3'                  => 'CZE',
				'iso_numeric'           => '203',
				'fips'                  => 'EZ',
				'name'                  => ['en' => 'Czech Republic'],
				'capital'               => 'Prague',
				'area'                  => '78866',
				'population'            => '10476000',
				'continent_code'        => 'EU',
				'tld'                   => '.cz',
				'currency_code'         => 'CZK',
				'phone'                 => '420',
				'postal_code_format'    => '### ##',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'cs,sk',
				'neighbours'            => 'PL,DE,SK,AT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'DE',
				'iso3'                  => 'DEU',
				'iso_numeric'           => '276',
				'fips'                  => 'GM',
				'name'                  => ['en' => 'Germany'],
				'capital'               => 'Berlin',
				'area'                  => '357021',
				'population'            => '81802257',
				'continent_code'        => 'EU',
				'tld'                   => '.de',
				'currency_code'         => 'EUR',
				'phone'                 => '49',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'de',
				'neighbours'            => 'CH,PL,NL,DK,BE,CZ,LU,FR,AT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'DJ',
				'iso3'                  => 'DJI',
				'iso_numeric'           => '262',
				'fips'                  => 'DJ',
				'name'                  => ['en' => 'Djibouti'],
				'capital'               => 'Djibouti',
				'area'                  => '23000',
				'population'            => '740528',
				'continent_code'        => 'AF',
				'tld'                   => '.dj',
				'currency_code'         => 'DJF',
				'phone'                 => '253',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-DJ,ar,so-DJ,aa',
				'neighbours'            => 'ER,ET,SO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'DK',
				'iso3'                  => 'DNK',
				'iso_numeric'           => '208',
				'fips'                  => 'DA',
				'name'                  => ['en' => 'Denmark'],
				'capital'               => 'Copenhagen',
				'area'                  => '43094',
				'population'            => '5484000',
				'continent_code'        => 'EU',
				'tld'                   => '.dk',
				'currency_code'         => 'DKK',
				'phone'                 => '45',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'da-DK,en,fo,de-DK',
				'neighbours'            => 'DE',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'DM',
				'iso3'                  => 'DMA',
				'iso_numeric'           => '212',
				'fips'                  => 'DO',
				'name'                  => ['en' => 'Dominica'],
				'capital'               => 'Roseau',
				'area'                  => '754',
				'population'            => '72813',
				'continent_code'        => 'NA',
				'tld'                   => '.dm',
				'currency_code'         => 'XCD',
				'phone'                 => '+1-767',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-DM',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'DO',
				'iso3'                  => 'DOM',
				'iso_numeric'           => '214',
				'fips'                  => 'DR',
				'name'                  => ['en' => 'Dominican Republic'],
				'capital'               => 'Santo Domingo',
				'area'                  => '48730',
				'population'            => '9823821',
				'continent_code'        => 'NA',
				'tld'                   => '.do',
				'currency_code'         => 'DOP',
				'phone'                 => '+809/829/849',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'es-DO',
				'neighbours'            => 'HT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'DZ',
				'iso3'                  => 'DZA',
				'iso_numeric'           => '12',
				'fips'                  => 'AG',
				'name'                  => ['en' => 'Algeria'],
				'capital'               => 'Algiers',
				'area'                  => '2381740',
				'population'            => '34586184',
				'continent_code'        => 'AF',
				'tld'                   => '.dz',
				'currency_code'         => 'DZD',
				'phone'                 => '213',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ar-DZ,fr',
				'neighbours'            => 'NE,EH,LY,MR,TN,MA,ML',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'EC',
				'iso3'                  => 'ECU',
				'iso_numeric'           => '218',
				'fips'                  => 'EC',
				'name'                  => ['en' => 'Ecuador'],
				'capital'               => 'Quito',
				'area'                  => '283560',
				'population'            => '14790608',
				'continent_code'        => 'SA',
				'tld'                   => '.ec',
				'currency_code'         => 'USD',
				'phone'                 => '593',
				'postal_code_format'    => '@####@',
				'postal_code_regex'     => '^([a-zA-Z]d{4}[a-zA-Z])$',
				'languages'             => 'es-EC',
				'neighbours'            => 'PE,CO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'EE',
				'iso3'                  => 'EST',
				'iso_numeric'           => '233',
				'fips'                  => 'EN',
				'name'                  => ['en' => 'Estonia'],
				'capital'               => 'Tallinn',
				'area'                  => '45226',
				'population'            => '1291170',
				'continent_code'        => 'EU',
				'tld'                   => '.ee',
				'currency_code'         => 'EUR',
				'phone'                 => '372',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'et,ru',
				'neighbours'            => 'RU,LV',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'EG',
				'iso3'                  => 'EGY',
				'iso_numeric'           => '818',
				'fips'                  => 'EG',
				'name'                  => ['en' => 'Egypt'],
				'capital'               => 'Cairo',
				'area'                  => '1001450',
				'population'            => '80471869',
				'continent_code'        => 'AF',
				'tld'                   => '.eg',
				'currency_code'         => 'EGP',
				'phone'                 => '20',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ar-EG,en,fr',
				'neighbours'            => 'LY,SD,IL,PS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'EH',
				'iso3'                  => 'ESH',
				'iso_numeric'           => '732',
				'fips'                  => 'WI',
				'name'                  => ['en' => 'Western Sahara'],
				'capital'               => 'El-Aaiun',
				'area'                  => '266000',
				'population'            => '273008',
				'continent_code'        => 'AF',
				'tld'                   => '.eh',
				'currency_code'         => 'MAD',
				'phone'                 => '212',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar,mey',
				'neighbours'            => 'DZ,MR,MA',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ER',
				'iso3'                  => 'ERI',
				'iso_numeric'           => '232',
				'fips'                  => 'ER',
				'name'                  => ['en' => 'Eritrea'],
				'capital'               => 'Asmara',
				'area'                  => '121320',
				'population'            => '5792984',
				'continent_code'        => 'AF',
				'tld'                   => '.er',
				'currency_code'         => 'ERN',
				'phone'                 => '291',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'aa-ER,ar,tig,kun,ti-ER',
				'neighbours'            => 'ET,SD,DJ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ES',
				'iso3'                  => 'ESP',
				'iso_numeric'           => '724',
				'fips'                  => 'SP',
				'name'                  => ['en' => 'Spain'],
				'capital'               => 'Madrid',
				'area'                  => '504782',
				'population'            => '46505963',
				'continent_code'        => 'EU',
				'tld'                   => '.es',
				'currency_code'         => 'EUR',
				'phone'                 => '34',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'es-ES,ca,gl,eu,oc',
				'neighbours'            => 'AD,PT,GI,FR,MA',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ET',
				'iso3'                  => 'ETH',
				'iso_numeric'           => '231',
				'fips'                  => 'ET',
				'name'                  => ['en' => 'Ethiopia'],
				'capital'               => 'Addis Ababa',
				'area'                  => '1127127',
				'population'            => '88013491',
				'continent_code'        => 'AF',
				'tld'                   => '.et',
				'currency_code'         => 'ETB',
				'phone'                 => '251',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'am,en-ET,om-ET,ti-ET,so-ET,sid',
				'neighbours'            => 'ER,KE,SD,SS,SO,DJ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'FI',
				'iso3'                  => 'FIN',
				'iso_numeric'           => '246',
				'fips'                  => 'FI',
				'name'                  => ['en' => 'Finland'],
				'capital'               => 'Helsinki',
				'area'                  => '337030',
				'population'            => '5244000',
				'continent_code'        => 'EU',
				'tld'                   => '.fi',
				'currency_code'         => 'EUR',
				'phone'                 => '358',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(?:FI)*(d{5})$',
				'languages'             => 'fi-FI,sv-FI,smn',
				'neighbours'            => 'NO,RU,SE',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'FJ',
				'iso3'                  => 'FJI',
				'iso_numeric'           => '242',
				'fips'                  => 'FJ',
				'name'                  => ['en' => 'Fiji'],
				'capital'               => 'Suva',
				'area'                  => '18270',
				'population'            => '875983',
				'continent_code'        => 'OC',
				'tld'                   => '.fj',
				'currency_code'         => 'FJD',
				'phone'                 => '679',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-FJ,fj',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'FK',
				'iso3'                  => 'FLK',
				'iso_numeric'           => '238',
				'fips'                  => 'FK',
				'name'                  => ['en' => 'Falkland Islands'],
				'capital'               => 'Stanley',
				'area'                  => '12173',
				'population'            => '2638',
				'continent_code'        => 'SA',
				'tld'                   => '.fk',
				'currency_code'         => 'FKP',
				'phone'                 => '500',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-FK',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'FM',
				'iso3'                  => 'FSM',
				'iso_numeric'           => '583',
				'fips'                  => 'FM',
				'name'                  => ['en' => 'Micronesia'],
				'capital'               => 'Palikir',
				'area'                  => '702',
				'population'            => '107708',
				'continent_code'        => 'OC',
				'tld'                   => '.fm',
				'currency_code'         => 'USD',
				'phone'                 => '691',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'en-FM,chk,pon,yap,kos,uli,woe,nkr,kpg',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'FO',
				'iso3'                  => 'FRO',
				'iso_numeric'           => '234',
				'fips'                  => 'FO',
				'name'                  => ['en' => 'Faroe Islands'],
				'capital'               => 'Torshavn',
				'area'                  => '1399',
				'population'            => '48228',
				'continent_code'        => 'EU',
				'tld'                   => '.fo',
				'currency_code'         => 'DKK',
				'phone'                 => '298',
				'postal_code_format'    => 'FO-###',
				'postal_code_regex'     => '^(?:FO)*(d{3})$',
				'languages'             => 'fo,da-FO',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'FR',
				'iso3'                  => 'FRA',
				'iso_numeric'           => '250',
				'fips'                  => 'FR',
				'name'                  => ['en' => 'France'],
				'capital'               => 'Paris',
				'area'                  => '547030',
				'population'            => '64768389',
				'continent_code'        => 'EU',
				'tld'                   => '.fr',
				'currency_code'         => 'EUR',
				'phone'                 => '33',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'fr-FR,frp,br,co,ca,eu,oc',
				'neighbours'            => 'CH,DE,BE,LU,IT,AD,MC,ES',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GA',
				'iso3'                  => 'GAB',
				'iso_numeric'           => '266',
				'fips'                  => 'GB',
				'name'                  => ['en' => 'Gabon'],
				'capital'               => 'Libreville',
				'area'                  => '267667',
				'population'            => '1545255',
				'continent_code'        => 'AF',
				'tld'                   => '.ga',
				'currency_code'         => 'XAF',
				'phone'                 => '241',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-GA',
				'neighbours'            => 'CM,GQ,CG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GD',
				'iso3'                  => 'GRD',
				'iso_numeric'           => '308',
				'fips'                  => 'GJ',
				'name'                  => ['en' => 'Grenada'],
				'capital'               => 'St. George\'s',
				'area'                  => '344',
				'population'            => '107818',
				'continent_code'        => 'NA',
				'tld'                   => '.gd',
				'currency_code'         => 'XCD',
				'phone'                 => '+1-473',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-GD',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GE',
				'iso3'                  => 'GEO',
				'iso_numeric'           => '268',
				'fips'                  => 'GG',
				'name'                  => ['en' => 'Georgia'],
				'capital'               => 'Tbilisi',
				'area'                  => '69700',
				'population'            => '4630000',
				'continent_code'        => 'AS',
				'tld'                   => '.ge',
				'currency_code'         => 'GEL',
				'phone'                 => '995',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'ka,ru,hy,az',
				'neighbours'            => 'AM,AZ,TR,RU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GF',
				'iso3'                  => 'GUF',
				'iso_numeric'           => '254',
				'fips'                  => 'FG',
				'name'                  => ['en' => 'French Guiana'],
				'capital'               => 'Cayenne',
				'area'                  => '91000',
				'population'            => '195506',
				'continent_code'        => 'SA',
				'tld'                   => '.gf',
				'currency_code'         => 'EUR',
				'phone'                 => '594',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^((97|98)3d{2})$',
				'languages'             => 'fr-GF',
				'neighbours'            => 'SR,BR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GG',
				'iso3'                  => 'GGY',
				'iso_numeric'           => '831',
				'fips'                  => 'GK',
				'name'                  => ['en' => 'Guernsey'],
				'capital'               => 'St Peter Port',
				'area'                  => '78',
				'population'            => '65228',
				'continent_code'        => 'EU',
				'tld'                   => '.gg',
				'currency_code'         => 'GBP',
				'phone'                 => '+44-1481',
				'postal_code_format'    => '@# #@@|@## #@@|@@# #@@|@@## #@@|@#@ #@@|@@#@ #@@|G',
				'postal_code_regex'     => '^(([A-Z]d{2}[A-Z]{2})|([A-Z]d{3}[A-Z]{2})|([A-Z]{2}d{2}[A-Z]{2})|([A-Z]{2}d{3}[A-Z]{2})|([A-Z]d[A-Z]d[A-Z]{2})|([A-Z]{2}d[A-Z]d[A-Z]{2})|(GIR0AA))$',
				'languages'             => 'en,fr',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GH',
				'iso3'                  => 'GHA',
				'iso_numeric'           => '288',
				'fips'                  => 'GH',
				'name'                  => ['en' => 'Ghana'],
				'capital'               => 'Accra',
				'area'                  => '239460',
				'population'            => '24339838',
				'continent_code'        => 'AF',
				'tld'                   => '.gh',
				'currency_code'         => 'GHS',
				'phone'                 => '233',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-GH,ak,ee,tw',
				'neighbours'            => 'CI,TG,BF',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GI',
				'iso3'                  => 'GIB',
				'iso_numeric'           => '292',
				'fips'                  => 'GI',
				'name'                  => ['en' => 'Gibraltar'],
				'capital'               => 'Gibraltar',
				'area'                  => '7',
				'population'            => '27884',
				'continent_code'        => 'EU',
				'tld'                   => '.gi',
				'currency_code'         => 'GIP',
				'phone'                 => '350',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-GI,es,it,pt',
				'neighbours'            => 'ES',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GL',
				'iso3'                  => 'GRL',
				'iso_numeric'           => '304',
				'fips'                  => 'GL',
				'name'                  => ['en' => 'Greenland'],
				'capital'               => 'Nuuk',
				'area'                  => '2166086',
				'population'            => '56375',
				'continent_code'        => 'NA',
				'tld'                   => '.gl',
				'currency_code'         => 'DKK',
				'phone'                 => '299',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'kl,da-GL,en',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GM',
				'iso3'                  => 'GMB',
				'iso_numeric'           => '270',
				'fips'                  => 'GA',
				'name'                  => ['en' => 'Gambia'],
				'capital'               => 'Banjul',
				'area'                  => '11300',
				'population'            => '1593256',
				'continent_code'        => 'AF',
				'tld'                   => '.gm',
				'currency_code'         => 'GMD',
				'phone'                 => '220',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-GM,mnk,wof,wo,ff',
				'neighbours'            => 'SN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GN',
				'iso3'                  => 'GIN',
				'iso_numeric'           => '324',
				'fips'                  => 'GV',
				'name'                  => ['en' => 'Guinea'],
				'capital'               => 'Conakry',
				'area'                  => '245857',
				'population'            => '10324025',
				'continent_code'        => 'AF',
				'tld'                   => '.gn',
				'currency_code'         => 'GNF',
				'phone'                 => '224',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-GN',
				'neighbours'            => 'LR,SN,SL,CI,GW,ML',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GP',
				'iso3'                  => 'GLP',
				'iso_numeric'           => '312',
				'fips'                  => 'GP',
				'name'                  => ['en' => 'Guadeloupe'],
				'capital'               => 'Basse-Terre',
				'area'                  => '1780',
				'population'            => '443000',
				'continent_code'        => 'NA',
				'tld'                   => '.gp',
				'currency_code'         => 'EUR',
				'phone'                 => '590',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^((97|98)d{3})$',
				'languages'             => 'fr-GP',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GQ',
				'iso3'                  => 'GNQ',
				'iso_numeric'           => '226',
				'fips'                  => 'EK',
				'name'                  => ['en' => 'Equatorial Guinea'],
				'capital'               => 'Malabo',
				'area'                  => '28051',
				'population'            => '1014999',
				'continent_code'        => 'AF',
				'tld'                   => '.gq',
				'currency_code'         => 'XAF',
				'phone'                 => '240',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'es-GQ,fr',
				'neighbours'            => 'GA,CM',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GR',
				'iso3'                  => 'GRC',
				'iso_numeric'           => '300',
				'fips'                  => 'GR',
				'name'                  => ['en' => 'Greece'],
				'capital'               => 'Athens',
				'area'                  => '131940',
				'population'            => '11000000',
				'continent_code'        => 'EU',
				'tld'                   => '.gr',
				'currency_code'         => 'EUR',
				'phone'                 => '30',
				'postal_code_format'    => '### ##',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'el-GR,en,fr',
				'neighbours'            => 'AL,MK,TR,BG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GT',
				'iso3'                  => 'GTM',
				'iso_numeric'           => '320',
				'fips'                  => 'GT',
				'name'                  => ['en' => 'Guatemala'],
				'capital'               => 'Guatemala City',
				'area'                  => '108890',
				'population'            => '13550440',
				'continent_code'        => 'NA',
				'tld'                   => '.gt',
				'currency_code'         => 'GTQ',
				'phone'                 => '502',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'es-GT',
				'neighbours'            => 'MX,HN,BZ,SV',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GU',
				'iso3'                  => 'GUM',
				'iso_numeric'           => '316',
				'fips'                  => 'GQ',
				'name'                  => ['en' => 'Guam'],
				'capital'               => 'Hagatna',
				'area'                  => '549',
				'population'            => '159358',
				'continent_code'        => 'OC',
				'tld'                   => '.gu',
				'currency_code'         => 'USD',
				'phone'                 => '+1-671',
				'postal_code_format'    => '969##',
				'postal_code_regex'     => '^(969d{2})$',
				'languages'             => 'en-GU,ch-GU',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GW',
				'iso3'                  => 'GNB',
				'iso_numeric'           => '624',
				'fips'                  => 'PU',
				'name'                  => ['en' => 'Guinea-Bissau'],
				'capital'               => 'Bissau',
				'area'                  => '36120',
				'population'            => '1565126',
				'continent_code'        => 'AF',
				'tld'                   => '.gw',
				'currency_code'         => 'XOF',
				'phone'                 => '245',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'pt-GW,pov',
				'neighbours'            => 'SN,GN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GY',
				'iso3'                  => 'GUY',
				'iso_numeric'           => '328',
				'fips'                  => 'GY',
				'name'                  => ['en' => 'Guyana'],
				'capital'               => 'Georgetown',
				'area'                  => '214970',
				'population'            => '748486',
				'continent_code'        => 'SA',
				'tld'                   => '.gy',
				'currency_code'         => 'GYD',
				'phone'                 => '592',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-GY',
				'neighbours'            => 'SR,BR,VE',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'HK',
				'iso3'                  => 'HKG',
				'iso_numeric'           => '344',
				'fips'                  => 'HK',
				'name'                  => ['en' => 'Hong Kong'],
				'capital'               => 'Hong Kong',
				'area'                  => '1092',
				'population'            => '6898686',
				'continent_code'        => 'AS',
				'tld'                   => '.hk',
				'currency_code'         => 'HKD',
				'phone'                 => '852',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'zh-HK,yue,zh,en',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'HN',
				'iso3'                  => 'HND',
				'iso_numeric'           => '340',
				'fips'                  => 'HO',
				'name'                  => ['en' => 'Honduras'],
				'capital'               => 'Tegucigalpa',
				'area'                  => '112090',
				'population'            => '7989415',
				'continent_code'        => 'NA',
				'tld'                   => '.hn',
				'currency_code'         => 'HNL',
				'phone'                 => '504',
				'postal_code_format'    => '@@####',
				'postal_code_regex'     => '^([A-Z]{2}d{4})$',
				'languages'             => 'es-HN',
				'neighbours'            => 'GT,NI,SV',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'HR',
				'iso3'                  => 'HRV',
				'iso_numeric'           => '191',
				'fips'                  => 'HR',
				'name'                  => ['en' => 'Croatia'],
				'capital'               => 'Zagreb',
				'area'                  => '56542',
				'population'            => '4491000',
				'continent_code'        => 'EU',
				'tld'                   => '.hr',
				'currency_code'         => 'HRK',
				'phone'                 => '385',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(?:HR)*(d{5})$',
				'languages'             => 'hr-HR,sr',
				'neighbours'            => 'HU,SI,BA,ME,RS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'HT',
				'iso3'                  => 'HTI',
				'iso_numeric'           => '332',
				'fips'                  => 'HA',
				'name'                  => ['en' => 'Haiti'],
				'capital'               => 'Port-au-Prince',
				'area'                  => '27750',
				'population'            => '9648924',
				'continent_code'        => 'NA',
				'tld'                   => '.ht',
				'currency_code'         => 'HTG',
				'phone'                 => '509',
				'postal_code_format'    => 'HT####',
				'postal_code_regex'     => '^(?:HT)*(d{4})$',
				'languages'             => 'ht,fr-HT',
				'neighbours'            => 'DO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'HU',
				'iso3'                  => 'HUN',
				'iso_numeric'           => '348',
				'fips'                  => 'HU',
				'name'                  => ['en' => 'Hungary'],
				'capital'               => 'Budapest',
				'area'                  => '93030',
				'population'            => '9982000',
				'continent_code'        => 'EU',
				'tld'                   => '.hu',
				'currency_code'         => 'HUF',
				'phone'                 => '36',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'hu-HU',
				'neighbours'            => 'SK,SI,RO,UA,HR,AT,RS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ID',
				'iso3'                  => 'IDN',
				'iso_numeric'           => '360',
				'fips'                  => 'ID',
				'name'                  => ['en' => 'Indonesia'],
				'capital'               => 'Jakarta',
				'area'                  => '1919440',
				'population'            => '242968342',
				'continent_code'        => 'AS',
				'tld'                   => '.id',
				'currency_code'         => 'IDR',
				'phone'                 => '62',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'id,en,nl,jv',
				'neighbours'            => 'PG,TL,MY',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'IE',
				'iso3'                  => 'IRL',
				'iso_numeric'           => '372',
				'fips'                  => 'EI',
				'name'                  => ['en' => 'Ireland'],
				'capital'               => 'Dublin',
				'area'                  => '70280',
				'population'            => '4622917',
				'continent_code'        => 'EU',
				'tld'                   => '.ie',
				'currency_code'         => 'EUR',
				'phone'                 => '353',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-IE,ga-IE',
				'neighbours'            => 'GB',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'IL',
				'iso3'                  => 'ISR',
				'iso_numeric'           => '376',
				'fips'                  => 'IS',
				'name'                  => ['en' => 'Israel'],
				'capital'               => 'Jerusalem',
				'area'                  => '20770',
				'population'            => '7353985',
				'continent_code'        => 'AS',
				'tld'                   => '.il',
				'currency_code'         => 'ILS',
				'phone'                 => '972',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'he,ar-IL,en-IL,',
				'neighbours'            => 'SY,JO,LB,EG,PS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'IM',
				'iso3'                  => 'IMN',
				'iso_numeric'           => '833',
				'fips'                  => 'IM',
				'name'                  => ['en' => 'Isle of Man'],
				'capital'               => 'Douglas, Isle of Man',
				'area'                  => '572',
				'population'            => '75049',
				'continent_code'        => 'EU',
				'tld'                   => '.im',
				'currency_code'         => 'GBP',
				'phone'                 => '+44-1624',
				'postal_code_format'    => '@# #@@|@## #@@|@@# #@@|@@## #@@|@#@ #@@|@@#@ #@@|G',
				'postal_code_regex'     => '^(([A-Z]d{2}[A-Z]{2})|([A-Z]d{3}[A-Z]{2})|([A-Z]{2}d{2}[A-Z]{2})|([A-Z]{2}d{3}[A-Z]{2})|([A-Z]d[A-Z]d[A-Z]{2})|([A-Z]{2}d[A-Z]d[A-Z]{2})|(GIR0AA))$',
				'languages'             => 'en,gv',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'IN',
				'iso3'                  => 'IND',
				'iso_numeric'           => '356',
				'fips'                  => 'IN',
				'name'                  => ['en' => 'India'],
				'capital'               => 'New Delhi',
				'area'                  => '3287590',
				'population'            => '1173108018',
				'continent_code'        => 'AS',
				'tld'                   => '.in',
				'currency_code'         => 'INR',
				'phone'                 => '91',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'hi,en-IN,bn,te,mr,ta,ur,gu,kn,ml,or,pa,as,bh,sat,k',
				'neighbours'            => 'CN,NP,MM,BT,PK,BD',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'IQ',
				'iso3'                  => 'IRQ',
				'iso_numeric'           => '368',
				'fips'                  => 'IZ',
				'name'                  => ['en' => 'Iraq'],
				'capital'               => 'Baghdad',
				'area'                  => '437072',
				'population'            => '29671605',
				'continent_code'        => 'AS',
				'tld'                   => '.iq',
				'currency_code'         => 'IQD',
				'phone'                 => '964',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ar-IQ,ku,hy',
				'neighbours'            => 'SY,SA,IR,JO,TR,KW',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'IR',
				'iso3'                  => 'IRN',
				'iso_numeric'           => '364',
				'fips'                  => 'IR',
				'name'                  => ['en' => 'Iran'],
				'capital'               => 'Tehran',
				'area'                  => '1648000',
				'population'            => '76923300',
				'continent_code'        => 'AS',
				'tld'                   => '.ir',
				'currency_code'         => 'IRR',
				'phone'                 => '98',
				'postal_code_format'    => '##########',
				'postal_code_regex'     => '^(d{10})$',
				'languages'             => 'fa-IR,ku',
				'neighbours'            => 'TM,AF,IQ,AM,PK,AZ,TR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'IS',
				'iso3'                  => 'ISL',
				'iso_numeric'           => '352',
				'fips'                  => 'IC',
				'name'                  => ['en' => 'Iceland'],
				'capital'               => 'Reykjavik',
				'area'                  => '103000',
				'population'            => '308910',
				'continent_code'        => 'EU',
				'tld'                   => '.is',
				'currency_code'         => 'ISK',
				'phone'                 => '354',
				'postal_code_format'    => '###',
				'postal_code_regex'     => '^(d{3})$',
				'languages'             => 'is,en,de,da,sv,no',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'IT',
				'iso3'                  => 'ITA',
				'iso_numeric'           => '380',
				'fips'                  => 'IT',
				'name'                  => ['en' => 'Italy'],
				'capital'               => 'Rome',
				'area'                  => '301230',
				'population'            => '60340328',
				'continent_code'        => 'EU',
				'tld'                   => '.it',
				'currency_code'         => 'EUR',
				'phone'                 => '39',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'it-IT,en,de-IT,fr-IT,sc,ca,co,sl',
				'neighbours'            => 'CH,VA,SI,SM,FR,AT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'JE',
				'iso3'                  => 'JEY',
				'iso_numeric'           => '832',
				'fips'                  => 'JE',
				'name'                  => ['en' => 'Jersey'],
				'capital'               => 'Saint Helier',
				'area'                  => '116',
				'population'            => '90812',
				'continent_code'        => 'EU',
				'tld'                   => '.je',
				'currency_code'         => 'GBP',
				'phone'                 => '+44-1534',
				'postal_code_format'    => '@# #@@|@## #@@|@@# #@@|@@## #@@|@#@ #@@|@@#@ #@@|G',
				'postal_code_regex'     => '^(([A-Z]d{2}[A-Z]{2})|([A-Z]d{3}[A-Z]{2})|([A-Z]{2}d{2}[A-Z]{2})|([A-Z]{2}d{3}[A-Z]{2})|([A-Z]d[A-Z]d[A-Z]{2})|([A-Z]{2}d[A-Z]d[A-Z]{2})|(GIR0AA))$',
				'languages'             => 'en,pt',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'JM',
				'iso3'                  => 'JAM',
				'iso_numeric'           => '388',
				'fips'                  => 'JM',
				'name'                  => ['en' => 'Jamaica'],
				'capital'               => 'Kingston',
				'area'                  => '10991',
				'population'            => '2847232',
				'continent_code'        => 'NA',
				'tld'                   => '.jm',
				'currency_code'         => 'JMD',
				'phone'                 => '+1-876',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-JM',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'JO',
				'iso3'                  => 'JOR',
				'iso_numeric'           => '400',
				'fips'                  => 'JO',
				'name'                  => ['en' => 'Jordan'],
				'capital'               => 'Amman',
				'area'                  => '92300',
				'population'            => '6407085',
				'continent_code'        => 'AS',
				'tld'                   => '.jo',
				'currency_code'         => 'JOD',
				'phone'                 => '962',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ar-JO,en',
				'neighbours'            => 'SY,SA,IQ,IL,PS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'JP',
				'iso3'                  => 'JPN',
				'iso_numeric'           => '392',
				'fips'                  => 'JA',
				'name'                  => ['en' => 'Japan'],
				'capital'               => 'Tokyo',
				'area'                  => '377835',
				'population'            => '127288000',
				'continent_code'        => 'AS',
				'tld'                   => '.jp',
				'currency_code'         => 'JPY',
				'phone'                 => '81',
				'postal_code_format'    => '###-####',
				'postal_code_regex'     => '^(d{7})$',
				'languages'             => 'ja',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KE',
				'iso3'                  => 'KEN',
				'iso_numeric'           => '404',
				'fips'                  => 'KE',
				'name'                  => ['en' => 'Kenya'],
				'capital'               => 'Nairobi',
				'area'                  => '582650',
				'population'            => '40046566',
				'continent_code'        => 'AF',
				'tld'                   => '.ke',
				'currency_code'         => 'KES',
				'phone'                 => '254',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'en-KE,sw-KE',
				'neighbours'            => 'ET,TZ,SS,SO,UG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KG',
				'iso3'                  => 'KGZ',
				'iso_numeric'           => '417',
				'fips'                  => 'KG',
				'name'                  => ['en' => 'Kyrgyzstan'],
				'capital'               => 'Bishkek',
				'area'                  => '198500',
				'population'            => '5508626',
				'continent_code'        => 'AS',
				'tld'                   => '.kg',
				'currency_code'         => 'KGS',
				'phone'                 => '996',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'ky,uz,ru',
				'neighbours'            => 'CN,TJ,UZ,KZ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KH',
				'iso3'                  => 'KHM',
				'iso_numeric'           => '116',
				'fips'                  => 'CB',
				'name'                  => ['en' => 'Cambodia'],
				'capital'               => 'Phnom Penh',
				'area'                  => '181040',
				'population'            => '14453680',
				'continent_code'        => 'AS',
				'tld'                   => '.kh',
				'currency_code'         => 'KHR',
				'phone'                 => '855',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'km,fr,en',
				'neighbours'            => 'LA,TH,VN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KI',
				'iso3'                  => 'KIR',
				'iso_numeric'           => '296',
				'fips'                  => 'KR',
				'name'                  => ['en' => 'Kiribati'],
				'capital'               => 'Tarawa',
				'area'                  => '811',
				'population'            => '92533',
				'continent_code'        => 'OC',
				'tld'                   => '.ki',
				'currency_code'         => 'AUD',
				'phone'                 => '686',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-KI,gil',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KM',
				'iso3'                  => 'COM',
				'iso_numeric'           => '174',
				'fips'                  => 'CN',
				'name'                  => ['en' => 'Comoros'],
				'capital'               => 'Moroni',
				'area'                  => '2170',
				'population'            => '773407',
				'continent_code'        => 'AF',
				'tld'                   => '.km',
				'currency_code'         => 'KMF',
				'phone'                 => '269',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar,fr-KM',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KN',
				'iso3'                  => 'KNA',
				'iso_numeric'           => '659',
				'fips'                  => 'SC',
				'name'                  => ['en' => 'Saint Kitts and Nevis'],
				'capital'               => 'Basseterre',
				'area'                  => '261',
				'population'            => '51134',
				'continent_code'        => 'NA',
				'tld'                   => '.kn',
				'currency_code'         => 'XCD',
				'phone'                 => '+1-869',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-KN',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KP',
				'iso3'                  => 'PRK',
				'iso_numeric'           => '408',
				'fips'                  => 'KN',
				'name'                  => ['en' => 'North Korea'],
				'capital'               => 'Pyongyang',
				'area'                  => '120540',
				'population'            => '22912177',
				'continent_code'        => 'AS',
				'tld'                   => '.kp',
				'currency_code'         => 'KPW',
				'phone'                 => '850',
				'postal_code_format'    => '###-###',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'ko-KP',
				'neighbours'            => 'CN,KR,RU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KR',
				'iso3'                  => 'KOR',
				'iso_numeric'           => '410',
				'fips'                  => 'KS',
				'name'                  => ['en' => 'South Korea'],
				'capital'               => 'Seoul',
				'area'                  => '98480',
				'population'            => '48422644',
				'continent_code'        => 'AS',
				'tld'                   => '.kr',
				'currency_code'         => 'KRW',
				'phone'                 => '82',
				'postal_code_format'    => 'SEOUL ###-###',
				'postal_code_regex'     => '^(?:SEOUL)*(d{6})$',
				'languages'             => 'ko-KR,en',
				'neighbours'            => 'KP',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KW',
				'iso3'                  => 'KWT',
				'iso_numeric'           => '414',
				'fips'                  => 'KU',
				'name'                  => ['en' => 'Kuwait'],
				'capital'               => 'Kuwait City',
				'area'                  => '17820',
				'population'            => '2789132',
				'continent_code'        => 'AS',
				'tld'                   => '.kw',
				'currency_code'         => 'KWD',
				'phone'                 => '965',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ar-KW,en',
				'neighbours'            => 'SA,IQ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KY',
				'iso3'                  => 'CYM',
				'iso_numeric'           => '136',
				'fips'                  => 'CJ',
				'name'                  => ['en' => 'Cayman Islands'],
				'capital'               => 'George Town',
				'area'                  => '262',
				'population'            => '44270',
				'continent_code'        => 'NA',
				'tld'                   => '.ky',
				'currency_code'         => 'KYD',
				'phone'                 => '+1-345',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-KY',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'KZ',
				'iso3'                  => 'KAZ',
				'iso_numeric'           => '398',
				'fips'                  => 'KZ',
				'name'                  => ['en' => 'Kazakhstan'],
				'capital'               => 'Astana',
				'area'                  => '2717300',
				'population'            => '15340000',
				'continent_code'        => 'AS',
				'tld'                   => '.kz',
				'currency_code'         => 'KZT',
				'phone'                 => '7',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'kk,ru',
				'neighbours'            => 'TM,CN,KG,UZ,RU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LA',
				'iso3'                  => 'LAO',
				'iso_numeric'           => '418',
				'fips'                  => 'LA',
				'name'                  => ['en' => 'Laos'],
				'capital'               => 'Vientiane',
				'area'                  => '236800',
				'population'            => '6368162',
				'continent_code'        => 'AS',
				'tld'                   => '.la',
				'currency_code'         => 'LAK',
				'phone'                 => '856',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'lo,fr,en',
				'neighbours'            => 'CN,MM,KH,TH,VN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LB',
				'iso3'                  => 'LBN',
				'iso_numeric'           => '422',
				'fips'                  => 'LE',
				'name'                  => ['en' => 'Lebanon'],
				'capital'               => 'Beirut',
				'area'                  => '10400',
				'population'            => '4125247',
				'continent_code'        => 'AS',
				'tld'                   => '.lb',
				'currency_code'         => 'LBP',
				'phone'                 => '961',
				'postal_code_format'    => '#### ####|####',
				'postal_code_regex'     => '^(d{4}(d{4})?)$',
				'languages'             => 'ar-LB,fr-LB,en,hy',
				'neighbours'            => 'SY,IL',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LC',
				'iso3'                  => 'LCA',
				'iso_numeric'           => '662',
				'fips'                  => 'ST',
				'name'                  => ['en' => 'Saint Lucia'],
				'capital'               => 'Castries',
				'area'                  => '616',
				'population'            => '160922',
				'continent_code'        => 'NA',
				'tld'                   => '.lc',
				'currency_code'         => 'XCD',
				'phone'                 => '+1-758',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-LC',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LI',
				'iso3'                  => 'LIE',
				'iso_numeric'           => '438',
				'fips'                  => 'LS',
				'name'                  => ['en' => 'Liechtenstein'],
				'capital'               => 'Vaduz',
				'area'                  => '160',
				'population'            => '35000',
				'continent_code'        => 'EU',
				'tld'                   => '.li',
				'currency_code'         => 'CHF',
				'phone'                 => '423',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'de-LI',
				'neighbours'            => 'CH,AT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LK',
				'iso3'                  => 'LKA',
				'iso_numeric'           => '144',
				'fips'                  => 'CE',
				'name'                  => ['en' => 'Sri Lanka'],
				'capital'               => 'Colombo',
				'area'                  => '65610',
				'population'            => '21513990',
				'continent_code'        => 'AS',
				'tld'                   => '.lk',
				'currency_code'         => 'LKR',
				'phone'                 => '94',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'si,ta,en',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LR',
				'iso3'                  => 'LBR',
				'iso_numeric'           => '430',
				'fips'                  => 'LI',
				'name'                  => ['en' => 'Liberia'],
				'capital'               => 'Monrovia',
				'area'                  => '111370',
				'population'            => '3685076',
				'continent_code'        => 'AF',
				'tld'                   => '.lr',
				'currency_code'         => 'LRD',
				'phone'                 => '231',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'en-LR',
				'neighbours'            => 'SL,CI,GN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LS',
				'iso3'                  => 'LSO',
				'iso_numeric'           => '426',
				'fips'                  => 'LT',
				'name'                  => ['en' => 'Lesotho'],
				'capital'               => 'Maseru',
				'area'                  => '30355',
				'population'            => '1919552',
				'continent_code'        => 'AF',
				'tld'                   => '.ls',
				'currency_code'         => 'LSL',
				'phone'                 => '266',
				'postal_code_format'    => '###',
				'postal_code_regex'     => '^(d{3})$',
				'languages'             => 'en-LS,st,zu,xh',
				'neighbours'            => 'ZA',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LT',
				'iso3'                  => 'LTU',
				'iso_numeric'           => '440',
				'fips'                  => 'LH',
				'name'                  => ['en' => 'Lithuania'],
				'capital'               => 'Vilnius',
				'area'                  => '65200',
				'population'            => '2944459',
				'continent_code'        => 'EU',
				'tld'                   => '.lt',
				'currency_code'         => 'EUR',
				'phone'                 => '370',
				'postal_code_format'    => 'LT-#####',
				'postal_code_regex'     => '^(?:LT)*(d{5})$',
				'languages'             => 'lt,ru,pl',
				'neighbours'            => 'PL,BY,RU,LV',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LU',
				'iso3'                  => 'LUX',
				'iso_numeric'           => '442',
				'fips'                  => 'LU',
				'name'                  => ['en' => 'Luxembourg'],
				'capital'               => 'Luxembourg',
				'area'                  => '2586',
				'population'            => '497538',
				'continent_code'        => 'EU',
				'tld'                   => '.lu',
				'currency_code'         => 'EUR',
				'phone'                 => '352',
				'postal_code_format'    => 'L-####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'lb,de-LU,fr-LU',
				'neighbours'            => 'DE,BE,FR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LV',
				'iso3'                  => 'LVA',
				'iso_numeric'           => '428',
				'fips'                  => 'LG',
				'name'                  => ['en' => 'Latvia'],
				'capital'               => 'Riga',
				'area'                  => '64589',
				'population'            => '2217969',
				'continent_code'        => 'EU',
				'tld'                   => '.lv',
				'currency_code'         => 'EUR',
				'phone'                 => '371',
				'postal_code_format'    => 'LV-####',
				'postal_code_regex'     => '^(?:LV)*(d{4})$',
				'languages'             => 'lv,ru,lt',
				'neighbours'            => 'LT,EE,BY,RU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'LY',
				'iso3'                  => 'LBY',
				'iso_numeric'           => '434',
				'fips'                  => 'LY',
				'name'                  => ['en' => 'Libya'],
				'capital'               => 'Tripolis',
				'area'                  => '1759540',
				'population'            => '6461454',
				'continent_code'        => 'AF',
				'tld'                   => '.ly',
				'currency_code'         => 'LYD',
				'phone'                 => '218',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar-LY,it,en',
				'neighbours'            => 'TD,NE,DZ,SD,TN,EG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MA',
				'iso3'                  => 'MAR',
				'iso_numeric'           => '504',
				'fips'                  => 'MO',
				'name'                  => ['en' => 'Morocco'],
				'capital'               => 'Rabat',
				'area'                  => '446550',
				'population'            => '31627428',
				'continent_code'        => 'AF',
				'tld'                   => '.ma',
				'currency_code'         => 'MAD',
				'phone'                 => '212',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ar-MA,fr',
				'neighbours'            => 'DZ,EH,ES',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MC',
				'iso3'                  => 'MCO',
				'iso_numeric'           => '492',
				'fips'                  => 'MN',
				'name'                  => ['en' => 'Monaco'],
				'capital'               => 'Monaco',
				'area'                  => '2',
				'population'            => '32965',
				'continent_code'        => 'EU',
				'tld'                   => '.mc',
				'currency_code'         => 'EUR',
				'phone'                 => '377',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'fr-MC,en,it',
				'neighbours'            => 'FR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MD',
				'iso3'                  => 'MDA',
				'iso_numeric'           => '498',
				'fips'                  => 'MD',
				'name'                  => ['en' => 'Moldova'],
				'capital'               => 'Chisinau',
				'area'                  => '33843',
				'population'            => '4324000',
				'continent_code'        => 'EU',
				'tld'                   => '.md',
				'currency_code'         => 'MDL',
				'phone'                 => '373',
				'postal_code_format'    => 'MD-####',
				'postal_code_regex'     => '^(?:MD)*(d{4})$',
				'languages'             => 'ro,ru,gag,tr',
				'neighbours'            => 'RO,UA',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ME',
				'iso3'                  => 'MNE',
				'iso_numeric'           => '499',
				'fips'                  => 'MJ',
				'name'                  => ['en' => 'Montenegro'],
				'capital'               => 'Podgorica',
				'area'                  => '14026',
				'population'            => '666730',
				'continent_code'        => 'EU',
				'tld'                   => '.me',
				'currency_code'         => 'EUR',
				'phone'                 => '382',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'sr,hu,bs,sq,hr,rom',
				'neighbours'            => 'AL,HR,BA,RS,XK',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MF',
				'iso3'                  => 'MAF',
				'iso_numeric'           => '663',
				'fips'                  => 'RN',
				'name'                  => ['en' => 'Saint Martin'],
				'capital'               => 'Marigot',
				'area'                  => '53',
				'population'            => '35925',
				'continent_code'        => 'NA',
				'tld'                   => '.gp',
				'currency_code'         => 'EUR',
				'phone'                 => '590',
				'postal_code_format'    => '### ###',
				'postal_code_regex'     => '',
				'languages'             => 'fr',
				'neighbours'            => 'SX',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MG',
				'iso3'                  => 'MDG',
				'iso_numeric'           => '450',
				'fips'                  => 'MA',
				'name'                  => ['en' => 'Madagascar'],
				'capital'               => 'Antananarivo',
				'area'                  => '587040',
				'population'            => '21281844',
				'continent_code'        => 'AF',
				'tld'                   => '.mg',
				'currency_code'         => 'MGA',
				'phone'                 => '261',
				'postal_code_format'    => '###',
				'postal_code_regex'     => '^(d{3})$',
				'languages'             => 'fr-MG,mg',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MH',
				'iso3'                  => 'MHL',
				'iso_numeric'           => '584',
				'fips'                  => 'RM',
				'name'                  => ['en' => 'Marshall Islands'],
				'capital'               => 'Majuro',
				'area'                  => '181',
				'population'            => '65859',
				'continent_code'        => 'OC',
				'tld'                   => '.mh',
				'currency_code'         => 'USD',
				'phone'                 => '692',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'mh,en-MH',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MK',
				'iso3'                  => 'MKD',
				'iso_numeric'           => '807',
				'fips'                  => 'MK',
				'name'                  => ['en' => 'Macedonia'],
				'capital'               => 'Skopje',
				'area'                  => '25333',
				'population'            => '2062294',
				'continent_code'        => 'EU',
				'tld'                   => '.mk',
				'currency_code'         => 'MKD',
				'phone'                 => '389',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'mk,sq,tr,rmm,sr',
				'neighbours'            => 'AL,GR,BG,RS,XK',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ML',
				'iso3'                  => 'MLI',
				'iso_numeric'           => '466',
				'fips'                  => 'ML',
				'name'                  => ['en' => 'Mali'],
				'capital'               => 'Bamako',
				'area'                  => '1240000',
				'population'            => '13796354',
				'continent_code'        => 'AF',
				'tld'                   => '.ml',
				'currency_code'         => 'XOF',
				'phone'                 => '223',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-ML,bm',
				'neighbours'            => 'SN,NE,DZ,CI,GN,MR,BF',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MM',
				'iso3'                  => 'MMR',
				'iso_numeric'           => '104',
				'fips'                  => 'BM',
				'name'                  => ['en' => 'Myanmar'],
				'capital'               => 'Nay Pyi Taw',
				'area'                  => '678500',
				'population'            => '53414374',
				'continent_code'        => 'AS',
				'tld'                   => '.mm',
				'currency_code'         => 'MMK',
				'phone'                 => '95',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'my',
				'neighbours'            => 'CN,LA,TH,BD,IN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MN',
				'iso3'                  => 'MNG',
				'iso_numeric'           => '496',
				'fips'                  => 'MG',
				'name'                  => ['en' => 'Mongolia'],
				'capital'               => 'Ulan Bator',
				'area'                  => '1565000',
				'population'            => '3086918',
				'continent_code'        => 'AS',
				'tld'                   => '.mn',
				'currency_code'         => 'MNT',
				'phone'                 => '976',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'mn,ru',
				'neighbours'            => 'CN,RU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MO',
				'iso3'                  => 'MAC',
				'iso_numeric'           => '446',
				'fips'                  => 'MC',
				'name'                  => ['en' => 'Macao'],
				'capital'               => 'Macao',
				'area'                  => '254',
				'population'            => '449198',
				'continent_code'        => 'AS',
				'tld'                   => '.mo',
				'currency_code'         => 'MOP',
				'phone'                 => '853',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'zh,zh-MO,pt',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MP',
				'iso3'                  => 'MNP',
				'iso_numeric'           => '580',
				'fips'                  => 'CQ',
				'name'                  => ['en' => 'Northern Mariana Islands'],
				'capital'               => 'Saipan',
				'area'                  => '477',
				'population'            => '53883',
				'continent_code'        => 'OC',
				'tld'                   => '.mp',
				'currency_code'         => 'USD',
				'phone'                 => '+1-670',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fil,tl,zh,ch-MP,en-MP',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MQ',
				'iso3'                  => 'MTQ',
				'iso_numeric'           => '474',
				'fips'                  => 'MB',
				'name'                  => ['en' => 'Martinique'],
				'capital'               => 'Fort-de-France',
				'area'                  => '1100',
				'population'            => '432900',
				'continent_code'        => 'NA',
				'tld'                   => '.mq',
				'currency_code'         => 'EUR',
				'phone'                 => '596',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'fr-MQ',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MR',
				'iso3'                  => 'MRT',
				'iso_numeric'           => '478',
				'fips'                  => 'MR',
				'name'                  => ['en' => 'Mauritania'],
				'capital'               => 'Nouakchott',
				'area'                  => '1030700',
				'population'            => '3205060',
				'continent_code'        => 'AF',
				'tld'                   => '.mr',
				'currency_code'         => 'MRO',
				'phone'                 => '222',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar-MR,fuc,snk,fr,mey,wo',
				'neighbours'            => 'SN,DZ,EH,ML',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MS',
				'iso3'                  => 'MSR',
				'iso_numeric'           => '500',
				'fips'                  => 'MH',
				'name'                  => ['en' => 'Montserrat'],
				'capital'               => 'Plymouth',
				'area'                  => '102',
				'population'            => '9341',
				'continent_code'        => 'NA',
				'tld'                   => '.ms',
				'currency_code'         => 'XCD',
				'phone'                 => '+1-664',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-MS',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MT',
				'iso3'                  => 'MLT',
				'iso_numeric'           => '470',
				'fips'                  => 'MT',
				'name'                  => ['en' => 'Malta'],
				'capital'               => 'Valletta',
				'area'                  => '316',
				'population'            => '403000',
				'continent_code'        => 'EU',
				'tld'                   => '.mt',
				'currency_code'         => 'EUR',
				'phone'                 => '356',
				'postal_code_format'    => '@@@ ###|@@@ ##',
				'postal_code_regex'     => '^([A-Z]{3}d{2}d?)$',
				'languages'             => 'mt,en-MT',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MU',
				'iso3'                  => 'MUS',
				'iso_numeric'           => '480',
				'fips'                  => 'MP',
				'name'                  => ['en' => 'Mauritius'],
				'capital'               => 'Port Louis',
				'area'                  => '2040',
				'population'            => '1294104',
				'continent_code'        => 'AF',
				'tld'                   => '.mu',
				'currency_code'         => 'MUR',
				'phone'                 => '230',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-MU,bho,fr',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MV',
				'iso3'                  => 'MDV',
				'iso_numeric'           => '462',
				'fips'                  => 'MV',
				'name'                  => ['en' => 'Maldives'],
				'capital'               => 'Male',
				'area'                  => '300',
				'population'            => '395650',
				'continent_code'        => 'AS',
				'tld'                   => '.mv',
				'currency_code'         => 'MVR',
				'phone'                 => '960',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'dv,en',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MW',
				'iso3'                  => 'MWI',
				'iso_numeric'           => '454',
				'fips'                  => 'MI',
				'name'                  => ['en' => 'Malawi'],
				'capital'               => 'Lilongwe',
				'area'                  => '118480',
				'population'            => '15447500',
				'continent_code'        => 'AF',
				'tld'                   => '.mw',
				'currency_code'         => 'MWK',
				'phone'                 => '265',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ny,yao,tum,swk',
				'neighbours'            => 'TZ,MZ,ZM',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MX',
				'iso3'                  => 'MEX',
				'iso_numeric'           => '484',
				'fips'                  => 'MX',
				'name'                  => ['en' => 'Mexico'],
				'capital'               => 'Mexico City',
				'area'                  => '1972550',
				'population'            => '112468855',
				'continent_code'        => 'NA',
				'tld'                   => '.mx',
				'currency_code'         => 'MXN',
				'phone'                 => '52',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'es-MX',
				'neighbours'            => 'GT,US,BZ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MY',
				'iso3'                  => 'MYS',
				'iso_numeric'           => '458',
				'fips'                  => 'MY',
				'name'                  => ['en' => 'Malaysia'],
				'capital'               => 'Kuala Lumpur',
				'area'                  => '329750',
				'population'            => '28274729',
				'continent_code'        => 'AS',
				'tld'                   => '.my',
				'currency_code'         => 'MYR',
				'phone'                 => '60',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ms-MY,en,zh,ta,te,ml,pa,th',
				'neighbours'            => 'BN,TH,ID',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'MZ',
				'iso3'                  => 'MOZ',
				'iso_numeric'           => '508',
				'fips'                  => 'MZ',
				'name'                  => ['en' => 'Mozambique'],
				'capital'               => 'Maputo',
				'area'                  => '801590',
				'population'            => '22061451',
				'continent_code'        => 'AF',
				'tld'                   => '.mz',
				'currency_code'         => 'MZN',
				'phone'                 => '258',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'pt-MZ,vmw',
				'neighbours'            => 'ZW,TZ,SZ,ZA,ZM,MW',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NA',
				'iso3'                  => 'NAM',
				'iso_numeric'           => '516',
				'fips'                  => 'WA',
				'name'                  => ['en' => 'Namibia'],
				'capital'               => 'Windhoek',
				'area'                  => '825418',
				'population'            => '2128471',
				'continent_code'        => 'AF',
				'tld'                   => '.na',
				'currency_code'         => 'NAD',
				'phone'                 => '264',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-NA,af,de,hz,naq',
				'neighbours'            => 'ZA,BW,ZM,AO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NC',
				'iso3'                  => 'NCL',
				'iso_numeric'           => '540',
				'fips'                  => 'NC',
				'name'                  => ['en' => 'New Caledonia'],
				'capital'               => 'Noumea',
				'area'                  => '19060',
				'population'            => '216494',
				'continent_code'        => 'OC',
				'tld'                   => '.nc',
				'currency_code'         => 'XPF',
				'phone'                 => '687',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'fr-NC',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NE',
				'iso3'                  => 'NER',
				'iso_numeric'           => '562',
				'fips'                  => 'NG',
				'name'                  => ['en' => 'Niger'],
				'capital'               => 'Niamey',
				'area'                  => '1267000',
				'population'            => '15878271',
				'continent_code'        => 'AF',
				'tld'                   => '.ne',
				'currency_code'         => 'XOF',
				'phone'                 => '227',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'fr-NE,ha,kr,dje',
				'neighbours'            => 'TD,BJ,DZ,LY,BF,NG,ML',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NF',
				'iso3'                  => 'NFK',
				'iso_numeric'           => '574',
				'fips'                  => 'NF',
				'name'                  => ['en' => 'Norfolk Island'],
				'capital'               => 'Kingston',
				'area'                  => '35',
				'population'            => '1828',
				'continent_code'        => 'OC',
				'tld'                   => '.nf',
				'currency_code'         => 'AUD',
				'phone'                 => '672',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'en-NF',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NG',
				'iso3'                  => 'NGA',
				'iso_numeric'           => '566',
				'fips'                  => 'NI',
				'name'                  => ['en' => 'Nigeria'],
				'capital'               => 'Abuja',
				'area'                  => '923768',
				'population'            => '154000000',
				'continent_code'        => 'AF',
				'tld'                   => '.ng',
				'currency_code'         => 'NGN',
				'phone'                 => '234',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'en-NG,ha,yo,ig,ff',
				'neighbours'            => 'TD,NE,BJ,CM',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NI',
				'iso3'                  => 'NIC',
				'iso_numeric'           => '558',
				'fips'                  => 'NU',
				'name'                  => ['en' => 'Nicaragua'],
				'capital'               => 'Managua',
				'area'                  => '129494',
				'population'            => '5995928',
				'continent_code'        => 'NA',
				'tld'                   => '.ni',
				'currency_code'         => 'NIO',
				'phone'                 => '505',
				'postal_code_format'    => '###-###-#',
				'postal_code_regex'     => '^(d{7})$',
				'languages'             => 'es-NI,en',
				'neighbours'            => 'CR,HN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NL',
				'iso3'                  => 'NLD',
				'iso_numeric'           => '528',
				'fips'                  => 'NL',
				'name'                  => ['en' => 'Netherlands'],
				'capital'               => 'Amsterdam',
				'area'                  => '41526',
				'population'            => '16645000',
				'continent_code'        => 'EU',
				'tld'                   => '.nl',
				'currency_code'         => 'EUR',
				'phone'                 => '31',
				'postal_code_format'    => '#### @@',
				'postal_code_regex'     => '^(d{4}[A-Z]{2})$',
				'languages'             => 'nl-NL,fy-NL',
				'neighbours'            => 'DE,BE',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NO',
				'iso3'                  => 'NOR',
				'iso_numeric'           => '578',
				'fips'                  => 'NO',
				'name'                  => ['en' => 'Norway'],
				'capital'               => 'Oslo',
				'area'                  => '324220',
				'population'            => '5009150',
				'continent_code'        => 'EU',
				'tld'                   => '.no',
				'currency_code'         => 'NOK',
				'phone'                 => '47',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'no,nb,nn,se,fi',
				'neighbours'            => 'FI,RU,SE',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NP',
				'iso3'                  => 'NPL',
				'iso_numeric'           => '524',
				'fips'                  => 'NP',
				'name'                  => ['en' => 'Nepal'],
				'capital'               => 'Kathmandu',
				'area'                  => '140800',
				'population'            => '28951852',
				'continent_code'        => 'AS',
				'tld'                   => '.np',
				'currency_code'         => 'NPR',
				'phone'                 => '977',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ne,en',
				'neighbours'            => 'CN,IN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NR',
				'iso3'                  => 'NRU',
				'iso_numeric'           => '520',
				'fips'                  => 'NR',
				'name'                  => ['en' => 'Nauru'],
				'capital'               => 'Yaren',
				'area'                  => '21',
				'population'            => '10065',
				'continent_code'        => 'OC',
				'tld'                   => '.nr',
				'currency_code'         => 'AUD',
				'phone'                 => '674',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'na,en-NR',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NU',
				'iso3'                  => 'NIU',
				'iso_numeric'           => '570',
				'fips'                  => 'NE',
				'name'                  => ['en' => 'Niue'],
				'capital'               => 'Alofi',
				'area'                  => '260',
				'population'            => '2166',
				'continent_code'        => 'OC',
				'tld'                   => '.nu',
				'currency_code'         => 'NZD',
				'phone'                 => '683',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'niu,en-NU',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'NZ',
				'iso3'                  => 'NZL',
				'iso_numeric'           => '554',
				'fips'                  => 'NZ',
				'name'                  => ['en' => 'New Zealand'],
				'capital'               => 'Wellington',
				'area'                  => '268680',
				'population'            => '4252277',
				'continent_code'        => 'OC',
				'tld'                   => '.nz',
				'currency_code'         => 'NZD',
				'phone'                 => '64',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'en-NZ,mi',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'OM',
				'iso3'                  => 'OMN',
				'iso_numeric'           => '512',
				'fips'                  => 'MU',
				'name'                  => ['en' => 'Oman'],
				'capital'               => 'Muscat',
				'area'                  => '212460',
				'population'            => '2967717',
				'continent_code'        => 'AS',
				'tld'                   => '.om',
				'currency_code'         => 'OMR',
				'phone'                 => '968',
				'postal_code_format'    => '###',
				'postal_code_regex'     => '^(d{3})$',
				'languages'             => 'ar-OM,en,bal,ur',
				'neighbours'            => 'SA,YE,AE',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PA',
				'iso3'                  => 'PAN',
				'iso_numeric'           => '591',
				'fips'                  => 'PM',
				'name'                  => ['en' => 'Panama'],
				'capital'               => 'Panama City',
				'area'                  => '78200',
				'population'            => '3410676',
				'continent_code'        => 'NA',
				'tld'                   => '.pa',
				'currency_code'         => 'PAB',
				'phone'                 => '507',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'es-PA,en',
				'neighbours'            => 'CR,CO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PE',
				'iso3'                  => 'PER',
				'iso_numeric'           => '604',
				'fips'                  => 'PE',
				'name'                  => ['en' => 'Peru'],
				'capital'               => 'Lima',
				'area'                  => '1285220',
				'population'            => '29907003',
				'continent_code'        => 'SA',
				'tld'                   => '.pe',
				'currency_code'         => 'PEN',
				'phone'                 => '51',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'es-PE,qu,ay',
				'neighbours'            => 'EC,CL,BO,BR,CO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PF',
				'iso3'                  => 'PYF',
				'iso_numeric'           => '258',
				'fips'                  => 'FP',
				'name'                  => ['en' => 'French Polynesia'],
				'capital'               => 'Papeete',
				'area'                  => '4167',
				'population'            => '270485',
				'continent_code'        => 'OC',
				'tld'                   => '.pf',
				'currency_code'         => 'XPF',
				'phone'                 => '689',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^((97|98)7d{2})$',
				'languages'             => 'fr-PF,ty',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PG',
				'iso3'                  => 'PNG',
				'iso_numeric'           => '598',
				'fips'                  => 'PP',
				'name'                  => ['en' => 'Papua New Guinea'],
				'capital'               => 'Port Moresby',
				'area'                  => '462840',
				'population'            => '6064515',
				'continent_code'        => 'OC',
				'tld'                   => '.pg',
				'currency_code'         => 'PGK',
				'phone'                 => '675',
				'postal_code_format'    => '###',
				'postal_code_regex'     => '^(d{3})$',
				'languages'             => 'en-PG,ho,meu,tpi',
				'neighbours'            => 'ID',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PH',
				'iso3'                  => 'PHL',
				'iso_numeric'           => '608',
				'fips'                  => 'RP',
				'name'                  => ['en' => 'Philippines'],
				'capital'               => 'Manila',
				'area'                  => '300000',
				'population'            => '99900177',
				'continent_code'        => 'AS',
				'tld'                   => '.ph',
				'currency_code'         => 'PHP',
				'phone'                 => '63',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'tl,en-PH,fil',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PK',
				'iso3'                  => 'PAK',
				'iso_numeric'           => '586',
				'fips'                  => 'PK',
				'name'                  => ['en' => 'Pakistan'],
				'capital'               => 'Islamabad',
				'area'                  => '803940',
				'population'            => '184404791',
				'continent_code'        => 'AS',
				'tld'                   => '.pk',
				'currency_code'         => 'PKR',
				'phone'                 => '92',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ur-PK,en-PK,pa,sd,ps,brh',
				'neighbours'            => 'CN,AF,IR,IN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PL',
				'iso3'                  => 'POL',
				'iso_numeric'           => '616',
				'fips'                  => 'PL',
				'name'                  => ['en' => 'Poland'],
				'capital'               => 'Warsaw',
				'area'                  => '312685',
				'population'            => '38500000',
				'continent_code'        => 'EU',
				'tld'                   => '.pl',
				'currency_code'         => 'PLN',
				'phone'                 => '48',
				'postal_code_format'    => '##-###',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'pl',
				'neighbours'            => 'DE,LT,SK,CZ,BY,UA,RU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PM',
				'iso3'                  => 'SPM',
				'iso_numeric'           => '666',
				'fips'                  => 'SB',
				'name'                  => ['en' => 'Saint Pierre and Miquelon'],
				'capital'               => 'Saint-Pierre',
				'area'                  => '242',
				'population'            => '7012',
				'continent_code'        => 'NA',
				'tld'                   => '.pm',
				'currency_code'         => 'EUR',
				'phone'                 => '508',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(97500)$',
				'languages'             => 'fr-PM',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PN',
				'iso3'                  => 'PCN',
				'iso_numeric'           => '612',
				'fips'                  => 'PC',
				'name'                  => ['en' => 'Pitcairn'],
				'capital'               => 'Adamstown',
				'area'                  => '47',
				'population'            => '46',
				'continent_code'        => 'OC',
				'tld'                   => '.pn',
				'currency_code'         => 'NZD',
				'phone'                 => '870',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-PN',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PR',
				'iso3'                  => 'PRI',
				'iso_numeric'           => '630',
				'fips'                  => 'RQ',
				'name'                  => ['en' => 'Puerto Rico'],
				'capital'               => 'San Juan',
				'area'                  => '9104',
				'population'            => '3916632',
				'continent_code'        => 'NA',
				'tld'                   => '.pr',
				'currency_code'         => 'USD',
				'phone'                 => '+1-787/1-939',
				'postal_code_format'    => '#####-####',
				'postal_code_regex'     => '^(d{9})$',
				'languages'             => 'en-PR,es-PR',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PS',
				'iso3'                  => 'PSE',
				'iso_numeric'           => '275',
				'fips'                  => 'WE',
				'name'                  => ['en' => 'Palestine'],
				'capital'               => 'East Jerusalem',
				'area'                  => '5970',
				'population'            => '3800000',
				'continent_code'        => 'AS',
				'tld'                   => '.ps',
				'currency_code'         => 'ILS',
				'phone'                 => '970',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar-PS',
				'neighbours'            => 'JO,IL,EG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PT',
				'iso3'                  => 'PRT',
				'iso_numeric'           => '620',
				'fips'                  => 'PO',
				'name'                  => ['en' => 'Portugal'],
				'capital'               => 'Lisbon',
				'area'                  => '92391',
				'population'            => '10676000',
				'continent_code'        => 'EU',
				'tld'                   => '.pt',
				'currency_code'         => 'EUR',
				'phone'                 => '351',
				'postal_code_format'    => '####-###',
				'postal_code_regex'     => '^(d{7})$',
				'languages'             => 'pt-PT,mwl',
				'neighbours'            => 'ES',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PW',
				'iso3'                  => 'PLW',
				'iso_numeric'           => '585',
				'fips'                  => 'PS',
				'name'                  => ['en' => 'Palau'],
				'capital'               => 'Melekeok',
				'area'                  => '458',
				'population'            => '19907',
				'continent_code'        => 'OC',
				'tld'                   => '.pw',
				'currency_code'         => 'USD',
				'phone'                 => '680',
				'postal_code_format'    => '96940',
				'postal_code_regex'     => '^(96940)$',
				'languages'             => 'pau,sov,en-PW,tox,ja,fil,zh',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'PY',
				'iso3'                  => 'PRY',
				'iso_numeric'           => '600',
				'fips'                  => 'PA',
				'name'                  => ['en' => 'Paraguay'],
				'capital'               => 'Asuncion',
				'area'                  => '406750',
				'population'            => '6375830',
				'continent_code'        => 'SA',
				'tld'                   => '.py',
				'currency_code'         => 'PYG',
				'phone'                 => '595',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'es-PY,gn',
				'neighbours'            => 'BO,BR,AR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'QA',
				'iso3'                  => 'QAT',
				'iso_numeric'           => '634',
				'fips'                  => 'QA',
				'name'                  => ['en' => 'Qatar'],
				'capital'               => 'Doha',
				'area'                  => '11437',
				'population'            => '840926',
				'continent_code'        => 'AS',
				'tld'                   => '.qa',
				'currency_code'         => 'QAR',
				'phone'                 => '974',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar-QA,en',
				'neighbours'            => 'SA',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'RE',
				'iso3'                  => 'REU',
				'iso_numeric'           => '638',
				'fips'                  => 'RE',
				'name'                  => ['en' => 'Reunion'],
				'capital'               => 'Saint-Denis',
				'area'                  => '2517',
				'population'            => '776948',
				'continent_code'        => 'AF',
				'tld'                   => '.re',
				'currency_code'         => 'EUR',
				'phone'                 => '262',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^((97|98)(4|7|8)d{2})$',
				'languages'             => 'fr-RE',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'RO',
				'iso3'                  => 'ROU',
				'iso_numeric'           => '642',
				'fips'                  => 'RO',
				'name'                  => ['en' => 'Romania'],
				'capital'               => 'Bucharest',
				'area'                  => '237500',
				'population'            => '21959278',
				'continent_code'        => 'EU',
				'tld'                   => '.ro',
				'currency_code'         => 'RON',
				'phone'                 => '40',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'ro,hu,rom',
				'neighbours'            => 'MD,HU,UA,BG,RS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'RS',
				'iso3'                  => 'SRB',
				'iso_numeric'           => '688',
				'fips'                  => 'RI',
				'name'                  => ['en' => 'Serbia'],
				'capital'               => 'Belgrade',
				'area'                  => '88361',
				'population'            => '7344847',
				'continent_code'        => 'EU',
				'tld'                   => '.rs',
				'currency_code'         => 'RSD',
				'phone'                 => '381',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'sr,hu,bs,rom',
				'neighbours'            => 'AL,HU,MK,RO,HR,BA,BG,ME,XK',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'RU',
				'iso3'                  => 'RUS',
				'iso_numeric'           => '643',
				'fips'                  => 'RS',
				'name'                  => ['en' => 'Russia'],
				'capital'               => 'Moscow',
				'area'                  => '17100000',
				'population'            => '140702000',
				'continent_code'        => 'EU',
				'tld'                   => '.ru',
				'currency_code'         => 'RUB',
				'phone'                 => '7',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'ru,tt,xal,cau,ady,kv,ce,tyv,cv,udm,tut,mns,bua,myv',
				'neighbours'            => 'GE,CN,BY,UA,KZ,LV,PL,EE,LT,FI,MN,NO,AZ,KP',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'RW',
				'iso3'                  => 'RWA',
				'iso_numeric'           => '646',
				'fips'                  => 'RW',
				'name'                  => ['en' => 'Rwanda'],
				'capital'               => 'Kigali',
				'area'                  => '26338',
				'population'            => '11055976',
				'continent_code'        => 'AF',
				'tld'                   => '.rw',
				'currency_code'         => 'RWF',
				'phone'                 => '250',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'rw,en-RW,fr-RW,sw',
				'neighbours'            => 'TZ,CD,BI,UG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SA',
				'iso3'                  => 'SAU',
				'iso_numeric'           => '682',
				'fips'                  => 'SA',
				'name'                  => ['en' => 'Saudi Arabia'],
				'capital'               => 'Riyadh',
				'area'                  => '1960582',
				'population'            => '25731776',
				'continent_code'        => 'AS',
				'tld'                   => '.sa',
				'currency_code'         => 'SAR',
				'phone'                 => '966',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ar-SA',
				'neighbours'            => 'QA,OM,IQ,YE,JO,AE,KW',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SB',
				'iso3'                  => 'SLB',
				'iso_numeric'           => '90',
				'fips'                  => 'BP',
				'name'                  => ['en' => 'Solomon Islands'],
				'capital'               => 'Honiara',
				'area'                  => '28450',
				'population'            => '559198',
				'continent_code'        => 'OC',
				'tld'                   => '.sb',
				'currency_code'         => 'SBD',
				'phone'                 => '677',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-SB,tpi',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SC',
				'iso3'                  => 'SYC',
				'iso_numeric'           => '690',
				'fips'                  => 'SE',
				'name'                  => ['en' => 'Seychelles'],
				'capital'               => 'Victoria',
				'area'                  => '455',
				'population'            => '88340',
				'continent_code'        => 'AF',
				'tld'                   => '.sc',
				'currency_code'         => 'SCR',
				'phone'                 => '248',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-SC,fr-SC',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SD',
				'iso3'                  => 'SDN',
				'iso_numeric'           => '729',
				'fips'                  => 'SU',
				'name'                  => ['en' => 'Sudan'],
				'capital'               => 'Khartoum',
				'area'                  => '1861484',
				'population'            => '35000000',
				'continent_code'        => 'AF',
				'tld'                   => '.sd',
				'currency_code'         => 'SDG',
				'phone'                 => '249',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'ar-SD,en,fia',
				'neighbours'            => 'SS,TD,EG,ET,ER,LY,CF',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SE',
				'iso3'                  => 'SWE',
				'iso_numeric'           => '752',
				'fips'                  => 'SW',
				'name'                  => ['en' => 'Sweden'],
				'capital'               => 'Stockholm',
				'area'                  => '449964',
				'population'            => '9555893',
				'continent_code'        => 'EU',
				'tld'                   => '.se',
				'currency_code'         => 'SEK',
				'phone'                 => '46',
				'postal_code_format'    => '### ##',
				'postal_code_regex'     => '^(?:SE)*(d{5})$',
				'languages'             => 'sv-SE,se,sma,fi-SE',
				'neighbours'            => 'NO,FI',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SG',
				'iso3'                  => 'SGP',
				'iso_numeric'           => '702',
				'fips'                  => 'SN',
				'name'                  => ['en' => 'Singapore'],
				'capital'               => 'Singapur',
				'area'                  => '693',
				'population'            => '4701069',
				'continent_code'        => 'AS',
				'tld'                   => '.sg',
				'currency_code'         => 'SGD',
				'phone'                 => '65',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'cmn,en-SG,ms-SG,ta-SG,zh-SG',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SH',
				'iso3'                  => 'SHN',
				'iso_numeric'           => '654',
				'fips'                  => 'SH',
				'name'                  => ['en' => 'Saint Helena'],
				'capital'               => 'Jamestown',
				'area'                  => '410',
				'population'            => '7460',
				'continent_code'        => 'AF',
				'tld'                   => '.sh',
				'currency_code'         => 'SHP',
				'phone'                 => '290',
				'postal_code_format'    => 'STHL 1ZZ',
				'postal_code_regex'     => '^(STHL1ZZ)$',
				'languages'             => 'en-SH',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SI',
				'iso3'                  => 'SVN',
				'iso_numeric'           => '705',
				'fips'                  => 'SI',
				'name'                  => ['en' => 'Slovenia'],
				'capital'               => 'Ljubljana',
				'area'                  => '20273',
				'population'            => '2007000',
				'continent_code'        => 'EU',
				'tld'                   => '.si',
				'currency_code'         => 'EUR',
				'phone'                 => '386',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(?:SI)*(d{4})$',
				'languages'             => 'sl,sh',
				'neighbours'            => 'HU,IT,HR,AT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SK',
				'iso3'                  => 'SVK',
				'iso_numeric'           => '703',
				'fips'                  => 'LO',
				'name'                  => ['en' => 'Slovakia'],
				'capital'               => 'Bratislava',
				'area'                  => '48845',
				'population'            => '5455000',
				'continent_code'        => 'EU',
				'tld'                   => '.sk',
				'currency_code'         => 'EUR',
				'phone'                 => '421',
				'postal_code_format'    => '### ##',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'sk,hu',
				'neighbours'            => 'PL,HU,CZ,UA,AT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SL',
				'iso3'                  => 'SLE',
				'iso_numeric'           => '694',
				'fips'                  => 'SL',
				'name'                  => ['en' => 'Sierra Leone'],
				'capital'               => 'Freetown',
				'area'                  => '71740',
				'population'            => '5245695',
				'continent_code'        => 'AF',
				'tld'                   => '.sl',
				'currency_code'         => 'SLL',
				'phone'                 => '232',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-SL,men,tem',
				'neighbours'            => 'LR,GN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SM',
				'iso3'                  => 'SMR',
				'iso_numeric'           => '674',
				'fips'                  => 'SM',
				'name'                  => ['en' => 'San Marino'],
				'capital'               => 'San Marino',
				'area'                  => '61',
				'population'            => '31477',
				'continent_code'        => 'EU',
				'tld'                   => '.sm',
				'currency_code'         => 'EUR',
				'phone'                 => '378',
				'postal_code_format'    => '4789#',
				'postal_code_regex'     => '^(4789d)$',
				'languages'             => 'it-SM',
				'neighbours'            => 'IT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SN',
				'iso3'                  => 'SEN',
				'iso_numeric'           => '686',
				'fips'                  => 'SG',
				'name'                  => ['en' => 'Senegal'],
				'capital'               => 'Dakar',
				'area'                  => '196190',
				'population'            => '12323252',
				'continent_code'        => 'AF',
				'tld'                   => '.sn',
				'currency_code'         => 'XOF',
				'phone'                 => '221',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'fr-SN,wo,fuc,mnk',
				'neighbours'            => 'GN,MR,GW,GM,ML',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SO',
				'iso3'                  => 'SOM',
				'iso_numeric'           => '706',
				'fips'                  => 'SO',
				'name'                  => ['en' => 'Somalia'],
				'capital'               => 'Mogadishu',
				'area'                  => '637657',
				'population'            => '10112453',
				'continent_code'        => 'AF',
				'tld'                   => '.so',
				'currency_code'         => 'SOS',
				'phone'                 => '252',
				'postal_code_format'    => '@@  #####',
				'postal_code_regex'     => '^([A-Z]{2}d{5})$',
				'languages'             => 'so-SO,ar-SO,it,en-SO',
				'neighbours'            => 'ET,KE,DJ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SR',
				'iso3'                  => 'SUR',
				'iso_numeric'           => '740',
				'fips'                  => 'NS',
				'name'                  => ['en' => 'Suriname'],
				'capital'               => 'Paramaribo',
				'area'                  => '163270',
				'population'            => '492829',
				'continent_code'        => 'SA',
				'tld'                   => '.sr',
				'currency_code'         => 'SRD',
				'phone'                 => '597',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'nl-SR,en,srn,hns,jv',
				'neighbours'            => 'GY,BR,GF',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SS',
				'iso3'                  => 'SSD',
				'iso_numeric'           => '728',
				'fips'                  => 'OD',
				'name'                  => ['en' => 'South Sudan'],
				'capital'               => 'Juba',
				'area'                  => '644329',
				'population'            => '8260490',
				'continent_code'        => 'AF',
				'tld'                   => '',
				'currency_code'         => 'SSP',
				'phone'                 => '211',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en',
				'neighbours'            => 'CD,CF,ET,KE,SD,UG,',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ST',
				'iso3'                  => 'STP',
				'iso_numeric'           => '678',
				'fips'                  => 'TP',
				'name'                  => ['en' => 'Sao Tome and Principe'],
				'capital'               => 'Sao Tome',
				'area'                  => '1001',
				'population'            => '175808',
				'continent_code'        => 'AF',
				'tld'                   => '.st',
				'currency_code'         => 'STD',
				'phone'                 => '239',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'pt-ST',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SV',
				'iso3'                  => 'SLV',
				'iso_numeric'           => '222',
				'fips'                  => 'ES',
				'name'                  => ['en' => 'El Salvador'],
				'capital'               => 'San Salvador',
				'area'                  => '21040',
				'population'            => '6052064',
				'continent_code'        => 'NA',
				'tld'                   => '.sv',
				'currency_code'         => 'USD',
				'phone'                 => '503',
				'postal_code_format'    => 'CP ####',
				'postal_code_regex'     => '^(?:CP)*(d{4})$',
				'languages'             => 'es-SV',
				'neighbours'            => 'GT,HN',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SX',
				'iso3'                  => 'SXM',
				'iso_numeric'           => '534',
				'fips'                  => 'NN',
				'name'                  => ['en' => 'Sint Maarten'],
				'capital'               => 'Philipsburg',
				'area'                  => '21',
				'population'            => '37429',
				'continent_code'        => 'NA',
				'tld'                   => '.sx',
				'currency_code'         => 'ANG',
				'phone'                 => '599',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'nl,en',
				'neighbours'            => 'MF',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SY',
				'iso3'                  => 'SYR',
				'iso_numeric'           => '760',
				'fips'                  => 'SY',
				'name'                  => ['en' => 'Syria'],
				'capital'               => 'Damascus',
				'area'                  => '185180',
				'population'            => '22198110',
				'continent_code'        => 'AS',
				'tld'                   => '.sy',
				'currency_code'         => 'SYP',
				'phone'                 => '963',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar-SY,ku,hy,arc,fr,en',
				'neighbours'            => 'IQ,JO,IL,TR,LB',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'SZ',
				'iso3'                  => 'SWZ',
				'iso_numeric'           => '748',
				'fips'                  => 'WZ',
				'name'                  => ['en' => 'Swaziland'],
				'capital'               => 'Mbabane',
				'area'                  => '17363',
				'population'            => '1354051',
				'continent_code'        => 'AF',
				'tld'                   => '.sz',
				'currency_code'         => 'SZL',
				'phone'                 => '268',
				'postal_code_format'    => '@###',
				'postal_code_regex'     => '^([A-Z]d{3})$',
				'languages'             => 'en-SZ,ss-SZ',
				'neighbours'            => 'ZA,MZ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TC',
				'iso3'                  => 'TCA',
				'iso_numeric'           => '796',
				'fips'                  => 'TK',
				'name'                  => ['en' => 'Turks and Caicos Islands'],
				'capital'               => 'Cockburn Town',
				'area'                  => '430',
				'population'            => '20556',
				'continent_code'        => 'NA',
				'tld'                   => '.tc',
				'currency_code'         => 'USD',
				'phone'                 => '+1-649',
				'postal_code_format'    => 'TKCA 1ZZ',
				'postal_code_regex'     => '^(TKCA 1ZZ)$',
				'languages'             => 'en-TC',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TD',
				'iso3'                  => 'TCD',
				'iso_numeric'           => '148',
				'fips'                  => 'CD',
				'name'                  => ['en' => 'Chad'],
				'capital'               => 'N\'Djamena',
				'area'                  => '1284000',
				'population'            => '10543464',
				'continent_code'        => 'AF',
				'tld'                   => '.td',
				'currency_code'         => 'XAF',
				'phone'                 => '235',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-TD,ar-TD,sre',
				'neighbours'            => 'NE,LY,CF,SD,CM,NG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TG',
				'iso3'                  => 'TGO',
				'iso_numeric'           => '768',
				'fips'                  => 'TO',
				'name'                  => ['en' => 'Togo'],
				'capital'               => 'Lome',
				'area'                  => '56785',
				'population'            => '6587239',
				'continent_code'        => 'AF',
				'tld'                   => '.tg',
				'currency_code'         => 'XOF',
				'phone'                 => '228',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'fr-TG,ee,hna,kbp,dag,ha',
				'neighbours'            => 'BJ,GH,BF',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TH',
				'iso3'                  => 'THA',
				'iso_numeric'           => '764',
				'fips'                  => 'TH',
				'name'                  => ['en' => 'Thailand'],
				'capital'               => 'Bangkok',
				'area'                  => '514000',
				'population'            => '67089500',
				'continent_code'        => 'AS',
				'tld'                   => '.th',
				'currency_code'         => 'THB',
				'phone'                 => '66',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'th,en',
				'neighbours'            => 'LA,MM,KH,MY',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TJ',
				'iso3'                  => 'TJK',
				'iso_numeric'           => '762',
				'fips'                  => 'TI',
				'name'                  => ['en' => 'Tajikistan'],
				'capital'               => 'Dushanbe',
				'area'                  => '143100',
				'population'            => '7487489',
				'continent_code'        => 'AS',
				'tld'                   => '.tj',
				'currency_code'         => 'TJS',
				'phone'                 => '992',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'tg,ru',
				'neighbours'            => 'CN,AF,KG,UZ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TK',
				'iso3'                  => 'TKL',
				'iso_numeric'           => '772',
				'fips'                  => 'TL',
				'name'                  => ['en' => 'Tokelau'],
				'capital'               => '',
				'area'                  => '10',
				'population'            => '1466',
				'continent_code'        => 'OC',
				'tld'                   => '.tk',
				'currency_code'         => 'NZD',
				'phone'                 => '690',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'tkl,en-TK',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TL',
				'iso3'                  => 'TLS',
				'iso_numeric'           => '626',
				'fips'                  => 'TT',
				'name'                  => ['en' => 'East Timor'],
				'capital'               => 'Dili',
				'area'                  => '15007',
				'population'            => '1154625',
				'continent_code'        => 'OC',
				'tld'                   => '.tl',
				'currency_code'         => 'USD',
				'phone'                 => '670',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'tet,pt-TL,id,en',
				'neighbours'            => 'ID',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TM',
				'iso3'                  => 'TKM',
				'iso_numeric'           => '795',
				'fips'                  => 'TX',
				'name'                  => ['en' => 'Turkmenistan'],
				'capital'               => 'Ashgabat',
				'area'                  => '488100',
				'population'            => '4940916',
				'continent_code'        => 'AS',
				'tld'                   => '.tm',
				'currency_code'         => 'TMT',
				'phone'                 => '993',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'tk,ru,uz',
				'neighbours'            => 'AF,IR,UZ,KZ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TN',
				'iso3'                  => 'TUN',
				'iso_numeric'           => '788',
				'fips'                  => 'TS',
				'name'                  => ['en' => 'Tunisia'],
				'capital'               => 'Tunis',
				'area'                  => '163610',
				'population'            => '10589025',
				'continent_code'        => 'AF',
				'tld'                   => '.tn',
				'currency_code'         => 'TND',
				'phone'                 => '216',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'ar-TN,fr',
				'neighbours'            => 'DZ,LY',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TO',
				'iso3'                  => 'TON',
				'iso_numeric'           => '776',
				'fips'                  => 'TN',
				'name'                  => ['en' => 'Tonga'],
				'capital'               => 'Nuku\'alofa',
				'area'                  => '748',
				'population'            => '122580',
				'continent_code'        => 'OC',
				'tld'                   => '.to',
				'currency_code'         => 'TOP',
				'phone'                 => '676',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'to,en-TO',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TR',
				'iso3'                  => 'TUR',
				'iso_numeric'           => '792',
				'fips'                  => 'TU',
				'name'                  => ['en' => 'Turkey'],
				'capital'               => 'Ankara',
				'area'                  => '780580',
				'population'            => '77804122',
				'continent_code'        => 'AS',
				'tld'                   => '.tr',
				'currency_code'         => 'TRY',
				'phone'                 => '90',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'tr-TR,ku,diq,az,av',
				'neighbours'            => 'SY,GE,IQ,IR,GR,AM,AZ,BG',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TT',
				'iso3'                  => 'TTO',
				'iso_numeric'           => '780',
				'fips'                  => 'TD',
				'name'                  => ['en' => 'Trinidad and Tobago'],
				'capital'               => 'Port of Spain',
				'area'                  => '5128',
				'population'            => '1228691',
				'continent_code'        => 'NA',
				'tld'                   => '.tt',
				'currency_code'         => 'TTD',
				'phone'                 => '+1-868',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-TT,hns,fr,es,zh',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TV',
				'iso3'                  => 'TUV',
				'iso_numeric'           => '798',
				'fips'                  => 'TV',
				'name'                  => ['en' => 'Tuvalu'],
				'capital'               => 'Funafuti',
				'area'                  => '26',
				'population'            => '10472',
				'continent_code'        => 'OC',
				'tld'                   => '.tv',
				'currency_code'         => 'AUD',
				'phone'                 => '688',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'tvl,en,sm,gil',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TW',
				'iso3'                  => 'TWN',
				'iso_numeric'           => '158',
				'fips'                  => 'TW',
				'name'                  => ['en' => 'Taiwan'],
				'capital'               => 'Taipei',
				'area'                  => '35980',
				'population'            => '22894384',
				'continent_code'        => 'AS',
				'tld'                   => '.tw',
				'currency_code'         => 'TWD',
				'phone'                 => '886',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'zh-TW,zh,nan,hak',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'TZ',
				'iso3'                  => 'TZA',
				'iso_numeric'           => '834',
				'fips'                  => 'TZ',
				'name'                  => ['en' => 'Tanzania'],
				'capital'               => 'Dodoma',
				'area'                  => '945087',
				'population'            => '41892895',
				'continent_code'        => 'AF',
				'tld'                   => '.tz',
				'currency_code'         => 'TZS',
				'phone'                 => '255',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'sw-TZ,en,ar',
				'neighbours'            => 'MZ,KE,CD,RW,ZM,BI,UG,MW',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'UA',
				'iso3'                  => 'UKR',
				'iso_numeric'           => '804',
				'fips'                  => 'UP',
				'name'                  => ['en' => 'Ukraine'],
				'capital'               => 'Kiev',
				'area'                  => '603700',
				'population'            => '45415596',
				'continent_code'        => 'EU',
				'tld'                   => '.ua',
				'currency_code'         => 'UAH',
				'phone'                 => '380',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'uk,ru-UA,rom,pl,hu',
				'neighbours'            => 'PL,MD,HU,SK,BY,RO,RU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'UG',
				'iso3'                  => 'UGA',
				'iso_numeric'           => '800',
				'fips'                  => 'UG',
				'name'                  => ['en' => 'Uganda'],
				'capital'               => 'Kampala',
				'area'                  => '236040',
				'population'            => '33398682',
				'continent_code'        => 'AF',
				'tld'                   => '.ug',
				'currency_code'         => 'UGX',
				'phone'                 => '256',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-UG,lg,sw,ar',
				'neighbours'            => 'TZ,KE,SS,CD,RW',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'GB',
				'iso3'                  => 'GBR',
				'iso_numeric'           => '826',
				'fips'                  => 'UK',
				'name'                  => ['en' => 'United Kingdom'],
				'capital'               => 'London',
				'area'                  => '244820',
				'population'            => '62348447',
				'continent_code'        => 'EU',
				'tld'                   => '.uk',
				'currency_code'         => 'GBP',
				'phone'                 => '44',
				'postal_code_format'    => '@# #@@|@## #@@|@@# #@@|@@## #@@|@#@ #@@|@@#@ #@@|G',
				'postal_code_regex'     => '^(([A-Z]d{2}[A-Z]{2})|([A-Z]d{3}[A-Z]{2})|([A-Z]{2}d{2}[A-Z]{2})|([A-Z]{2}d{3}[A-Z]{2})|([A-Z]d[A-Z]d[A-Z]{2})|([A-Z]{2}d[A-Z]d[A-Z]{2})|(GIR0AA))$',
				'languages'             => 'en-GB,cy-GB,gd',
				'neighbours'            => 'IE',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'US',
				'iso3'                  => 'USA',
				'iso_numeric'           => '840',
				'fips'                  => 'US',
				'name'                  => ['en' => 'United States'],
				'capital'               => 'Washington',
				'area'                  => '9629091',
				'population'            => '310232863',
				'continent_code'        => 'NA',
				'tld'                   => '.us',
				'currency_code'         => 'USD',
				'phone'                 => '1',
				'postal_code_format'    => '#####-####',
				'postal_code_regex'     => '^d{5}(-d{4})?$',
				'languages'             => 'en-US,es-US,haw,fr',
				'neighbours'            => 'CA,MX,CU',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'UY',
				'iso3'                  => 'URY',
				'iso_numeric'           => '858',
				'fips'                  => 'UY',
				'name'                  => ['en' => 'Uruguay'],
				'capital'               => 'Montevideo',
				'area'                  => '176220',
				'population'            => '3477000',
				'continent_code'        => 'SA',
				'tld'                   => '.uy',
				'currency_code'         => 'UYU',
				'phone'                 => '598',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'es-UY',
				'neighbours'            => 'BR,AR',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'UZ',
				'iso3'                  => 'UZB',
				'iso_numeric'           => '860',
				'fips'                  => 'UZ',
				'name'                  => ['en' => 'Uzbekistan'],
				'capital'               => 'Tashkent',
				'area'                  => '447400',
				'population'            => '27865738',
				'continent_code'        => 'AS',
				'tld'                   => '.uz',
				'currency_code'         => 'UZS',
				'phone'                 => '998',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'uz,ru,tg',
				'neighbours'            => 'TM,AF,KG,TJ,KZ',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'VA',
				'iso3'                  => 'VAT',
				'iso_numeric'           => '336',
				'fips'                  => 'VT',
				'name'                  => ['en' => 'Vatican'],
				'capital'               => 'Vatican City',
				'area'                  => '0',
				'population'            => '921',
				'continent_code'        => 'EU',
				'tld'                   => '.va',
				'currency_code'         => 'EUR',
				'phone'                 => '379',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'la,it,fr',
				'neighbours'            => 'IT',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'VC',
				'iso3'                  => 'VCT',
				'iso_numeric'           => '670',
				'fips'                  => 'VC',
				'name'                  => ['en' => 'Saint Vincent and the Grenadines'],
				'capital'               => 'Kingstown',
				'area'                  => '389',
				'population'            => '104217',
				'continent_code'        => 'NA',
				'tld'                   => '.vc',
				'currency_code'         => 'XCD',
				'phone'                 => '+1-784',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-VC,fr',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'VE',
				'iso3'                  => 'VEN',
				'iso_numeric'           => '862',
				'fips'                  => 'VE',
				'name'                  => ['en' => 'Venezuela'],
				'capital'               => 'Caracas',
				'area'                  => '912050',
				'population'            => '27223228',
				'continent_code'        => 'SA',
				'tld'                   => '.ve',
				'currency_code'         => 'VEF',
				'phone'                 => '58',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'es-VE',
				'neighbours'            => 'GY,BR,CO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'VG',
				'iso3'                  => 'VGB',
				'iso_numeric'           => '92',
				'fips'                  => 'VI',
				'name'                  => ['en' => 'British Virgin Islands'],
				'capital'               => 'Road Town',
				'area'                  => '153',
				'population'            => '21730',
				'continent_code'        => 'NA',
				'tld'                   => '.vg',
				'currency_code'         => 'USD',
				'phone'                 => '+1-284',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-VG',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'VI',
				'iso3'                  => 'VIR',
				'iso_numeric'           => '850',
				'fips'                  => 'VQ',
				'name'                  => ['en' => 'U.S. Virgin Islands'],
				'capital'               => 'Charlotte Amalie',
				'area'                  => '352',
				'population'            => '108708',
				'continent_code'        => 'NA',
				'tld'                   => '.vi',
				'currency_code'         => 'USD',
				'phone'                 => '+1-340',
				'postal_code_format'    => '#####-####',
				'postal_code_regex'     => '^d{5}(-d{4})?$',
				'languages'             => 'en-VI',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'VN',
				'iso3'                  => 'VNM',
				'iso_numeric'           => '704',
				'fips'                  => 'VM',
				'name'                  => ['en' => 'Vietnam'],
				'capital'               => 'Hanoi',
				'area'                  => '329560',
				'population'            => '89571130',
				'continent_code'        => 'AS',
				'tld'                   => '.vn',
				'currency_code'         => 'VND',
				'phone'                 => '84',
				'postal_code_format'    => '######',
				'postal_code_regex'     => '^(d{6})$',
				'languages'             => 'vi,en,fr,zh,km',
				'neighbours'            => 'CN,LA,KH',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'VU',
				'iso3'                  => 'VUT',
				'iso_numeric'           => '548',
				'fips'                  => 'NH',
				'name'                  => ['en' => 'Vanuatu'],
				'capital'               => 'Port Vila',
				'area'                  => '12200',
				'population'            => '221552',
				'continent_code'        => 'OC',
				'tld'                   => '.vu',
				'currency_code'         => 'VUV',
				'phone'                 => '678',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'bi,en-VU,fr-VU',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'WF',
				'iso3'                  => 'WLF',
				'iso_numeric'           => '876',
				'fips'                  => 'WF',
				'name'                  => ['en' => 'Wallis and Futuna'],
				'capital'               => 'Mata Utu',
				'area'                  => '274',
				'population'            => '16025',
				'continent_code'        => 'OC',
				'tld'                   => '.wf',
				'currency_code'         => 'XPF',
				'phone'                 => '681',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(986d{2})$',
				'languages'             => 'wls,fud,fr-WF',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'WS',
				'iso3'                  => 'WSM',
				'iso_numeric'           => '882',
				'fips'                  => 'WS',
				'name'                  => ['en' => 'Samoa'],
				'capital'               => 'Apia',
				'area'                  => '2944',
				'population'            => '192001',
				'continent_code'        => 'OC',
				'tld'                   => '.ws',
				'currency_code'         => 'WST',
				'phone'                 => '685',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'sm,en-WS',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'XK',
				'iso3'                  => 'XKX',
				'iso_numeric'           => '0',
				'fips'                  => 'KV',
				'name'                  => ['en' => 'Kosovo'],
				'capital'               => 'Pristina',
				'area'                  => '10908',
				'population'            => '1800000',
				'continent_code'        => 'EU',
				'tld'                   => '',
				'currency_code'         => 'EUR',
				'phone'                 => '383',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'sq,sr',
				'neighbours'            => 'RS,AL,MK,ME',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'YE',
				'iso3'                  => 'YEM',
				'iso_numeric'           => '887',
				'fips'                  => 'YM',
				'name'                  => ['en' => 'Yemen'],
				'capital'               => 'Sanaa',
				'area'                  => '527970',
				'population'            => '23495361',
				'continent_code'        => 'AS',
				'tld'                   => '.ye',
				'currency_code'         => 'YER',
				'phone'                 => '967',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'ar-YE',
				'neighbours'            => 'SA,OM',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'YT',
				'iso3'                  => 'MYT',
				'iso_numeric'           => '175',
				'fips'                  => 'MF',
				'name'                  => ['en' => 'Mayotte'],
				'capital'               => 'Mamoudzou',
				'area'                  => '374',
				'population'            => '159042',
				'continent_code'        => 'AF',
				'tld'                   => '.yt',
				'currency_code'         => 'EUR',
				'phone'                 => '262',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'fr-YT',
				'neighbours'            => '',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ZA',
				'iso3'                  => 'ZAF',
				'iso_numeric'           => '710',
				'fips'                  => 'SF',
				'name'                  => ['en' => 'South Africa'],
				'capital'               => 'Pretoria',
				'area'                  => '1219912',
				'population'            => '49000000',
				'continent_code'        => 'AF',
				'tld'                   => '.za',
				'currency_code'         => 'ZAR',
				'phone'                 => '27',
				'postal_code_format'    => '####',
				'postal_code_regex'     => '^(d{4})$',
				'languages'             => 'zu,xh,af,nso,en-ZA,tn,st,ts,ss,ve,nr',
				'neighbours'            => 'ZW,SZ,MZ,BW,NA,LS',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ZM',
				'iso3'                  => 'ZMB',
				'iso_numeric'           => '894',
				'fips'                  => 'ZA',
				'name'                  => ['en' => 'Zambia'],
				'capital'               => 'Lusaka',
				'area'                  => '752614',
				'population'            => '13460305',
				'continent_code'        => 'AF',
				'tld'                   => '.zm',
				'currency_code'         => 'ZMW',
				'phone'                 => '260',
				'postal_code_format'    => '#####',
				'postal_code_regex'     => '^(d{5})$',
				'languages'             => 'en-ZM,bem,loz,lun,lue,ny,toi',
				'neighbours'            => 'ZW,TZ,MZ,CD,NA,MW,AO',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
			[
				'code'                  => 'ZW',
				'iso3'                  => 'ZWE',
				'iso_numeric'           => '716',
				'fips'                  => 'ZI',
				'name'                  => ['en' => 'Zimbabwe'],
				'capital'               => 'Harare',
				'area'                  => '390580',
				'population'            => '11651858',
				'continent_code'        => 'AF',
				'tld'                   => '.zw',
				'currency_code'         => 'ZWL',
				'phone'                 => '263',
				'postal_code_format'    => '',
				'postal_code_regex'     => '',
				'languages'             => 'en-ZW,sn,nr,nd',
				'neighbours'            => 'ZA,MZ,BW,ZM',
				'equivalent_fips_code'  => '',
				'background_image_path' => null,
				'admin_type'            => '0',
				'active'                => '0',
				'created_at'            => now()->format('Y-m-d H:i:s'),
				'updated_at'            => now()->format('Y-m-d H:i:s'),
			],
		];
		
		$tableName = (new Country())->getTable();
		foreach ($entries as $entry) {
			$entry = arrayTranslationsToJson($entry);
			DB::table($tableName)->insert($entry);
		}
		
		Country::autoTranslation(true);
	}
}
