<?php

namespace Database\Seeders;

use App\Models\Field;
use App\Models\FieldOption;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FieldSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
	{
		$entries = [
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Car Brand'],
				'type'          => 'select',
				'max'           => null,
				'default_value' => null,
				'required'      => '1',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Toyota'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'BMW'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Mercedes-Benz'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Chevrolet'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Cadillac'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Buick'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'GMC'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Ford'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Chrysler'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Dodge'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Jeep'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Tesla'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Lexus'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Suzuki'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Mazda'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Honda'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Acura'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Mitsubishi'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Nissan'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Infiniti'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Audi'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Volkswagen'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Porsche'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Opel'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Jaguar'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Land Rover'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'MINI'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Aston Martin'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Bentley'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Rolls-Royce'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'McLaren'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Fiat'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Alfa Romeo'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Maserati'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Ferrari'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Lamborghini'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Pagani'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Lancia'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Renault'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Peugeot'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Citroen'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Bugatti'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Tata'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Hyundai'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Kia'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Daewoo'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Volvo'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Saab'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Lada'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Volga'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Zil'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'GAZ'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Geely'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Chery'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Hongqi'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Dacia'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Daihatsu'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'FIAT'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Genesis'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Isuzu'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Lincoln'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Lotus'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Ram'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Ram'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'SEAT'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Skoda'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Smart'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Subaru'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Other'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Car Model'],
				'type'          => 'text',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Year of registration'],
				'type'          => 'number',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Mileage'],
				'type'          => 'text',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Fuel Type'],
				'type'          => 'select',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Essence'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Diesel'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Features'],
				'type'          => 'checkbox_multiple',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Air Conditioner'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'GPS'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Security System'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Spare Tire'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Transmission'],
				'type'          => 'radio',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Automatic'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Manual'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Condition'],
				'type'          => 'select',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'New'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Used'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Size'],
				'type'          => 'number',
				'max'           => '50',
				'default_value' => null,
				'required'      => '1',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Rooms'],
				'type'          => 'select',
				'max'           => null,
				'default_value' => null,
				'required'      => '1',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => '0'],
						'parent_id' => null,
						'lft'       => '2',
						'rgt'       => '3',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '1'],
						'parent_id' => null,
						'lft'       => '4',
						'rgt'       => '5',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '2'],
						'parent_id' => null,
						'lft'       => '6',
						'rgt'       => '7',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '3'],
						'parent_id' => null,
						'lft'       => '8',
						'rgt'       => '9',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '4'],
						'parent_id' => null,
						'lft'       => '10',
						'rgt'       => '11',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '5'],
						'parent_id' => null,
						'lft'       => '12',
						'rgt'       => '13',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '6'],
						'parent_id' => null,
						'lft'       => '14',
						'rgt'       => '15',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '7'],
						'parent_id' => null,
						'lft'       => '16',
						'rgt'       => '17',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '8'],
						'parent_id' => null,
						'lft'       => '18',
						'rgt'       => '19',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '9'],
						'parent_id' => null,
						'lft'       => '20',
						'rgt'       => '21',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '10'],
						'parent_id' => null,
						'lft'       => '22',
						'rgt'       => '23',
						'depth'     => '1',
					],
					[
						'field_id'  => null,
						'value'     => ['en' => '> 10'],
						'parent_id' => null,
						'lft'       => '24',
						'rgt'       => '25',
						'depth'     => '1',
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Building Type'],
				'type'          => 'select',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Apartment'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'House'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Office'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Store'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Plot of land'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Parking'],
				'type'          => 'checkbox',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Furnished'],
				'type'          => 'radio',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Yes'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'No'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Mobile Brand'],
				'type'          => 'select',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Huawei'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Sony'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'LG'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Samsung'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Nokia'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Alcatel-Lucent'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Siemens'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'BlackBerry'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Apple'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Google'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Microsoft'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Motorola'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Other'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Mobile Model'],
				'type'          => 'text',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Electronic Brand'],
				'type'          => 'select',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Huawei'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Lenovo'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'TP-Link'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Xiaomi'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Canon'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Casio'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Epson'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Fuji'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Funai'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'JVC'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Nikon'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Nintendo'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Olympus'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Panasonic'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Pentax'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Pioneer'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Sega'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Sharp'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Sony'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Toshiba'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Daewoo'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'LG'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Samsung'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Acer'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Asus'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'D-Link'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Gigabyte'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Beko'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Nokia'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Alcatel-Lucent'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Bosch'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Siemens'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Sennheiser'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Telefunken'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Philips'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Electrolux'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Russell Hobbs'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'BlackBerry'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Thomson'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Amazon'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Apple'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Bose'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Cisco Systems'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Dell'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Gateway'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Google'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Hewlett-Packard'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'IBM'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Intel'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Microsoft'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Motorola'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'NVIDIA'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Packard Bell'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Qualcomm'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Seagate'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Sun Microsystems'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Vizio'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Western Digital'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Xerox'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Other'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Model'],
				'type'          => 'text',
				'max'           => null,
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Start Date'],
				'type'          => 'date',
				'max'           => '50',
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Company'],
				'type'          => 'text',
				'max'           => '100',
				'default_value' => null,
				'required'      => '1',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Work Type'],
				'type'          => 'select',
				'max'           => null,
				'default_value' => null,
				'required'      => '1',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
				'options'       => [
					[
						'field_id'  => null,
						'value'     => ['en' => 'Full-time'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Part-time'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Temporary'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Internship'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
					[
						'field_id'  => null,
						'value'     => ['en' => 'Permanent'],
						'parent_id' => null,
						'lft'       => null,
						'rgt'       => null,
						'depth'     => null,
					],
				],
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Start date'],
				'type'          => 'date',
				'max'           => '50',
				'default_value' => null,
				'required'      => '1',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'End date'],
				'type'          => 'date',
				'max'           => '50',
				'default_value' => null,
				'required'      => '1',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Event Address'],
				'type'          => 'text',
				'max'           => '200',
				'default_value' => null,
				'required'      => '1',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Website'],
				'type'          => 'url',
				'max'           => '100',
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Video'],
				'type'          => 'video',
				'max'           => '100',
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '0',
				'help'          => null,
				'active'        => '1',
			],
			[
				'belongs_to'    => 'post',
				'name'          => ['en' => 'Date Range'],
				'type'          => 'date_range',
				'max'           => '100',
				'default_value' => null,
				'required'      => '0',
				'use_as_filter' => '1',
				'help'          => null,
				'active'        => '1',
			],
		];
		
		$tableName = (new Field())->getTable();
		$optionsTableName = (new FieldOption())->getTable();
		foreach ($entries as $entry) {
			$subEntries = [];
			if (isset($entry['options'])) {
				$subEntries = $entry['options'];
				unset($entry['options']);
			}
			
			$entry = arrayTranslationsToJson($entry);
			$entryId = DB::table($tableName)->insertGetId($entry);
			
			if (!empty($subEntries)) {
				
				$lft = isset($lft) ? $lft : 1;
				$rgt = isset($rgt) ? $rgt : 2;
				
				foreach ($subEntries as $subEntry) {
					$subEntry = arrayTranslationsToJson($subEntry);
					$subEntryId = DB::table($optionsTableName)->insertGetId($subEntry);
					DB::table($optionsTableName)->where('id', $subEntryId)->update([
						'field_id' => $entryId,
						'lft'      => $lft,
						'rgt'      => $rgt,
					]);
					
					$lft = $lft + 2;
					$rgt = $lft + 1;
				}
				
			}
		}
	}
}
