/*
 * LaraClassifier - Classified Ads Web Application
 * Copyright (c) BeDigit. All Rights Reserved
 *
 * Website: https://laraclassifier.com
 * Author: Mayeul Akpovi (BeDigit - https://bedigit.com)
 *
 * LICENSE
 * -------
 * This software is provided under a license agreement and may only be used or copied
 * in accordance with its terms, including the inclusion of the above copyright notice.
 * As this software is sold exclusively on CodeCanyon,
 * please review the full license details here: https://codecanyon.net/licenses/standard
 */

/**
 * Execute callback function after page is loaded
 *
 * @param callback
 * @param isFullyLoaded
 */
if (!window.onDocumentReady) {
	function onDocumentReady(callback, isFullyLoaded = true) {
		switch (document.readyState) {
			case "loading":
				/* The document is still loading, attach the event listener */
				document.addEventListener("DOMContentLoaded", callback);
				break;
			case "interactive": {
				if (!isFullyLoaded) {
					/*
					 * The document has finished loading, and we can access DOM elements.
					 * Sub-resources such as scripts, images, stylesheets and frames are still loading.
					 * Call the callback (on next available tick (in 500 milliseconds))
					 */
					setTimeout(callback, 500);
				}
				break;
			}
			case "complete":
				/* The page is fully loaded, call the callback directly */
				callback();
				break;
			default:
				document.addEventListener("DOMContentLoaded", callback);
		}
	}
}
