<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>LaraClassifier API Documentation</title>

    <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset("/vendor/scribe/css/theme-default.style.css") }}" media="screen">
    <link rel="stylesheet" href="{{ asset("/vendor/scribe/css/theme-default.print.css") }}" media="print">

    <script src="https://cdn.jsdelivr.net/npm/lodash@4.17.10/lodash.min.js"></script>

    <link rel="stylesheet"
          href="https://unpkg.com/@highlightjs/cdn-assets@11.6.0/styles/obsidian.min.css">
    <script src="https://unpkg.com/@highlightjs/cdn-assets@11.6.0/highlight.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jets/0.14.1/jets.min.js"></script>

    <style id="language-style">
        /* starts out as display none and is replaced with js later  */
                    body .content .bash-example code { display: none; }
                    body .content .javascript-example code { display: none; }
                    body .content .php-example code { display: none; }
                    body .content .python-example code { display: none; }
            </style>

    <script>
        var tryItOutBaseUrl = "https://demo.laraclassifier.local";
        var useCsrf = Boolean();
        var csrfUrl = "/sanctum/csrf-cookie";
    </script>
    <script src="{{ asset("/vendor/scribe/js/tryitout-5.2.1.js") }}"></script>

    <script src="{{ asset("/vendor/scribe/js/theme-default-5.2.1.js") }}"></script>

</head>

<body data-languages="[&quot;bash&quot;,&quot;javascript&quot;,&quot;php&quot;,&quot;python&quot;]">

<a href="#" id="nav-button">
    <span>
        MENU
        <img src="{{ asset("/vendor/scribe/images/navbar.png") }}" alt="navbar-image"/>
    </span>
</a>
<div class="tocify-wrapper">
            <img src="../storage/app/default/logo-api.png" alt="logo" class="logo" style="padding-top: 10px;" width="100%"/>
    
            <div class="lang-selector">
                                            <button type="button" class="lang-button" data-language-name="bash">bash</button>
                                            <button type="button" class="lang-button" data-language-name="javascript">javascript</button>
                                            <button type="button" class="lang-button" data-language-name="php">php</button>
                                            <button type="button" class="lang-button" data-language-name="python">python</button>
                    </div>
    
    <div class="search">
        <input type="text" class="search" id="input-search" placeholder="Search">
    </div>

    <div id="toc">
                    <ul id="tocify-header-introduction" class="tocify-header">
                <li class="tocify-item level-1" data-unique="introduction">
                    <a href="#introduction">Introduction</a>
                </li>
                            </ul>
                    <ul id="tocify-header-authenticating-requests" class="tocify-header">
                <li class="tocify-item level-1" data-unique="authenticating-requests">
                    <a href="#authenticating-requests">Authenticating requests</a>
                </li>
                            </ul>
                    <ul id="tocify-header-authentication" class="tocify-header">
                <li class="tocify-item level-1" data-unique="authentication">
                    <a href="#authentication">Authentication</a>
                </li>
                                    <ul id="tocify-subheader-authentication" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="authentication-POSTapi-auth-login">
                                <a href="#authentication-POSTapi-auth-login">Log in</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="authentication-GETapi-auth-logout--userId-">
                                <a href="#authentication-GETapi-auth-logout--userId-">Log out</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="authentication-POSTapi-auth-password-forgot">
                                <a href="#authentication-POSTapi-auth-password-forgot">Forgot password</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="authentication-POSTapi-auth-password-reset">
                                <a href="#authentication-POSTapi-auth-password-reset">Reset password</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-captcha" class="tocify-header">
                <li class="tocify-item level-1" data-unique="captcha">
                    <a href="#captcha">Captcha</a>
                </li>
                                    <ul id="tocify-subheader-captcha" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="captcha-GETapi-captcha">
                                <a href="#captcha-GETapi-captcha">Get CAPTCHA</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-categories" class="tocify-header">
                <li class="tocify-item level-1" data-unique="categories">
                    <a href="#categories">Categories</a>
                </li>
                                    <ul id="tocify-subheader-categories" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="categories-GETapi-categories">
                                <a href="#categories-GETapi-categories">List categories</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="categories-GETapi-categories--slugOrId-">
                                <a href="#categories-GETapi-categories--slugOrId-">Get category</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="categories-GETapi-categories--id--fields">
                                <a href="#categories-GETapi-categories--id--fields">List category's fields</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="categories-POSTapi-categories--id--fields">
                                <a href="#categories-POSTapi-categories--id--fields">List category's fields</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-contact" class="tocify-header">
                <li class="tocify-item level-1" data-unique="contact">
                    <a href="#contact">Contact</a>
                </li>
                                    <ul id="tocify-subheader-contact" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="contact-POSTapi-contact">
                                <a href="#contact-POSTapi-contact">Send Form</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="contact-POSTapi-posts--id--report">
                                <a href="#contact-POSTapi-posts--id--report">Report post</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-countries" class="tocify-header">
                <li class="tocify-item level-1" data-unique="countries">
                    <a href="#countries">Countries</a>
                </li>
                                    <ul id="tocify-subheader-countries" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="countries-GETapi-countries">
                                <a href="#countries-GETapi-countries">List countries</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-countries--code-">
                                <a href="#countries-GETapi-countries--code-">Get country</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-countries--countryCode--subAdmins1">
                                <a href="#countries-GETapi-countries--countryCode--subAdmins1">List admin. divisions (1)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-countries--countryCode--subAdmins2">
                                <a href="#countries-GETapi-countries--countryCode--subAdmins2">List admin. divisions (2)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-countries--countryCode--cities">
                                <a href="#countries-GETapi-countries--countryCode--cities">List cities</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-subAdmins1--code-">
                                <a href="#countries-GETapi-subAdmins1--code-">Get admin. division (1)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-subAdmins2--code-">
                                <a href="#countries-GETapi-subAdmins2--code-">Get admin. division (2)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-cities--id-">
                                <a href="#countries-GETapi-cities--id-">Get city</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-home" class="tocify-header">
                <li class="tocify-item level-1" data-unique="home">
                    <a href="#home">Home</a>
                </li>
                                    <ul id="tocify-subheader-home" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="home-GETapi-sections">
                                <a href="#home-GETapi-sections">List sections</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="home-GETapi-sections--method-">
                                <a href="#home-GETapi-sections--method-">Get section</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-languages" class="tocify-header">
                <li class="tocify-item level-1" data-unique="languages">
                    <a href="#languages">Languages</a>
                </li>
                                    <ul id="tocify-subheader-languages" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="languages-GETapi-languages">
                                <a href="#languages-GETapi-languages">List languages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="languages-GETapi-languages--code-">
                                <a href="#languages-GETapi-languages--code-">Get language</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-listings" class="tocify-header">
                <li class="tocify-item level-1" data-unique="listings">
                    <a href="#listings">Listings</a>
                </li>
                                    <ul id="tocify-subheader-listings" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="listings-GETapi-postTypes">
                                <a href="#listings-GETapi-postTypes">List listing types</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-postTypes--id-">
                                <a href="#listings-GETapi-postTypes--id-">Get listing type</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-reportTypes">
                                <a href="#listings-GETapi-reportTypes">List report types</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-reportTypes--id-">
                                <a href="#listings-GETapi-reportTypes--id-">Get report type</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-posts">
                                <a href="#listings-GETapi-posts">List listings</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-posts--id-">
                                <a href="#listings-GETapi-posts--id-">Get listing</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-POSTapi-posts">
                                <a href="#listings-POSTapi-posts">Store listing</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-PUTapi-posts--id-">
                                <a href="#listings-PUTapi-posts--id-">Update listing</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-DELETEapi-posts--ids-">
                                <a href="#listings-DELETEapi-posts--ids-">Delete listing(s)</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-packages" class="tocify-header">
                <li class="tocify-item level-1" data-unique="packages">
                    <a href="#packages">Packages</a>
                </li>
                                    <ul id="tocify-subheader-packages" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="packages-GETapi-packages-promotion">
                                <a href="#packages-GETapi-packages-promotion">List packages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="packages-GETapi-packages-subscription">
                                <a href="#packages-GETapi-packages-subscription">List packages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="packages-GETapi-packages--id-">
                                <a href="#packages-GETapi-packages--id-">Get package</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-pages" class="tocify-header">
                <li class="tocify-item level-1" data-unique="pages">
                    <a href="#pages">Pages</a>
                </li>
                                    <ul id="tocify-subheader-pages" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="pages-GETapi-pages">
                                <a href="#pages-GETapi-pages">List pages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pages-GETapi-pages--slugOrId-">
                                <a href="#pages-GETapi-pages--slugOrId-">Get page</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-payment-methods" class="tocify-header">
                <li class="tocify-item level-1" data-unique="payment-methods">
                    <a href="#payment-methods">Payment Methods</a>
                </li>
                                    <ul id="tocify-subheader-payment-methods" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="payment-methods-GETapi-paymentMethods">
                                <a href="#payment-methods-GETapi-paymentMethods">List payment methods</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payment-methods-GETapi-paymentMethods--id-">
                                <a href="#payment-methods-GETapi-paymentMethods--id-">Get payment method</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-payments" class="tocify-header">
                <li class="tocify-item level-1" data-unique="payments">
                    <a href="#payments">Payments</a>
                </li>
                                    <ul id="tocify-subheader-payments" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="payments-GETapi-payments-promotion">
                                <a href="#payments-GETapi-payments-promotion">List payments</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payments-GETapi-payments-subscription">
                                <a href="#payments-GETapi-payments-subscription">List payments</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payments-GETapi-payments-subscription-users--userId--payments">
                                <a href="#payments-GETapi-payments-subscription-users--userId--payments">List payments</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payments-GETapi-payments--id-">
                                <a href="#payments-GETapi-payments--id-">Get payment</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payments-POSTapi-payments">
                                <a href="#payments-POSTapi-payments">Store payment</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-pictures" class="tocify-header">
                <li class="tocify-item level-1" data-unique="pictures">
                    <a href="#pictures">Pictures</a>
                </li>
                                    <ul id="tocify-subheader-pictures" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="pictures-GETapi-pictures--id-">
                                <a href="#pictures-GETapi-pictures--id-">Get picture</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pictures-POSTapi-pictures">
                                <a href="#pictures-POSTapi-pictures">Store picture</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pictures-DELETEapi-pictures--id-">
                                <a href="#pictures-DELETEapi-pictures--id-">Delete picture</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pictures-POSTapi-pictures-reorder">
                                <a href="#pictures-POSTapi-pictures-reorder">Reorder pictures</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pictures-GETapi-posts--postId--pictures">
                                <a href="#pictures-GETapi-posts--postId--pictures">List pictures</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-reviews" class="tocify-header">
                <li class="tocify-item level-1" data-unique="reviews">
                    <a href="#reviews">Reviews</a>
                </li>
                                    <ul id="tocify-subheader-reviews" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="reviews-GETapi-plugins-posts--postId--reviews">
                                <a href="#reviews-GETapi-plugins-posts--postId--reviews">List reviews</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="reviews-POSTapi-plugins-posts--postId--reviews">
                                <a href="#reviews-POSTapi-plugins-posts--postId--reviews">Store review</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="reviews-DELETEapi-plugins-posts--postId--reviews--ids-">
                                <a href="#reviews-DELETEapi-plugins-posts--postId--reviews--ids-">Delete review(s)</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-saved-posts" class="tocify-header">
                <li class="tocify-item level-1" data-unique="saved-posts">
                    <a href="#saved-posts">Saved Posts</a>
                </li>
                                    <ul id="tocify-subheader-saved-posts" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="saved-posts-POSTapi-savedPosts">
                                <a href="#saved-posts-POSTapi-savedPosts">Store/Delete saved listing</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-posts-GETapi-savedPosts">
                                <a href="#saved-posts-GETapi-savedPosts">List saved listings</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-posts-DELETEapi-savedPosts--ids-">
                                <a href="#saved-posts-DELETEapi-savedPosts--ids-">Delete saved listing(s)</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-saved-searches" class="tocify-header">
                <li class="tocify-item level-1" data-unique="saved-searches">
                    <a href="#saved-searches">Saved Searches</a>
                </li>
                                    <ul id="tocify-subheader-saved-searches" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="saved-searches-POSTapi-savedSearches">
                                <a href="#saved-searches-POSTapi-savedSearches">Store/Delete saved search</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-searches-GETapi-savedSearches">
                                <a href="#saved-searches-GETapi-savedSearches">List saved searches</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-searches-GETapi-savedSearches--id-">
                                <a href="#saved-searches-GETapi-savedSearches--id-">Get saved search</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-searches-DELETEapi-savedSearches--ids-">
                                <a href="#saved-searches-DELETEapi-savedSearches--ids-">Delete saved search(es)</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-settings" class="tocify-header">
                <li class="tocify-item level-1" data-unique="settings">
                    <a href="#settings">Settings</a>
                </li>
                                    <ul id="tocify-subheader-settings" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="settings-GETapi-settings">
                                <a href="#settings-GETapi-settings">List settings</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="settings-GETapi-settings--key-">
                                <a href="#settings-GETapi-settings--key-">Get setting</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-social-auth" class="tocify-header">
                <li class="tocify-item level-1" data-unique="social-auth">
                    <a href="#social-auth">Social Auth</a>
                </li>
                                    <ul id="tocify-subheader-social-auth" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="social-auth-GETapi-auth-connect--provider-">
                                <a href="#social-auth-GETapi-auth-connect--provider-">Get target URL</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="social-auth-GETapi-auth-connect--provider--callback">
                                <a href="#social-auth-GETapi-auth-connect--provider--callback">Get user info</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-threads" class="tocify-header">
                <li class="tocify-item level-1" data-unique="threads">
                    <a href="#threads">Threads</a>
                </li>
                                    <ul id="tocify-subheader-threads" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="threads-POSTapi-threads">
                                <a href="#threads-POSTapi-threads">Store thread</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-GETapi-threads">
                                <a href="#threads-GETapi-threads">List threads</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-GETapi-threads--id-">
                                <a href="#threads-GETapi-threads--id-">Get thread</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-PUTapi-threads--id-">
                                <a href="#threads-PUTapi-threads--id-">Update thread</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-DELETEapi-threads--ids-">
                                <a href="#threads-DELETEapi-threads--ids-">Delete thread(s)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-POSTapi-threads-bulkUpdate--ids--">
                                <a href="#threads-POSTapi-threads-bulkUpdate--ids--">Bulk updates</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-GETapi-threads--threadId--messages">
                                <a href="#threads-GETapi-threads--threadId--messages">List messages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-GETapi-threads--threadId--messages--id-">
                                <a href="#threads-GETapi-threads--threadId--messages--id-">Get message</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-users" class="tocify-header">
                <li class="tocify-item level-1" data-unique="users">
                    <a href="#users">Users</a>
                </li>
                                    <ul id="tocify-subheader-users" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="users-GETapi-genders">
                                <a href="#users-GETapi-genders">List genders</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-genders--id-">
                                <a href="#users-GETapi-genders--id-">Get gender</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-userTypes">
                                <a href="#users-GETapi-userTypes">List user types</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-userTypes--id-">
                                <a href="#users-GETapi-userTypes--id-">Get user type</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-users">
                                <a href="#users-GETapi-users">List users</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-users--id-">
                                <a href="#users-GETapi-users--id-">Get user</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-POSTapi-users">
                                <a href="#users-POSTapi-users">Store user</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-users--id--stats">
                                <a href="#users-GETapi-users--id--stats">User's mini stats</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-users--id--photo-delete">
                                <a href="#users-GETapi-users--id--photo-delete">Delete user's photo</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-PUTapi-users--id--photo">
                                <a href="#users-PUTapi-users--id--photo">Update user's photo</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-PUTapi-users--id--preferences">
                                <a href="#users-PUTapi-users--id--preferences">Update user's preferences</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-PUTapi-users--id--save-theme-preference">
                                <a href="#users-PUTapi-users--id--save-theme-preference">Update the user's theme preference</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-PUTapi-users--id-">
                                <a href="#users-PUTapi-users--id-">Update user</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-DELETEapi-users--id-">
                                <a href="#users-DELETEapi-users--id-">Delete user</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-verification" class="tocify-header">
                <li class="tocify-item level-1" data-unique="verification">
                    <a href="#verification">Verification</a>
                </li>
                                    <ul id="tocify-subheader-verification" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="verification-GETapi-auth-verify--entityMetadataKey---entityId--resend-email">
                                <a href="#verification-GETapi-auth-verify--entityMetadataKey---entityId--resend-email">Email: Re-send link</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="verification-GETapi-auth-verify--entityMetadataKey---entityId--resend-sms">
                                <a href="#verification-GETapi-auth-verify--entityMetadataKey---entityId--resend-sms">SMS: Re-send code</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="verification-GETapi-auth-verify--entityMetadataKey---field---token--">
                                <a href="#verification-GETapi-auth-verify--entityMetadataKey---field---token--">Verification</a>
                            </li>
                                                                        </ul>
                            </ul>
            </div>

    <ul class="toc-footer" id="toc-footer">
                    <li style="padding-bottom: 5px;"><a href="{{ route("scribe.postman") }}">View Postman collection</a></li>
                        <li><a href="http://github.com/knuckleswtf/scribe">Documentation powered by Scribe ✍</a></li>
    </ul>

    <ul class="toc-footer" id="last-updated">
        <li>Last updated: May 17, 2025</li>
    </ul>
</div>

<div class="page-wrapper">
    <div class="dark-box"></div>
    <div class="content">
        <h1 id="introduction">Introduction</h1>
<p>LaraClassifier API specification and documentation.</p>
<aside>
    <strong>Base URL</strong>: <code>https://demo.laraclassifier.local</code>
</aside>
<p>This documentation aims to provide all the information you need to work with our API.</p>
<aside>As you scroll, you'll see code examples for working with the API in different programming languages in the dark area to the right (or as part of the content on mobile).
You can switch the language used with the tabs at the top right (or from the nav menu at the top left on mobile).</aside>
<p><strong>Important:</strong> By default the API uses an access token set in the <strong><code>/.env</code></strong> file with the variable <code>APP_API_TOKEN</code>, whose its value
need to be added in the header of all the API requests with <code>X-AppApiToken</code> as key. On the other hand, the key <code>X-AppType</code> must not be added to the header... This key is only useful for the included web client and for API documentation.</p>
<p>Also, by default the default app's country will be selected if the <strong><code>countryCode</code></strong> query parameter is not filled during API calls. If a default country is not set for the app, the most populated country will be selected. Same for the language, which the default app language will be selected if the <strong><code>languageCode</code></strong> query parameter is not filled.</p>

        <h1 id="authenticating-requests">Authenticating requests</h1>
<p>To authenticate requests, include an <strong><code>Authorization</code></strong> header with the value <strong><code>"Bearer {YOUR_AUTH_KEY}"</code></strong>.</p>
<p>All authenticated endpoints are marked with a <code>requires authentication</code> badge in the documentation below.</p>
<p>You can retrieve your token by visiting your dashboard and clicking <b>Generate API token</b>.</p>

        <h1 id="authentication">Authentication</h1>

    

                                <h2 id="authentication-POSTapi-auth-login">Log in</h2>

<p>
</p>



<span id="example-requests-POSTapi-auth-login">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/auth/login" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"email\": \"user@demosite.com\",
    \"password\": \"123456\",
    \"auth_field\": \"email\",
    \"phone\": null,
    \"phone_country\": null,
    \"captcha_key\": \"accusamus\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/auth/login"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "email": "user@demosite.com",
    "password": "123456",
    "auth_field": "email",
    "phone": null,
    "phone_country": null,
    "captcha_key": "accusamus"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/auth/login';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'email' =&gt; 'user@demosite.com',
            'password' =&gt; '123456',
            'auth_field' =&gt; 'email',
            'phone' =&gt; null,
            'phone_country' =&gt; null,
            'captcha_key' =&gt; 'accusamus',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/auth/login'
payload = {
    "email": "user@demosite.com",
    "password": "123456",
    "auth_field": "email",
    "phone": null,
    "phone_country": null,
    "captcha_key": "accusamus"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-auth-login">
</span>
<span id="execution-results-POSTapi-auth-login" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-auth-login"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-login"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-auth-login" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-login">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-auth-login" data-method="POST"
      data-path="api/auth/login"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-login', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-auth-login"
                    onclick="tryItOut('POSTapi-auth-login');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-auth-login"
                    onclick="cancelTryOut('POSTapi-auth-login');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-auth-login"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/auth/login</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-auth-login"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-auth-login"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-auth-login"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-auth-login"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-auth-login"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-auth-login"
               value="user@demosite.com"
               data-component="body">
    <br>
<p>The user's email address or username (Required when 'auth_field' value is 'email'). Example: <code>user@demosite.com</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>password</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="password"                data-endpoint="POSTapi-auth-login"
               value="123456"
               data-component="body">
    <br>
<p>The user's password. Example: <code>123456</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="POSTapi-auth-login"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-auth-login"
               value=""
               data-component="body">
    <br>
<p>The user's mobile phone number (Required when 'auth_field' value is 'phone').</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="POSTapi-auth-login"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-auth-login"
               value="accusamus"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>accusamus</code></p>
        </div>
        </form>

                    <h2 id="authentication-GETapi-auth-logout--userId-">Log out</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-GETapi-auth-logout--userId-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/auth/logout/4" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/auth/logout/4"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/auth/logout/4';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/auth/logout/4'
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-auth-logout--userId-">
            <blockquote>
            <p>Example response (400):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;An error occurred and the logout failed.&quot;,
    &quot;result&quot;: null
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-auth-logout--userId-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-auth-logout--userId-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-auth-logout--userId-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-auth-logout--userId-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-auth-logout--userId-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-auth-logout--userId-" data-method="GET"
      data-path="api/auth/logout/{userId}"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-auth-logout--userId-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-auth-logout--userId-"
                    onclick="tryItOut('GETapi-auth-logout--userId-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-auth-logout--userId-"
                    onclick="cancelTryOut('GETapi-auth-logout--userId-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-auth-logout--userId-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/auth/logout/{userId}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="GETapi-auth-logout--userId-"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-auth-logout--userId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-auth-logout--userId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-auth-logout--userId-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-auth-logout--userId-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-auth-logout--userId-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>userId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="userId"                data-endpoint="GETapi-auth-logout--userId-"
               value="4"
               data-component="url">
    <br>
<p>The ID of the user to logout. Example: <code>4</code></p>
            </div>
                    </form>

                    <h2 id="authentication-POSTapi-auth-password-forgot">Forgot password</h2>

<p>
</p>



<span id="example-requests-POSTapi-auth-password-forgot">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/auth/password/forgot" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"email\": \"user@demosite.com\",
    \"auth_field\": \"email\",
    \"phone\": null,
    \"phone_country\": null,
    \"captcha_key\": \"alias\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/auth/password/forgot"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "email": "user@demosite.com",
    "auth_field": "email",
    "phone": null,
    "phone_country": null,
    "captcha_key": "alias"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/auth/password/forgot';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'email' =&gt; 'user@demosite.com',
            'auth_field' =&gt; 'email',
            'phone' =&gt; null,
            'phone_country' =&gt; null,
            'captcha_key' =&gt; 'alias',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/auth/password/forgot'
payload = {
    "email": "user@demosite.com",
    "auth_field": "email",
    "phone": null,
    "phone_country": null,
    "captcha_key": "alias"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-auth-password-forgot">
</span>
<span id="execution-results-POSTapi-auth-password-forgot" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-auth-password-forgot"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-password-forgot"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-auth-password-forgot" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-password-forgot">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-auth-password-forgot" data-method="POST"
      data-path="api/auth/password/forgot"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-password-forgot', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-auth-password-forgot"
                    onclick="tryItOut('POSTapi-auth-password-forgot');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-auth-password-forgot"
                    onclick="cancelTryOut('POSTapi-auth-password-forgot');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-auth-password-forgot"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/auth/password/forgot</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-auth-password-forgot"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-auth-password-forgot"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-auth-password-forgot"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-auth-password-forgot"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-auth-password-forgot"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-auth-password-forgot"
               value="user@demosite.com"
               data-component="body">
    <br>
<p>The user's email address or username (Required when 'auth_field' value is 'email'). Example: <code>user@demosite.com</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="POSTapi-auth-password-forgot"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-auth-password-forgot"
               value=""
               data-component="body">
    <br>
<p>The user's mobile phone number (Required when 'auth_field' value is 'phone').</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="POSTapi-auth-password-forgot"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-auth-password-forgot"
               value="alias"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>alias</code></p>
        </div>
        </form>

                    <h2 id="authentication-POSTapi-auth-password-reset">Reset password</h2>

<p>
</p>



<span id="example-requests-POSTapi-auth-password-reset">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/auth/password/reset" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"email\": \"john.doe@domain.tld\",
    \"token\": \"accusamus\",
    \"phone_country\": null,
    \"password\": \"js!X07$z61hLA\",
    \"auth_field\": \"email\",
    \"phone\": null,
    \"password_confirmation\": \"js!X07$z61hLA\",
    \"captcha_key\": \"explicabo\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/auth/password/reset"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "email": "john.doe@domain.tld",
    "token": "accusamus",
    "phone_country": null,
    "password": "js!X07$z61hLA",
    "auth_field": "email",
    "phone": null,
    "password_confirmation": "js!X07$z61hLA",
    "captcha_key": "explicabo"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/auth/password/reset';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'email' =&gt; 'john.doe@domain.tld',
            'token' =&gt; 'accusamus',
            'phone_country' =&gt; null,
            'password' =&gt; 'js!X07$z61hLA',
            'auth_field' =&gt; 'email',
            'phone' =&gt; null,
            'password_confirmation' =&gt; 'js!X07$z61hLA',
            'captcha_key' =&gt; 'explicabo',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/auth/password/reset'
payload = {
    "email": "john.doe@domain.tld",
    "token": "accusamus",
    "phone_country": null,
    "password": "js!X07$z61hLA",
    "auth_field": "email",
    "phone": null,
    "password_confirmation": "js!X07$z61hLA",
    "captcha_key": "explicabo"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-auth-password-reset">
</span>
<span id="execution-results-POSTapi-auth-password-reset" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-auth-password-reset"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-password-reset"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-auth-password-reset" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-password-reset">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-auth-password-reset" data-method="POST"
      data-path="api/auth/password/reset"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-password-reset', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-auth-password-reset"
                    onclick="tryItOut('POSTapi-auth-password-reset');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-auth-password-reset"
                    onclick="cancelTryOut('POSTapi-auth-password-reset');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-auth-password-reset"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/auth/password/reset</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-auth-password-reset"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-auth-password-reset"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-auth-password-reset"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-auth-password-reset"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-auth-password-reset"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-auth-password-reset"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The user's email address or username (Required when 'auth_field' value is 'email'). Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>token</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="token"                data-endpoint="POSTapi-auth-password-reset"
               value="accusamus"
               data-component="body">
    <br>
<p>Example: <code>accusamus</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="POSTapi-auth-password-reset"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>password</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="password"                data-endpoint="POSTapi-auth-password-reset"
               value="js!X07$z61hLA"
               data-component="body">
    <br>
<p>The user's password. Example: <code>js!X07$z61hLA</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="POSTapi-auth-password-reset"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-auth-password-reset"
               value=""
               data-component="body">
    <br>
<p>The user's mobile phone number (Required when 'auth_field' value is 'phone').</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>password_confirmation</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="password_confirmation"                data-endpoint="POSTapi-auth-password-reset"
               value="js!X07$z61hLA"
               data-component="body">
    <br>
<p>The confirmation of the user's password. Example: <code>js!X07$z61hLA</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-auth-password-reset"
               value="explicabo"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>explicabo</code></p>
        </div>
        </form>

                <h1 id="captcha">Captcha</h1>

    

                                <h2 id="captcha-GETapi-captcha">Get CAPTCHA</h2>

<p>
</p>

<p>Calling this endpoint is mandatory if the captcha is enabled in the Admin panel.
Return JSON data with an 'img' item that contains the captcha image to show and a 'key' item that contains the generated key to send for validation.</p>

<span id="example-requests-GETapi-captcha">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/captcha" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/captcha"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/captcha';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/captcha'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-captcha">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;sensitive&quot;: false,
        &quot;key&quot;: &quot;eyJpdiI6IkZmc3lmMHlwQTdrYUxML2JaVFM2dmc9PSIsInZhbHVlIjoiS1JZRWhobDIwdW44SjNwZmw1eDhPaEtodUdUNEswVE5FRWxIOG8yRzBvTTM1cTYxbWgveG1BeG9yYXBpUXBvVHc0RVlPUjNSVk5WaFQxbytUOFlWRTB5ZGVMS2VmWTBPOE1xL25qcHNKRWM9IiwibWFjIjoiMGM0OGY5ZjRiMDc0ZmNjODVkMjQ0MThkMThjMjQzOWU5ZTU5OTY3MzkxYzJiMTdhOGVhYzkzNTBiYjkzMTg4NSIsInRhZyI6IiJ9&quot;,
        &quot;img&quot;: &quot;data:image/png;base64,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&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-captcha" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-captcha"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-captcha"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-captcha" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-captcha">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-captcha" data-method="GET"
      data-path="api/captcha"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-captcha', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-captcha"
                    onclick="tryItOut('GETapi-captcha');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-captcha"
                    onclick="cancelTryOut('GETapi-captcha');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-captcha"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/captcha</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-captcha"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-captcha"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-captcha"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-captcha"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-captcha"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                <h1 id="categories">Categories</h1>

    

                                <h2 id="categories-GETapi-categories">List categories</h2>

<p>
</p>



<span id="example-requests-GETapi-categories">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;embed=&amp;sort=-lft&amp;perPage=2&amp;page=1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/categories"
);

const params = {
    "parentId": "0",
    "nestedIncluded": "0",
    "embed": "",
    "sort": "-lft",
    "perPage": "2",
    "page": "1",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/categories';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'parentId' =&gt; '0',
            'nestedIncluded' =&gt; '0',
            'embed' =&gt; '',
            'sort' =&gt; '-lft',
            'perPage' =&gt; '2',
            'page' =&gt; '1',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/categories'
params = {
  'parentId': '0',
  'nestedIncluded': '0',
  'embed': '',
  'sort': '-lft',
  'perPage': '2',
  'page': '1',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-categories">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 122,
                &quot;parent_id&quot;: null,
                &quot;name&quot;: &quot;Local Events&quot;,
                &quot;slug&quot;: &quot;local-events&quot;,
                &quot;description&quot;: &quot;&quot;,
                &quot;hide_description&quot;: null,
                &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                &quot;icon_class&quot;: &quot;fa-regular fa-calendar-days&quot;,
                &quot;seo_title&quot;: &quot;&quot;,
                &quot;seo_description&quot;: &quot;&quot;,
                &quot;seo_keywords&quot;: &quot;&quot;,
                &quot;lft&quot;: 144,
                &quot;rgt&quot;: 158,
                &quot;depth&quot;: 0,
                &quot;type&quot;: &quot;classified&quot;,
                &quot;is_for_permanent&quot;: 0,
                &quot;active&quot;: 1,
                &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                &quot;parentClosure&quot;: null
            },
            {
                &quot;id&quot;: 114,
                &quot;parent_id&quot;: null,
                &quot;name&quot;: &quot;Learning&quot;,
                &quot;slug&quot;: &quot;learning&quot;,
                &quot;description&quot;: &quot;&quot;,
                &quot;hide_description&quot;: null,
                &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                &quot;icon_class&quot;: &quot;fa-solid fa-graduation-cap&quot;,
                &quot;seo_title&quot;: &quot;&quot;,
                &quot;seo_description&quot;: &quot;&quot;,
                &quot;seo_keywords&quot;: &quot;&quot;,
                &quot;lft&quot;: 134,
                &quot;rgt&quot;: 143,
                &quot;depth&quot;: 0,
                &quot;type&quot;: &quot;classified&quot;,
                &quot;is_for_permanent&quot;: 0,
                &quot;active&quot;: 1,
                &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                &quot;parentClosure&quot;: null
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=6&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 6,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/categories&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 12
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-categories" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-categories"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-categories"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-categories" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-categories">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-categories" data-method="GET"
      data-path="api/categories"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-categories', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-categories"
                    onclick="tryItOut('GETapi-categories');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-categories"
                    onclick="cancelTryOut('GETapi-categories');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-categories"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/categories</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-categories"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-categories"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-categories"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-categories"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-categories"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>parentId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="parentId"                data-endpoint="GETapi-categories"
               value="0"
               data-component="query">
    <br>
<p>The ID of the parent category of the sub categories to retrieve. Example: <code>0</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>nestedIncluded</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="nestedIncluded"                data-endpoint="GETapi-categories"
               value="0"
               data-component="query">
    <br>
<p>If parent ID is not provided, are nested entries will be included? - Possible values: 0,1. Example: <code>0</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-categories"
               value=""
               data-component="query">
    <br>
<p>The Comma-separated list of the category relationships for Eager Loading - Possible values: parent,children.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-categories"
               value="-lft"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: lft. Example: <code>-lft</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-categories"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>page</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="page"                data-endpoint="GETapi-categories"
               value="1"
               data-component="query">
    <br>
<p>Items page number. From 1 to (&quot;total items&quot; divided by &quot;items per page value - perPage&quot;). Example: <code>1</code></p>
            </div>
                </form>

                    <h2 id="categories-GETapi-categories--slugOrId-">Get category</h2>

<p>
</p>

<p>Get category by its unique slug or ID.</p>

<span id="example-requests-GETapi-categories--slugOrId-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/categories/cars?parentCatSlug=automobiles" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/categories/cars"
);

const params = {
    "parentCatSlug": "automobiles",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/categories/cars';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'parentCatSlug' =&gt; 'automobiles',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/categories/cars'
params = {
  'parentCatSlug': 'automobiles',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-categories--slugOrId-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 2,
        &quot;parent_id&quot;: 1,
        &quot;name&quot;: &quot;Cars&quot;,
        &quot;slug&quot;: &quot;cars&quot;,
        &quot;description&quot;: &quot;&quot;,
        &quot;hide_description&quot;: null,
        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
        &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
        &quot;seo_title&quot;: &quot;&quot;,
        &quot;seo_description&quot;: &quot;&quot;,
        &quot;seo_keywords&quot;: &quot;&quot;,
        &quot;lft&quot;: 2,
        &quot;rgt&quot;: 3,
        &quot;depth&quot;: 1,
        &quot;type&quot;: &quot;classified&quot;,
        &quot;is_for_permanent&quot;: 0,
        &quot;active&quot;: 1,
        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-categories--slugOrId-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-categories--slugOrId-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-categories--slugOrId-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-categories--slugOrId-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-categories--slugOrId-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-categories--slugOrId-" data-method="GET"
      data-path="api/categories/{slugOrId}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-categories--slugOrId-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-categories--slugOrId-"
                    onclick="tryItOut('GETapi-categories--slugOrId-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-categories--slugOrId-"
                    onclick="cancelTryOut('GETapi-categories--slugOrId-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-categories--slugOrId-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/categories/{slugOrId}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-categories--slugOrId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-categories--slugOrId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-categories--slugOrId-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-categories--slugOrId-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-categories--slugOrId-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>slugOrId</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="slugOrId"                data-endpoint="GETapi-categories--slugOrId-"
               value="cars"
               data-component="url">
    <br>
<p>The slug or ID of the category. Example: <code>cars</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>parentCatSlug</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="parentCatSlug"                data-endpoint="GETapi-categories--slugOrId-"
               value="automobiles"
               data-component="query">
    <br>
<p>The slug of the parent category to retrieve used when category's slug provided instead of ID. Example: <code>automobiles</code></p>
            </div>
                </form>

                    <h2 id="categories-GETapi-categories--id--fields">List category&#039;s fields</h2>

<p>
</p>



<span id="example-requests-GETapi-categories--id--fields">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/categories/1/fields" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"language_code\": \"en\",
    \"post_id\": 1
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/categories/1/fields"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "language_code": "en",
    "post_id": 1
};

fetch(url, {
    method: "GET",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/categories/1/fields';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'language_code' =&gt; 'en',
            'post_id' =&gt; 1,
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/categories/1/fields'
payload = {
    "language_code": "en",
    "post_id": 1
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-categories--id--fields">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: [
        {
            &quot;id&quot;: 1,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Car Brand&quot;,
            &quot;type&quot;: &quot;select&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 1,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 1,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Toyota&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 1,
                    &quot;rgt&quot;: 2,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 2,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;BMW&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 3,
                    &quot;rgt&quot;: 4,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 3,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Mercedes-Benz&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 5,
                    &quot;rgt&quot;: 6,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 4,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Chevrolet&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 7,
                    &quot;rgt&quot;: 8,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 5,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Cadillac&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 9,
                    &quot;rgt&quot;: 10,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 6,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Buick&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 11,
                    &quot;rgt&quot;: 12,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 7,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;GMC&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 13,
                    &quot;rgt&quot;: 14,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 8,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Ford&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 15,
                    &quot;rgt&quot;: 16,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 9,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Chrysler&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 17,
                    &quot;rgt&quot;: 18,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 10,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Dodge&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 19,
                    &quot;rgt&quot;: 20,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 11,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Jeep&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 21,
                    &quot;rgt&quot;: 22,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 12,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Tesla&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 23,
                    &quot;rgt&quot;: 24,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 13,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lexus&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 25,
                    &quot;rgt&quot;: 26,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 14,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Suzuki&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 27,
                    &quot;rgt&quot;: 28,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 15,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Mazda&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 29,
                    &quot;rgt&quot;: 30,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 16,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Honda&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 31,
                    &quot;rgt&quot;: 32,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 17,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Acura&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 33,
                    &quot;rgt&quot;: 34,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 18,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Mitsubishi&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 35,
                    &quot;rgt&quot;: 36,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 19,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Nissan&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 37,
                    &quot;rgt&quot;: 38,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 20,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Infiniti&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 39,
                    &quot;rgt&quot;: 40,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 21,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Audi&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 41,
                    &quot;rgt&quot;: 42,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 22,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Volkswagen&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 43,
                    &quot;rgt&quot;: 44,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 23,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Porsche&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 45,
                    &quot;rgt&quot;: 46,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 24,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Opel&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 47,
                    &quot;rgt&quot;: 48,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 25,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Jaguar&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 49,
                    &quot;rgt&quot;: 50,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 26,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Land Rover&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 51,
                    &quot;rgt&quot;: 52,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 27,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;MINI&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 53,
                    &quot;rgt&quot;: 54,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 28,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Aston Martin&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 55,
                    &quot;rgt&quot;: 56,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 29,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Bentley&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 57,
                    &quot;rgt&quot;: 58,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 30,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Rolls-Royce&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 59,
                    &quot;rgt&quot;: 60,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 31,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;McLaren&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 61,
                    &quot;rgt&quot;: 62,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 32,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Fiat&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 63,
                    &quot;rgt&quot;: 64,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 33,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Alfa Romeo&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 65,
                    &quot;rgt&quot;: 66,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 34,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Maserati&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 67,
                    &quot;rgt&quot;: 68,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 35,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Ferrari&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 69,
                    &quot;rgt&quot;: 70,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 36,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lamborghini&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 71,
                    &quot;rgt&quot;: 72,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 37,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Pagani&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 73,
                    &quot;rgt&quot;: 74,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 38,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lancia&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 75,
                    &quot;rgt&quot;: 76,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 39,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Renault&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 77,
                    &quot;rgt&quot;: 78,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 40,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Peugeot&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 79,
                    &quot;rgt&quot;: 80,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 41,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Citroen&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 81,
                    &quot;rgt&quot;: 82,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 42,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Bugatti&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 83,
                    &quot;rgt&quot;: 84,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 43,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Tata&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 85,
                    &quot;rgt&quot;: 86,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 44,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Hyundai&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 87,
                    &quot;rgt&quot;: 88,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 45,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Kia&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 89,
                    &quot;rgt&quot;: 90,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 46,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Daewoo&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 91,
                    &quot;rgt&quot;: 92,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 47,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Volvo&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 93,
                    &quot;rgt&quot;: 94,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 48,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Saab&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 95,
                    &quot;rgt&quot;: 96,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 49,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lada&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 97,
                    &quot;rgt&quot;: 98,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 50,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Volga&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 99,
                    &quot;rgt&quot;: 100,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 51,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Zil&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 101,
                    &quot;rgt&quot;: 102,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 52,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;GAZ&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 103,
                    &quot;rgt&quot;: 104,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 53,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Geely&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 105,
                    &quot;rgt&quot;: 106,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 54,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Chery&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 107,
                    &quot;rgt&quot;: 108,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 55,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Hongqi&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 109,
                    &quot;rgt&quot;: 110,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 56,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Dacia&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 111,
                    &quot;rgt&quot;: 112,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 57,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Daihatsu&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 113,
                    &quot;rgt&quot;: 114,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 58,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;FIAT&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 115,
                    &quot;rgt&quot;: 116,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 59,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Genesis&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 117,
                    &quot;rgt&quot;: 118,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 60,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Isuzu&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 119,
                    &quot;rgt&quot;: 120,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 61,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lincoln&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 121,
                    &quot;rgt&quot;: 122,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 62,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lotus&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 123,
                    &quot;rgt&quot;: 124,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 63,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Ram&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 125,
                    &quot;rgt&quot;: 126,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 64,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Ram&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 127,
                    &quot;rgt&quot;: 128,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 65,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;SEAT&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 129,
                    &quot;rgt&quot;: 130,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 66,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Skoda&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 131,
                    &quot;rgt&quot;: 132,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 67,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Smart&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 133,
                    &quot;rgt&quot;: 134,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 68,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Subaru&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 135,
                    &quot;rgt&quot;: 136,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 69,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Other&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 137,
                    &quot;rgt&quot;: 138,
                    &quot;depth&quot;: null
                }
            ]
        },
        {
            &quot;id&quot;: 2,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Car Model&quot;,
            &quot;type&quot;: &quot;text&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 0,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: []
        },
        {
            &quot;id&quot;: 3,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Year of registration&quot;,
            &quot;type&quot;: &quot;number&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 0,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: []
        },
        {
            &quot;id&quot;: 5,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Fuel Type&quot;,
            &quot;type&quot;: &quot;select&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 70,
                    &quot;field_id&quot;: 5,
                    &quot;value&quot;: &quot;Essence&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 139,
                    &quot;rgt&quot;: 140,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 71,
                    &quot;field_id&quot;: 5,
                    &quot;value&quot;: &quot;Diesel&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 141,
                    &quot;rgt&quot;: 142,
                    &quot;depth&quot;: null
                }
            ]
        },
        {
            &quot;id&quot;: 7,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Transmission&quot;,
            &quot;type&quot;: &quot;radio&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 76,
                    &quot;field_id&quot;: 7,
                    &quot;value&quot;: &quot;Automatic&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 151,
                    &quot;rgt&quot;: 152,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 77,
                    &quot;field_id&quot;: 7,
                    &quot;value&quot;: &quot;Manual&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 153,
                    &quot;rgt&quot;: 154,
                    &quot;depth&quot;: null
                }
            ]
        },
        {
            &quot;id&quot;: 8,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Condition&quot;,
            &quot;type&quot;: &quot;select&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 78,
                    &quot;field_id&quot;: 8,
                    &quot;value&quot;: &quot;New&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 155,
                    &quot;rgt&quot;: 156,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 79,
                    &quot;field_id&quot;: 8,
                    &quot;value&quot;: &quot;Used&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 157,
                    &quot;rgt&quot;: 158,
                    &quot;depth&quot;: null
                }
            ]
        },
        {
            &quot;id&quot;: 4,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Mileage&quot;,
            &quot;type&quot;: &quot;text&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 0,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: []
        },
        {
            &quot;id&quot;: 6,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Features&quot;,
            &quot;type&quot;: &quot;checkbox_multiple&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 72,
                    &quot;field_id&quot;: 6,
                    &quot;value&quot;: &quot;Air Conditioner&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 143,
                    &quot;rgt&quot;: 144,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 73,
                    &quot;field_id&quot;: 6,
                    &quot;value&quot;: &quot;GPS&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 145,
                    &quot;rgt&quot;: 146,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 74,
                    &quot;field_id&quot;: 6,
                    &quot;value&quot;: &quot;Security System&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 147,
                    &quot;rgt&quot;: 148,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 75,
                    &quot;field_id&quot;: 6,
                    &quot;value&quot;: &quot;Spare Tire&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 149,
                    &quot;rgt&quot;: 150,
                    &quot;depth&quot;: null
                }
            ]
        }
    ],
    &quot;extra&quot;: {
        &quot;errors&quot;: [],
        &quot;oldInput&quot;: null
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-categories--id--fields" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-categories--id--fields"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-categories--id--fields"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-categories--id--fields" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-categories--id--fields">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-categories--id--fields" data-method="GET"
      data-path="api/categories/{id}/fields"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-categories--id--fields', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-categories--id--fields"
                    onclick="tryItOut('GETapi-categories--id--fields');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-categories--id--fields"
                    onclick="cancelTryOut('GETapi-categories--id--fields');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-categories--id--fields"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/categories/{id}/fields</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-categories--id--fields"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-categories--id--fields"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-categories--id--fields"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-categories--id--fields"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-categories--id--fields"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-categories--id--fields"
               value="1"
               data-component="url">
    <br>
<p>The ID of the category. Example: <code>1</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>language_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="language_code"                data-endpoint="GETapi-categories--id--fields"
               value="en"
               data-component="body">
    <br>
<p>The code of the user's spoken language. Example: <code>en</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_id"                data-endpoint="GETapi-categories--id--fields"
               value="1"
               data-component="body">
    <br>
<p>The unique ID of the post. Example: <code>1</code></p>
        </div>
        </form>

                    <h2 id="categories-POSTapi-categories--id--fields">List category&#039;s fields</h2>

<p>
</p>



<span id="example-requests-POSTapi-categories--id--fields">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/categories/1/fields" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"language_code\": \"en\",
    \"post_id\": 1
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/categories/1/fields"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "language_code": "en",
    "post_id": 1
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/categories/1/fields';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'language_code' =&gt; 'en',
            'post_id' =&gt; 1,
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/categories/1/fields'
payload = {
    "language_code": "en",
    "post_id": 1
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-categories--id--fields">
</span>
<span id="execution-results-POSTapi-categories--id--fields" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-categories--id--fields"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-categories--id--fields"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-categories--id--fields" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-categories--id--fields">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-categories--id--fields" data-method="POST"
      data-path="api/categories/{id}/fields"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-categories--id--fields', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-categories--id--fields"
                    onclick="tryItOut('POSTapi-categories--id--fields');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-categories--id--fields"
                    onclick="cancelTryOut('POSTapi-categories--id--fields');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-categories--id--fields"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/categories/{id}/fields</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-categories--id--fields"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-categories--id--fields"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-categories--id--fields"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-categories--id--fields"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-categories--id--fields"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="POSTapi-categories--id--fields"
               value="1"
               data-component="url">
    <br>
<p>The ID of the category. Example: <code>1</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>language_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="language_code"                data-endpoint="POSTapi-categories--id--fields"
               value="en"
               data-component="body">
    <br>
<p>The code of the user's spoken language. Example: <code>en</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_id"                data-endpoint="POSTapi-categories--id--fields"
               value="1"
               data-component="body">
    <br>
<p>The unique ID of the post. Example: <code>1</code></p>
        </div>
        </form>

                <h1 id="contact">Contact</h1>

    

                                <h2 id="contact-POSTapi-contact">Send Form</h2>

<p>
</p>

<p>Send a message to the site owner.</p>

<span id="example-requests-POSTapi-contact">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/contact" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"name\": \"voluptas\",
    \"email\": \"john.doe@domain.tld\",
    \"phone\": \"sed\",
    \"message\": \"Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.\",
    \"country_code\": \"US\",
    \"country_name\": \"United Sates\",
    \"first_name\": \"John\",
    \"last_name\": \"Doe\",
    \"captcha_key\": \"quis\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/contact"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "name": "voluptas",
    "email": "john.doe@domain.tld",
    "phone": "sed",
    "message": "Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.",
    "country_code": "US",
    "country_name": "United Sates",
    "first_name": "John",
    "last_name": "Doe",
    "captcha_key": "quis"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/contact';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'name' =&gt; 'voluptas',
            'email' =&gt; 'john.doe@domain.tld',
            'phone' =&gt; 'sed',
            'message' =&gt; 'Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.',
            'country_code' =&gt; 'US',
            'country_name' =&gt; 'United Sates',
            'first_name' =&gt; 'John',
            'last_name' =&gt; 'Doe',
            'captcha_key' =&gt; 'quis',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/contact'
payload = {
    "name": "voluptas",
    "email": "john.doe@domain.tld",
    "phone": "sed",
    "message": "Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.",
    "country_code": "US",
    "country_name": "United Sates",
    "first_name": "John",
    "last_name": "Doe",
    "captcha_key": "quis"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-contact">
</span>
<span id="execution-results-POSTapi-contact" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-contact"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-contact"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-contact" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-contact">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-contact" data-method="POST"
      data-path="api/contact"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-contact', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-contact"
                    onclick="tryItOut('POSTapi-contact');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-contact"
                    onclick="cancelTryOut('POSTapi-contact');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-contact"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/contact</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-contact"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-contact"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-contact"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-contact"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-contact"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="name"                data-endpoint="POSTapi-contact"
               value="voluptas"
               data-component="body">
    <br>
<p>Example: <code>voluptas</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-contact"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The user's email address. Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-contact"
               value="sed"
               data-component="body">
    <br>
<p>Example: <code>sed</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>message</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="message"                data-endpoint="POSTapi-contact"
               value="Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur."
               data-component="body">
    <br>
<p>The message to send. Example: <code>Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_code"                data-endpoint="POSTapi-contact"
               value="US"
               data-component="body">
    <br>
<p>The user's country code. Example: <code>US</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_name"                data-endpoint="POSTapi-contact"
               value="United Sates"
               data-component="body">
    <br>
<p>The user's country name. Example: <code>United Sates</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>first_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="first_name"                data-endpoint="POSTapi-contact"
               value="John"
               data-component="body">
    <br>
<p>The user's first name. Example: <code>John</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>last_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="last_name"                data-endpoint="POSTapi-contact"
               value="Doe"
               data-component="body">
    <br>
<p>The user's last name. Example: <code>Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-contact"
               value="quis"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>quis</code></p>
        </div>
        </form>

                    <h2 id="contact-POSTapi-posts--id--report">Report post</h2>

<p>
</p>

<p>Report abuse or issues</p>

<span id="example-requests-POSTapi-posts--id--report">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/posts/3/report" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"report_type_id\": 2,
    \"email\": \"john.doe@domain.tld\",
    \"message\": \"Et sunt voluptatibus ducimus id assumenda sint.\",
    \"captcha_key\": \"animi\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/3/report"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "report_type_id": 2,
    "email": "john.doe@domain.tld",
    "message": "Et sunt voluptatibus ducimus id assumenda sint.",
    "captcha_key": "animi"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/3/report';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'report_type_id' =&gt; 2,
            'email' =&gt; 'john.doe@domain.tld',
            'message' =&gt; 'Et sunt voluptatibus ducimus id assumenda sint.',
            'captcha_key' =&gt; 'animi',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/3/report'
payload = {
    "report_type_id": 2,
    "email": "john.doe@domain.tld",
    "message": "Et sunt voluptatibus ducimus id assumenda sint.",
    "captcha_key": "animi"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-posts--id--report">
</span>
<span id="execution-results-POSTapi-posts--id--report" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-posts--id--report"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-posts--id--report"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-posts--id--report" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-posts--id--report">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-posts--id--report" data-method="POST"
      data-path="api/posts/{id}/report"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-posts--id--report', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-posts--id--report"
                    onclick="tryItOut('POSTapi-posts--id--report');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-posts--id--report"
                    onclick="cancelTryOut('POSTapi-posts--id--report');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-posts--id--report"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/posts/{id}/report</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-posts--id--report"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-posts--id--report"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-posts--id--report"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-posts--id--report"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-posts--id--report"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="POSTapi-posts--id--report"
               value="3"
               data-component="url">
    <br>
<p>The post ID. Example: <code>3</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>report_type_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="report_type_id"                data-endpoint="POSTapi-posts--id--report"
               value="2"
               data-component="body">
    <br>
<p>The report type ID. Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-posts--id--report"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The user's email address. Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>message</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="message"                data-endpoint="POSTapi-posts--id--report"
               value="Et sunt voluptatibus ducimus id assumenda sint."
               data-component="body">
    <br>
<p>The message to send. Example: <code>Et sunt voluptatibus ducimus id assumenda sint.</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-posts--id--report"
               value="animi"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>animi</code></p>
        </div>
        </form>

                <h1 id="countries">Countries</h1>

    

                                <h2 id="countries-GETapi-countries">List countries</h2>

<p>
</p>



<span id="example-requests-GETapi-countries">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries?embed=&amp;includeNonActive=&amp;iti=%27onlyCountries%27&amp;countryCode=&amp;sort=-name&amp;perPage=2" \
    --header "Content-Language: en" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries"
);

const params = {
    "embed": "",
    "includeNonActive": "0",
    "iti": "'onlyCountries'",
    "countryCode": "",
    "sort": "-name",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Language": "en",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Language' =&gt; 'en',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'includeNonActive' =&gt; '0',
            'iti' =&gt; ''onlyCountries'',
            'countryCode' =&gt; '',
            'sort' =&gt; '-name',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries'
params = {
  'embed': '',
  'includeNonActive': '0',
  'iti': ''onlyCountries'',
  'countryCode': '',
  'sort': '-name',
  'perPage': '2',
}
headers = {
  'Content-Language': 'en',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries">
            <blockquote>
            <p>Example response (400):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;No data available. Only \&quot;i18n\&quot; and \&quot;onlyCountries\&quot; are accepted for the \&quot;iti\&quot; parameter.&quot;,
    &quot;result&quot;: null
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries" data-method="GET"
      data-path="api/countries"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries"
                    onclick="tryItOut('GETapi-countries');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries"
                    onclick="cancelTryOut('GETapi-countries');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the country relationships for Eager Loading - Possible values: currency,continent.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>includeNonActive</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-countries" style="display: none">
            <input type="radio" name="includeNonActive"
                   value="1"
                   data-endpoint="GETapi-countries"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-countries" style="display: none">
            <input type="radio" name="includeNonActive"
                   value="0"
                   data-endpoint="GETapi-countries"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow including the non-activated countries in the list. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>iti</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="iti"                data-endpoint="GETapi-countries"
               value="'onlyCountries'"
               data-component="query">
    <br>
<p>Allow getting option data for the phone number input. Possible value: 'i18n' or 'onlyCountries'. Example: <code>'onlyCountries'</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-countries"
               value=""
               data-component="query">
    <br>
<p>The code of the current country (Only when the 'iti' parameter is filled to true).</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-countries"
               value="-name"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: name. Example: <code>-name</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-countries"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-countries--code-">Get country</h2>

<p>
</p>



<span id="example-requests-GETapi-countries--code-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries/DE?embed=currency" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries/DE"
);

const params = {
    "embed": "currency",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries/DE';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; 'currency',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries/DE'
params = {
  'embed': 'currency',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries--code-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;code&quot;: &quot;DE&quot;,
        &quot;name&quot;: &quot;Germany&quot;,
        &quot;capital&quot;: &quot;Berlin&quot;,
        &quot;continent_code&quot;: &quot;EU&quot;,
        &quot;tld&quot;: &quot;.de&quot;,
        &quot;currency_code&quot;: &quot;EUR&quot;,
        &quot;phone&quot;: &quot;49&quot;,
        &quot;languages&quot;: &quot;de&quot;,
        &quot;time_zone&quot;: null,
        &quot;date_format&quot;: null,
        &quot;datetime_format&quot;: null,
        &quot;background_image_path&quot;: &quot;app/logo/header-67e81c88bbc2f.jpg&quot;,
        &quot;admin_type&quot;: &quot;1&quot;,
        &quot;active&quot;: 1,
        &quot;icode&quot;: &quot;de&quot;,
        &quot;flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/de.png&quot;,
        &quot;flag16_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/de.png&quot;,
        &quot;flag24_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/24/de.png&quot;,
        &quot;flag32_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/32/de.png&quot;,
        &quot;flag48_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/48/de.png&quot;,
        &quot;flag64_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/64/de.png&quot;,
        &quot;background_image_url&quot;: null,
        &quot;currency&quot;: {
            &quot;code&quot;: &quot;EUR&quot;,
            &quot;name&quot;: &quot;Euro Member Countries&quot;,
            &quot;symbol&quot;: &quot;&euro;&quot;,
            &quot;html_entities&quot;: &quot;&euro;&quot;,
            &quot;in_left&quot;: 0,
            &quot;decimal_places&quot;: 2,
            &quot;decimal_separator&quot;: &quot;,&quot;,
            &quot;thousand_separator&quot;: &quot; &quot;
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries--code-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries--code-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries--code-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries--code-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries--code-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries--code-" data-method="GET"
      data-path="api/countries/{code}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries--code-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries--code-"
                    onclick="tryItOut('GETapi-countries--code-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries--code-"
                    onclick="cancelTryOut('GETapi-countries--code-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries--code-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries/{code}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries--code-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries--code-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries--code-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="code"                data-endpoint="GETapi-countries--code-"
               value="DE"
               data-component="url">
    <br>
<p>The country's ISO 3166-1 code. Example: <code>DE</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries--code-"
               value="currency"
               data-component="query">
    <br>
<p>Comma-separated list of the country relationships for Eager Loading - Possible values: currency. Example: <code>currency</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-countries--countryCode--subAdmins1">List admin. divisions (1)</h2>

<p>
</p>



<span id="example-requests-GETapi-countries--countryCode--subAdmins1">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries/US/subAdmins1?embed=&amp;q=&amp;sort=-name&amp;perPage=2&amp;page=1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries/US/subAdmins1"
);

const params = {
    "embed": "",
    "q": "",
    "sort": "-name",
    "perPage": "2",
    "page": "1",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries/US/subAdmins1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'q' =&gt; '',
            'sort' =&gt; '-name',
            'perPage' =&gt; '2',
            'page' =&gt; '1',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries/US/subAdmins1'
params = {
  'embed': '',
  'q': '',
  'sort': '-name',
  'perPage': '2',
  'page': '1',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries--countryCode--subAdmins1">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;code&quot;: &quot;US.WY&quot;,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;name&quot;: &quot;Wyoming&quot;,
                &quot;active&quot;: 1
            },
            {
                &quot;code&quot;: &quot;US.WV&quot;,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;name&quot;: &quot;West Virginia&quot;,
                &quot;active&quot;: 1
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=26&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 26,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=7&quot;,
                    &quot;label&quot;: &quot;7&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=8&quot;,
                    &quot;label&quot;: &quot;8&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=9&quot;,
                    &quot;label&quot;: &quot;9&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=10&quot;,
                    &quot;label&quot;: &quot;10&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;...&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=25&quot;,
                    &quot;label&quot;: &quot;25&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=26&quot;,
                    &quot;label&quot;: &quot;26&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 51
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries--countryCode--subAdmins1" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries--countryCode--subAdmins1"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries--countryCode--subAdmins1"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries--countryCode--subAdmins1" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries--countryCode--subAdmins1">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries--countryCode--subAdmins1" data-method="GET"
      data-path="api/countries/{countryCode}/subAdmins1"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries--countryCode--subAdmins1', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries--countryCode--subAdmins1"
                    onclick="tryItOut('GETapi-countries--countryCode--subAdmins1');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries--countryCode--subAdmins1"
                    onclick="cancelTryOut('GETapi-countries--countryCode--subAdmins1');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries--countryCode--subAdmins1"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries/{countryCode}/subAdmins1</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="US"
               data-component="url">
    <br>
<p>The country code of the country of the cities to retrieve. Example: <code>US</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the administrative division (1) relationships for Eager Loading - Possible values: country.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>q</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="q"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value=""
               data-component="query">
    <br>
<p>Get the administrative division list related to the entered keyword.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="-name"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: name. Example: <code>-name</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>page</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="page"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="1"
               data-component="query">
    <br>
<p>Items page number. From 1 to (&quot;total items&quot; divided by &quot;items per page value - perPage&quot;). Example: <code>1</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-countries--countryCode--subAdmins2">List admin. divisions (2)</h2>

<p>
</p>



<span id="example-requests-GETapi-countries--countryCode--subAdmins2">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries/US/subAdmins2?embed=&amp;admin1Code=&amp;q=&amp;sort=-name&amp;perPage=2&amp;page=1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries/US/subAdmins2"
);

const params = {
    "embed": "",
    "admin1Code": "",
    "q": "",
    "sort": "-name",
    "perPage": "2",
    "page": "1",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries/US/subAdmins2';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'admin1Code' =&gt; '',
            'q' =&gt; '',
            'sort' =&gt; '-name',
            'perPage' =&gt; '2',
            'page' =&gt; '1',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries/US/subAdmins2'
params = {
  'embed': '',
  'admin1Code': '',
  'q': '',
  'sort': '-name',
  'perPage': '2',
  'page': '1',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries--countryCode--subAdmins2">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;code&quot;: &quot;US.WY.045&quot;,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;subadmin1_code&quot;: &quot;US.WY&quot;,
                &quot;name&quot;: &quot;Weston County&quot;,
                &quot;active&quot;: 1
            },
            {
                &quot;code&quot;: &quot;US.WY.043&quot;,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;subadmin1_code&quot;: &quot;US.WY&quot;,
                &quot;name&quot;: &quot;Washakie County&quot;,
                &quot;active&quot;: 1
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1572&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 1572,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=7&quot;,
                    &quot;label&quot;: &quot;7&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=8&quot;,
                    &quot;label&quot;: &quot;8&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=9&quot;,
                    &quot;label&quot;: &quot;9&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=10&quot;,
                    &quot;label&quot;: &quot;10&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;...&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1571&quot;,
                    &quot;label&quot;: &quot;1571&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1572&quot;,
                    &quot;label&quot;: &quot;1572&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 3143
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries--countryCode--subAdmins2" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries--countryCode--subAdmins2"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries--countryCode--subAdmins2"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries--countryCode--subAdmins2" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries--countryCode--subAdmins2">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries--countryCode--subAdmins2" data-method="GET"
      data-path="api/countries/{countryCode}/subAdmins2"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries--countryCode--subAdmins2', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries--countryCode--subAdmins2"
                    onclick="tryItOut('GETapi-countries--countryCode--subAdmins2');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries--countryCode--subAdmins2"
                    onclick="cancelTryOut('GETapi-countries--countryCode--subAdmins2');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries--countryCode--subAdmins2"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries/{countryCode}/subAdmins2</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="US"
               data-component="url">
    <br>
<p>The country code of the country of the cities to retrieve. Example: <code>US</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the administrative division (2) relationships for Eager Loading - Possible values: country,subAdmin1.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>admin1Code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin1Code"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value=""
               data-component="query">
    <br>
<p>Get the administrative division 2 list related to the administrative division 1 code.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>q</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="q"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value=""
               data-component="query">
    <br>
<p>Get the administrative division 2 list related to the entered keyword.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="-name"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: name. Example: <code>-name</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>page</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="page"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="1"
               data-component="query">
    <br>
<p>Items page number. From 1 to (&quot;total items&quot; divided by &quot;items per page value - perPage&quot;). Example: <code>1</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-countries--countryCode--cities">List cities</h2>

<p>
</p>



<span id="example-requests-GETapi-countries--countryCode--cities">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries/US/cities?embed=&amp;admin1Code=&amp;admin2Code=&amp;q=&amp;autocomplete=&amp;sort=-name&amp;perPage=2&amp;page=1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries/US/cities"
);

const params = {
    "embed": "",
    "admin1Code": "",
    "admin2Code": "",
    "q": "",
    "autocomplete": "0",
    "sort": "-name",
    "perPage": "2",
    "page": "1",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries/US/cities';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'admin1Code' =&gt; '',
            'admin2Code' =&gt; '',
            'q' =&gt; '',
            'autocomplete' =&gt; '0',
            'sort' =&gt; '-name',
            'perPage' =&gt; '2',
            'page' =&gt; '1',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries/US/cities'
params = {
  'embed': '',
  'admin1Code': '',
  'admin2Code': '',
  'q': '',
  'autocomplete': '0',
  'sort': '-name',
  'perPage': '2',
  'page': '1',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries--countryCode--cities">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 50797,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;name&quot;: &quot;Communications Hill&quot;,
                &quot;latitude&quot;: 37.29,
                &quot;longitude&quot;: -121.86,
                &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                &quot;subadmin2_code&quot;: &quot;US.CA.085&quot;,
                &quot;population&quot;: 11267,
                &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                &quot;active&quot;: 1,
                &quot;posts_count&quot;: 0
            },
            {
                &quot;id&quot;: 50796,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;name&quot;: &quot;James Island&quot;,
                &quot;latitude&quot;: 32.72,
                &quot;longitude&quot;: -79.96,
                &quot;subadmin1_code&quot;: &quot;US.SC&quot;,
                &quot;subadmin2_code&quot;: &quot;US.SC.019&quot;,
                &quot;population&quot;: 6000,
                &quot;time_zone&quot;: &quot;America/New_York&quot;,
                &quot;active&quot;: 1,
                &quot;posts_count&quot;: 0
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=3600&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 3600,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=7&quot;,
                    &quot;label&quot;: &quot;7&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=8&quot;,
                    &quot;label&quot;: &quot;8&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=9&quot;,
                    &quot;label&quot;: &quot;9&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=10&quot;,
                    &quot;label&quot;: &quot;10&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;...&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=3599&quot;,
                    &quot;label&quot;: &quot;3599&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=3600&quot;,
                    &quot;label&quot;: &quot;3600&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 7200
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries--countryCode--cities" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries--countryCode--cities"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries--countryCode--cities"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries--countryCode--cities" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries--countryCode--cities">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries--countryCode--cities" data-method="GET"
      data-path="api/countries/{countryCode}/cities"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries--countryCode--cities', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries--countryCode--cities"
                    onclick="tryItOut('GETapi-countries--countryCode--cities');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries--countryCode--cities"
                    onclick="cancelTryOut('GETapi-countries--countryCode--cities');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries--countryCode--cities"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries/{countryCode}/cities</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries--countryCode--cities"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries--countryCode--cities"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries--countryCode--cities"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries--countryCode--cities"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries--countryCode--cities"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-countries--countryCode--cities"
               value="US"
               data-component="url">
    <br>
<p>The country code of the country of the cities to retrieve. Example: <code>US</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries--countryCode--cities"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the city relationships for Eager Loading - Possible values: country,subAdmin1,subAdmin2.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>admin1Code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin1Code"                data-endpoint="GETapi-countries--countryCode--cities"
               value=""
               data-component="query">
    <br>
<p>Get the city list related to the administrative division 1 code.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>admin2Code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin2Code"                data-endpoint="GETapi-countries--countryCode--cities"
               value=""
               data-component="query">
    <br>
<p>Get the city list related to the administrative division 2 code.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>q</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="q"                data-endpoint="GETapi-countries--countryCode--cities"
               value=""
               data-component="query">
    <br>
<p>Get the city list related to the entered keyword.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>autocomplete</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-countries--countryCode--cities" style="display: none">
            <input type="radio" name="autocomplete"
                   value="1"
                   data-endpoint="GETapi-countries--countryCode--cities"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-countries--countryCode--cities" style="display: none">
            <input type="radio" name="autocomplete"
                   value="0"
                   data-endpoint="GETapi-countries--countryCode--cities"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the city list in the autocomplete data format. Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-countries--countryCode--cities"
               value="-name"
               data-component="query">
    <br>
<p>string|array The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: name,population. Example: <code>-name</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-countries--countryCode--cities"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>page</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="page"                data-endpoint="GETapi-countries--countryCode--cities"
               value="1"
               data-component="query">
    <br>
<p>Items page number. From 1 to (&quot;total items&quot; divided by &quot;items per page value - perPage&quot;). Example: <code>1</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-subAdmins1--code-">Get admin. division (1)</h2>

<p>
</p>



<span id="example-requests-GETapi-subAdmins1--code-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/subAdmins1/CH.VD?embed=" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/subAdmins1/CH.VD"
);

const params = {
    "embed": "",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/subAdmins1/CH.VD';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/subAdmins1/CH.VD'
params = {
  'embed': '',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-subAdmins1--code-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: &quot;No administrative divisions found&quot;,
    &quot;result&quot;: {
        &quot;data&quot;: [],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/subAdmins1/CH.VD?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/subAdmins1/CH.VD?page=1&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: null
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: null,
            &quot;last_page&quot;: 1,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/subAdmins1/CH.VD?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/subAdmins1/CH.VD&quot;,
            &quot;per_page&quot;: 39,
            &quot;to&quot;: null,
            &quot;total&quot;: 0
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-subAdmins1--code-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-subAdmins1--code-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-subAdmins1--code-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-subAdmins1--code-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-subAdmins1--code-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-subAdmins1--code-" data-method="GET"
      data-path="api/subAdmins1/{code}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-subAdmins1--code-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-subAdmins1--code-"
                    onclick="tryItOut('GETapi-subAdmins1--code-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-subAdmins1--code-"
                    onclick="cancelTryOut('GETapi-subAdmins1--code-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-subAdmins1--code-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/subAdmins1/{code}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-subAdmins1--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-subAdmins1--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-subAdmins1--code-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-subAdmins1--code-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-subAdmins1--code-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="code"                data-endpoint="GETapi-subAdmins1--code-"
               value="CH.VD"
               data-component="url">
    <br>
<p>The administrative division (1)'s code. Example: <code>CH.VD</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-subAdmins1--code-"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the administrative division (1) relationships for Eager Loading - Possible values: country.</p>
            </div>
                </form>

                    <h2 id="countries-GETapi-subAdmins2--code-">Get admin. division (2)</h2>

<p>
</p>



<span id="example-requests-GETapi-subAdmins2--code-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/subAdmins2/CH.VD.2225?embed=" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/subAdmins2/CH.VD.2225"
);

const params = {
    "embed": "",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/subAdmins2/CH.VD.2225';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/subAdmins2/CH.VD.2225'
params = {
  'embed': '',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-subAdmins2--code-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;code&quot;: &quot;CH.VD.2225&quot;,
        &quot;country_code&quot;: &quot;CH&quot;,
        &quot;subadmin1_code&quot;: &quot;CH.VD&quot;,
        &quot;name&quot;: &quot;Lausanne District&quot;,
        &quot;active&quot;: 1
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-subAdmins2--code-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-subAdmins2--code-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-subAdmins2--code-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-subAdmins2--code-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-subAdmins2--code-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-subAdmins2--code-" data-method="GET"
      data-path="api/subAdmins2/{code}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-subAdmins2--code-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-subAdmins2--code-"
                    onclick="tryItOut('GETapi-subAdmins2--code-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-subAdmins2--code-"
                    onclick="cancelTryOut('GETapi-subAdmins2--code-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-subAdmins2--code-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/subAdmins2/{code}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-subAdmins2--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-subAdmins2--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-subAdmins2--code-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-subAdmins2--code-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-subAdmins2--code-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="code"                data-endpoint="GETapi-subAdmins2--code-"
               value="CH.VD.2225"
               data-component="url">
    <br>
<p>The administrative division (2)'s code. Example: <code>CH.VD.2225</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-subAdmins2--code-"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the administrative division (2) relationships for Eager Loading - Possible values: country,subAdmin1.</p>
            </div>
                </form>

                    <h2 id="countries-GETapi-cities--id-">Get city</h2>

<p>
</p>



<span id="example-requests-GETapi-cities--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/cities/12544?embed=country" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/cities/12544"
);

const params = {
    "embed": "country",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/cities/12544';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; 'country',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/cities/12544'
params = {
  'embed': 'country',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-cities--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 12544,
        &quot;country_code&quot;: &quot;DE&quot;,
        &quot;name&quot;: &quot;Berlin&quot;,
        &quot;latitude&quot;: 52.52,
        &quot;longitude&quot;: 13.41,
        &quot;subadmin1_code&quot;: &quot;DE.16&quot;,
        &quot;subadmin2_code&quot;: &quot;DE.16.00&quot;,
        &quot;population&quot;: 3426354,
        &quot;time_zone&quot;: &quot;Europe/Berlin&quot;,
        &quot;active&quot;: 1,
        &quot;posts_count&quot;: 0,
        &quot;country&quot;: {
            &quot;code&quot;: &quot;DE&quot;,
            &quot;name&quot;: &quot;Germany&quot;,
            &quot;capital&quot;: &quot;Berlin&quot;,
            &quot;continent_code&quot;: &quot;EU&quot;,
            &quot;tld&quot;: &quot;.de&quot;,
            &quot;currency_code&quot;: &quot;EUR&quot;,
            &quot;phone&quot;: &quot;49&quot;,
            &quot;languages&quot;: &quot;de&quot;,
            &quot;time_zone&quot;: null,
            &quot;date_format&quot;: null,
            &quot;datetime_format&quot;: null,
            &quot;background_image_path&quot;: &quot;app/logo/header-67e81c88bbc2f.jpg&quot;,
            &quot;admin_type&quot;: &quot;1&quot;,
            &quot;active&quot;: 1,
            &quot;icode&quot;: &quot;de&quot;,
            &quot;flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/de.png&quot;,
            &quot;flag16_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/de.png&quot;,
            &quot;flag24_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/24/de.png&quot;,
            &quot;flag32_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/32/de.png&quot;,
            &quot;flag48_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/48/de.png&quot;,
            &quot;flag64_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/64/de.png&quot;,
            &quot;background_image_url&quot;: null
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-cities--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-cities--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-cities--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-cities--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-cities--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-cities--id-" data-method="GET"
      data-path="api/cities/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-cities--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-cities--id-"
                    onclick="tryItOut('GETapi-cities--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-cities--id-"
                    onclick="cancelTryOut('GETapi-cities--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-cities--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/cities/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-cities--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-cities--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-cities--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-cities--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-cities--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-cities--id-"
               value="12544"
               data-component="url">
    <br>
<p>The city's ID. Example: <code>12544</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-cities--id-"
               value="country"
               data-component="query">
    <br>
<p>Comma-separated list of the city relationships for Eager Loading - Possible values: country,subAdmin1,subAdmin2. Example: <code>country</code></p>
            </div>
                </form>

                <h1 id="home">Home</h1>

    

                                <h2 id="home-GETapi-sections">List sections</h2>

<p>
</p>



<span id="example-requests-GETapi-sections">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/sections" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/sections"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/sections';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/sections'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-sections">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: {
            &quot;search_form&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;key&quot;: &quot;search_form&quot;,
                &quot;data&quot;: [],
                &quot;options&quot;: {
                    &quot;enable_form_area_customization&quot;: &quot;1&quot;,
                    &quot;background_color&quot;: null,
                    &quot;background_image&quot;: null,
                    &quot;background_image_darken&quot;: &quot;0.1&quot;,
                    &quot;height&quot;: null,
                    &quot;parallax&quot;: &quot;0&quot;,
                    &quot;hide_form&quot;: &quot;0&quot;,
                    &quot;form_border_color&quot;: null,
                    &quot;form_border_width&quot;: null,
                    &quot;form_btn_background_color&quot;: null,
                    &quot;form_btn_text_color&quot;: null,
                    &quot;hide_titles&quot;: &quot;0&quot;,
                    &quot;title_en&quot;: &quot;Sell and Buy near you&quot;,
                    &quot;sub_title_en&quot;: &quot;Simple, fast and efficient&quot;,
                    &quot;title_fr&quot;: &quot;Vendre et acheter pr&egrave;s de chez vous&quot;,
                    &quot;sub_title_fr&quot;: &quot;Simple, rapide et efficace&quot;,
                    &quot;title_es&quot;: &quot;Vender y comprar cerca de usted&quot;,
                    &quot;sub_title_es&quot;: &quot;Simple, r&aacute;pido y eficiente&quot;,
                    &quot;title_ar&quot;: &quot;بيع وشراء بالقرب منك&quot;,
                    &quot;sub_title_ar&quot;: &quot;بسيطة وسريعة وفعالة&quot;,
                    &quot;title_pt&quot;: &quot;Vender e comprar perto de si&quot;,
                    &quot;sub_title_pt&quot;: &quot;Simples, R&aacute;pido e Eficiente&quot;,
                    &quot;title_ru&quot;: &quot;Продавайте и покупайте рядом с вами&quot;,
                    &quot;sub_title_ru&quot;: &quot;Просто, быстро и эффективно&quot;,
                    &quot;title_tr&quot;: &quot;Size yakın satıp satın alın&quot;,
                    &quot;sub_title_tr&quot;: &quot;Basit, hızlı ve verimli&quot;,
                    &quot;title_th&quot;: &quot;ขายและซื้อใกล้บ้านคุณ&quot;,
                    &quot;sub_title_th&quot;: &quot;ง่ายรวดเร็วและมีประสิทธิภาพ&quot;,
                    &quot;title_ka&quot;: &quot;გაყიდვა და შეძენა ახლოს თქვენ&quot;,
                    &quot;sub_title_ka&quot;: &quot;მარტივი, სწრაფი და ეფექტური&quot;,
                    &quot;title_zh&quot;: &quot;在您附近买卖&quot;,
                    &quot;sub_title_zh&quot;: &quot;简单，快速，高效&quot;,
                    &quot;title_ja&quot;: &quot;お近くの売買&quot;,
                    &quot;sub_title_ja&quot;: &quot;シンプル、迅速かつ効率的&quot;,
                    &quot;title_it&quot;: &quot;Vendi e compra vicino a te&quot;,
                    &quot;sub_title_it&quot;: &quot;Semplice, veloce ed efficiente&quot;,
                    &quot;big_title_color&quot;: null,
                    &quot;sub_title_color&quot;: null,
                    &quot;hide_on_mobile&quot;: &quot;0&quot;,
                    &quot;active&quot;: &quot;1&quot;,
                    &quot;enable_extended_form_area&quot;: &quot;1&quot;,
                    &quot;background_image_path&quot;: null,
                    &quot;title_de&quot;: &quot;Verkaufen und Kaufen in Ihrer N&auml;he&quot;,
                    &quot;sub_title_de&quot;: &quot;Einfach, schnell und effizient&quot;,
                    &quot;title_hi&quot;: &quot;अपने पास बेचें और खरीदें&quot;,
                    &quot;sub_title_hi&quot;: &quot;सरल, तेज और कुशल&quot;,
                    &quot;title_bn&quot;: &quot;আপনার কাছাকাছি বিক্রি করুন এবং কিনুন&quot;,
                    &quot;sub_title_bn&quot;: &quot;সহজ, দ্রুত এবং দক্ষ&quot;,
                    &quot;title_he&quot;: &quot;למכור ולקנות בקרבתך&quot;,
                    &quot;sub_title_he&quot;: &quot;פשוט, מהיר ויעיל&quot;,
                    &quot;title_ro&quot;: &quot;Vinde și Cumpără inteligent&quot;,
                    &quot;sub_title_ro&quot;: &quot;Simplu, rapid și eficient!&quot;,
                    &quot;background_image_url&quot;: null
                },
                &quot;lft&quot;: 0
            },
            &quot;categories&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;key&quot;: &quot;categories&quot;,
                &quot;data&quot;: {
                    &quot;categories&quot;: {
                        &quot;1&quot;: {
                            &quot;id&quot;: 1,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Automobiles&quot;,
                            &quot;slug&quot;: &quot;automobiles&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 1,
                            &quot;rgt&quot;: 10,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;9&quot;: {
                            &quot;id&quot;: 9,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Phones &amp; Tablets&quot;,
                            &quot;slug&quot;: &quot;phones-and-tablets&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-mobile-screen-button&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 11,
                            &quot;rgt&quot;: 17,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;14&quot;: {
                            &quot;id&quot;: 14,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Electronics&quot;,
                            &quot;slug&quot;: &quot;electronics&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-laptop&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 18,
                            &quot;rgt&quot;: 35,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;30&quot;: {
                            &quot;id&quot;: 30,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Furniture &amp; Appliances&quot;,
                            &quot;slug&quot;: &quot;furniture-appliances&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-couch&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 36,
                            &quot;rgt&quot;: 44,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;37&quot;: {
                            &quot;id&quot;: 37,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Real estate&quot;,
                            &quot;slug&quot;: &quot;real-estate&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-house&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 45,
                            &quot;rgt&quot;: 55,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;46&quot;: {
                            &quot;id&quot;: 46,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Animals &amp; Pets&quot;,
                            &quot;slug&quot;: &quot;animals-and-pets&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-paw&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 56,
                            &quot;rgt&quot;: 65,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;54&quot;: {
                            &quot;id&quot;: 54,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Fashion&quot;,
                            &quot;slug&quot;: &quot;fashion&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-shirt&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 66,
                            &quot;rgt&quot;: 75,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;62&quot;: {
                            &quot;id&quot;: 62,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Beauty &amp; Well being&quot;,
                            &quot;slug&quot;: &quot;beauty-well-being&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-spa&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 76,
                            &quot;rgt&quot;: 88,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;73&quot;: {
                            &quot;id&quot;: 73,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Jobs&quot;,
                            &quot;slug&quot;: &quot;jobs&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-briefcase&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 89,
                            &quot;rgt&quot;: 114,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;job-offer&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;97&quot;: {
                            &quot;id&quot;: 97,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Services&quot;,
                            &quot;slug&quot;: &quot;services&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-clipboard-list&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 115,
                            &quot;rgt&quot;: 133,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;114&quot;: {
                            &quot;id&quot;: 114,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Learning&quot;,
                            &quot;slug&quot;: &quot;learning&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-graduation-cap&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 134,
                            &quot;rgt&quot;: 143,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        },
                        &quot;122&quot;: {
                            &quot;id&quot;: 122,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Local Events&quot;,
                            &quot;slug&quot;: &quot;local-events&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-regular fa-calendar-days&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 144,
                            &quot;rgt&quot;: 158,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;
                        }
                    },
                    &quot;countPostsPerCat&quot;: []
                },
                &quot;options&quot;: {
                    &quot;type_of_display&quot;: &quot;c_picture_icon&quot;,
                    &quot;max_items&quot;: &quot;12&quot;,
                    &quot;show_icon&quot;: &quot;0&quot;,
                    &quot;count_categories_posts&quot;: &quot;0&quot;,
                    &quot;max_sub_cats&quot;: &quot;3&quot;,
                    &quot;cache_expiration&quot;: &quot;3600&quot;,
                    &quot;active&quot;: &quot;1&quot;,
                    &quot;cat_display_type&quot;: &quot;c_bigIcon_list&quot;
                },
                &quot;lft&quot;: 2
            },
            &quot;premium_listings&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;key&quot;: &quot;premium_listings&quot;,
                &quot;data&quot;: {
                    &quot;premium&quot;: null
                },
                &quot;options&quot;: {
                    &quot;max_items&quot;: &quot;20&quot;,
                    &quot;order_by&quot;: &quot;date&quot;,
                    &quot;autoplay&quot;: &quot;1&quot;,
                    &quot;autoplay_timeout&quot;: null,
                    &quot;cache_expiration&quot;: &quot;3600&quot;,
                    &quot;active&quot;: &quot;1&quot;,
                    &quot;items_in_carousel&quot;: &quot;1&quot;
                },
                &quot;lft&quot;: 4
            },
            &quot;locations&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;key&quot;: &quot;locations&quot;,
                &quot;data&quot;: {
                    &quot;cities&quot;: [
                        {
                            &quot;id&quot;: 48225,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;New York City&quot;,
                            &quot;longitude&quot;: -74.01,
                            &quot;latitude&quot;: 40.71,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPL&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: null,
                            &quot;population&quot;: 8804190,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;new-york-city&quot;
                        },
                        {
                            &quot;id&quot;: 49443,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Los Angeles&quot;,
                            &quot;longitude&quot;: -118.24,
                            &quot;latitude&quot;: 34.05,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.CA.037&quot;,
                            &quot;population&quot;: 3971883,
                            &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-12-12T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-12-12T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;los-angeles&quot;
                        },
                        {
                            &quot;id&quot;: 46654,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Chicago&quot;,
                            &quot;longitude&quot;: -87.65,
                            &quot;latitude&quot;: 41.85,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.IL&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.IL.031&quot;,
                            &quot;population&quot;: 2720546,
                            &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-10-07T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-10-07T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;chicago&quot;
                        },
                        {
                            &quot;id&quot;: 47977,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Brooklyn&quot;,
                            &quot;longitude&quot;: -73.95,
                            &quot;latitude&quot;: 40.65,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.NY.047&quot;,
                            &quot;population&quot;: 2300664,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2015-01-18T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2015-01-18T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;brooklyn&quot;
                        },
                        {
                            &quot;id&quot;: 46017,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Houston&quot;,
                            &quot;longitude&quot;: -95.36,
                            &quot;latitude&quot;: 29.76,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.TX.201&quot;,
                            &quot;population&quot;: 2296224,
                            &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-07-25T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-07-25T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;houston&quot;
                        },
                        {
                            &quot;id&quot;: 48286,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Queens&quot;,
                            &quot;longitude&quot;: -73.84,
                            &quot;latitude&quot;: 40.68,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.NY.081&quot;,
                            &quot;population&quot;: 2272771,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-07-30T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-07-30T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;queens&quot;
                        },
                        {
                            &quot;id&quot;: 49093,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Phoenix&quot;,
                            &quot;longitude&quot;: -112.07,
                            &quot;latitude&quot;: 33.45,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.AZ&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.AZ.013&quot;,
                            &quot;population&quot;: 1608139,
                            &quot;time_zone&quot;: &quot;America/Phoenix&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;phoenix&quot;
                        },
                        {
                            &quot;id&quot;: 45632,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Philadelphia&quot;,
                            &quot;longitude&quot;: -75.16,
                            &quot;latitude&quot;: 39.95,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.PA&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.PA.101&quot;,
                            &quot;population&quot;: 1603797,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;philadelphia&quot;
                        },
                        {
                            &quot;id&quot;: 48176,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Manhattan&quot;,
                            &quot;longitude&quot;: -73.97,
                            &quot;latitude&quot;: 40.78,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.NY.061&quot;,
                            &quot;population&quot;: 1487536,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-08-20T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-08-20T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;manhattan&quot;
                        },
                        {
                            &quot;id&quot;: 46150,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;San Antonio&quot;,
                            &quot;longitude&quot;: -98.49,
                            &quot;latitude&quot;: 29.42,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.TX.029&quot;,
                            &quot;population&quot;: 1469845,
                            &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-09-19T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-09-19T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;san-antonio&quot;
                        },
                        {
                            &quot;id&quot;: 49614,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;San Diego&quot;,
                            &quot;longitude&quot;: -117.16,
                            &quot;latitude&quot;: 32.72,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.CA.073&quot;,
                            &quot;population&quot;: 1394928,
                            &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-09-05T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-09-05T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;san-diego&quot;
                        },
                        {
                            &quot;id&quot;: 47975,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;The Bronx&quot;,
                            &quot;longitude&quot;: -73.87,
                            &quot;latitude&quot;: 40.85,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.NY.005&quot;,
                            &quot;population&quot;: 1385108,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-08-08T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-08-08T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;the-bronx&quot;
                        },
                        {
                            &quot;id&quot;: 45946,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Dallas&quot;,
                            &quot;longitude&quot;: -96.81,
                            &quot;latitude&quot;: 32.78,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.TX.113&quot;,
                            &quot;population&quot;: 1300092,
                            &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-07-25T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-07-25T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;dallas&quot;
                        },
                        {
                            &quot;id&quot;: 49621,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;San Jose&quot;,
                            &quot;longitude&quot;: -121.89,
                            &quot;latitude&quot;: 37.34,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.CA.085&quot;,
                            &quot;population&quot;: 1026908,
                            &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-09-05T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-09-05T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;san-jose&quot;
                        },
                        {
                            &quot;id&quot;: 0,
                            &quot;name&quot;: &quot;More cities &amp;raquo;&quot;,
                            &quot;subadmin1_code&quot;: 0
                        }
                    ],
                    &quot;items_cols&quot;: 3
                },
                &quot;options&quot;: {
                    &quot;show_cities&quot;: &quot;1&quot;,
                    &quot;show_post_btn&quot;: &quot;1&quot;,
                    &quot;background_color&quot;: null,
                    &quot;border_width&quot;: null,
                    &quot;border_color&quot;: null,
                    &quot;text_color&quot;: null,
                    &quot;link_color&quot;: null,
                    &quot;link_color_hover&quot;: null,
                    &quot;max_items&quot;: 14,
                    &quot;items_cols&quot;: &quot;3&quot;,
                    &quot;count_cities_posts&quot;: &quot;0&quot;,
                    &quot;cache_expiration&quot;: &quot;3600&quot;,
                    &quot;enable_map&quot;: &quot;1&quot;,
                    &quot;map_background_color&quot;: null,
                    &quot;map_border&quot;: null,
                    &quot;map_hover_border&quot;: null,
                    &quot;map_border_width&quot;: null,
                    &quot;map_color&quot;: null,
                    &quot;map_hover&quot;: null,
                    &quot;map_width&quot;: &quot;300&quot;,
                    &quot;map_height&quot;: &quot;300&quot;,
                    &quot;active&quot;: &quot;1&quot;,
                    &quot;show_listing_btn&quot;: &quot;1&quot;
                },
                &quot;lft&quot;: 6
            },
            &quot;latest_listings&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;key&quot;: &quot;latest_listings&quot;,
                &quot;data&quot;: {
                    &quot;latest&quot;: {
                        &quot;title&quot;: &quot;&lt;span style=\&quot;font-weight: bold;\&quot;&gt;Latest&lt;/span&gt; Listings&quot;,
                        &quot;link&quot;: &quot;https://demo.laraclassifier.local/search&quot;,
                        &quot;posts&quot;: [
                            {
                                &quot;id&quot;: 9971,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 4,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Highlander 2022 4x4&quot;,
                                &quot;excerpt&quot;: &quot;Avez-vous quelque chose &agrave; vendre, &agrave; louer, un service &agrave; offrir ou une offre d&#039;emploi? Publiez gratui...&quot;,
                                &quot;description&quot;: &quot;Avez-vous quelque chose &agrave; vendre, &agrave; louer, un service &agrave; offrir ou une offre d&#039;emploi? Publiez gratuitement vos annonces ou &eacute;v&eacute;nements sur LaraClassifier, c&#039;est 100% gratuit, fiable, pens&eacute; business local et tr&egrave;s facile &agrave; utiliser!&quot;,
                                &quot;tags&quot;: [
                                    &quot;voiture&quot;,
                                    &quot;vehicule&quot;,
                                    &quot;car&quot;,
                                    &quot;motor&quot;
                                ],
                                &quot;price&quot;: &quot;9000000.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 43751,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;&quot;,
                                &quot;phone_national&quot;: &quot;&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-05-17T08:23:55.725446Z&quot;,
                                &quot;reference&quot;: &quot;LYqaQk6ldnj&quot;,
                                &quot;slug&quot;: &quot;highlander-2022-4x4&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/highlander-2022-4x4/LYqaQk6ldnj&quot;,
                                &quot;phone_intl&quot;: &quot;&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-169751-167491006628503-100001028145118-381299-2017441-o-2-600xjpg-17061746180992.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$9,000,000&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;count_pictures&quot;: 4,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 15458,
                                    &quot;post_id&quot;: 9971,
                                    &quot;file_path&quot;: &quot;files/us/9971/01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/120x90-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/320x240-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 15458,
                                        &quot;post_id&quot;: 9971,
                                        &quot;file_path&quot;: &quot;files/us/9971/01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/120x90-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/320x240-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 15459,
                                        &quot;post_id&quot;: 9971,
                                        &quot;file_path&quot;: &quot;files/us/9971/01-techpoint-new-office-13jpg-3251746540991jpg-55811746587268.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-01-techpoint-new-office-13jpg-3251746540991jpg-55811746587268.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/120x90-01-techpoint-new-office-13jpg-3251746540991jpg-55811746587268.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/320x240-01-techpoint-new-office-13jpg-3251746540991jpg-55811746587268.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-01-techpoint-new-office-13jpg-3251746540991jpg-55811746587268.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 15460,
                                        &quot;post_id&quot;: 9971,
                                        &quot;file_path&quot;: &quot;files/us/9971/800px-flag-of-benin-1975-1990-svgpng-41011746540992png-85861746587269.png&quot;,
                                        &quot;mime_type&quot;: &quot;image/png&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-800px-flag-of-benin-1975-1990-svgpng-41011746540992png-85861746587269.png&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/120x90-800px-flag-of-benin-1975-1990-svgpng-41011746540992png-85861746587269.png&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/320x240-800px-flag-of-benin-1975-1990-svgpng-41011746540992png-85861746587269.png&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-800px-flag-of-benin-1975-1990-svgpng-41011746540992png-85861746587269.png&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 15461,
                                        &quot;post_id&quot;: 9971,
                                        &quot;file_path&quot;: &quot;files/us/9971/apple-mandelapng-75021746541128png-85501746587270.png&quot;,
                                        &quot;mime_type&quot;: &quot;image/png&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-apple-mandelapng-75021746541128png-85501746587270.png&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/120x90-apple-mandelapng-75021746541128png-85501746587270.png&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/320x240-apple-mandelapng-75021746541128png-85501746587270.png&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-apple-mandelapng-75021746541128png-85501746587270.png&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;babacool2&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-03-01T23:06:22.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-03-01 23:06:22&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-03-05 22:43:08&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 year ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-169751-167491006628503-100001028145118-381299-2017441-o-2-600xjpg-17061746180992.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 4,
                                    &quot;parent_id&quot;: 1,
                                    &quot;name&quot;: &quot;Heavy Equipment&quot;,
                                    &quot;slug&quot;: &quot;heavy-equipment&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 4,
                                    &quot;rgt&quot;: 5,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Automobiles&quot;,
                                        &quot;slug&quot;: &quot;automobiles&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 1,
                                        &quot;rgt&quot;: 10,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 43751,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Little Rock&quot;,
                                    &quot;latitude&quot;: 34.75,
                                    &quot;longitude&quot;: -92.29,
                                    &quot;subadmin1_code&quot;: &quot;US.AR&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.AR.119&quot;,
                                    &quot;population&quot;: 197992,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 9970,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 2,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Publier une annonce&quot;,
                                &quot;excerpt&quot;: &quot;Avez-vous quelque chose &agrave; vendre, &agrave; louer, un service &agrave; offrir ou une offre d&#039;emploi? Publiez gratui...&quot;,
                                &quot;description&quot;: &quot;Avez-vous quelque chose &agrave; vendre, &agrave; louer, un service &agrave; offrir ou une offre d&#039;emploi? Publiez gratuitement vos annonces ou &eacute;v&eacute;nements sur LaraClassifier, c&#039;est 100% gratuit, fiable, pens&eacute; business local et tr&egrave;s facile &agrave; utiliser!&quot;,
                                &quot;tags&quot;: [
                                    &quot;lola&quot;,
                                    &quot;papa&quot;,
                                    &quot;maman&quot;
                                ],
                                &quot;price&quot;: &quot;200000.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 45045,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+15537797114&quot;,
                                &quot;phone_national&quot;: &quot;(553) 779-7114&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-04-20T18:55:05.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-04-20T18:55:05.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-04-20T18:55:05.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-04-20T18:55:05.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-05-17T08:23:55.806298Z&quot;,
                                &quot;reference&quot;: &quot;mWZdPjzwaKg&quot;,
                                &quot;slug&quot;: &quot;publier-une-annonce&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/publier-une-annonce/mWZdPjzwaKg&quot;,
                                &quot;phone_intl&quot;: &quot;(553) 779-7114&quot;,
                                &quot;created_at_formatted&quot;: &quot;3 weeks ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-169751-167491006628503-100001028145118-381299-2017441-o-2-600xjpg-17061746180992.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$200,000&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;count_pictures&quot;: 3,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 15456,
                                    &quot;post_id&quot;: 9970,
                                    &quot;file_path&quot;: &quot;files/us/9970/6of9jpeg-6281745273583.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-6of9jpeg-6281745273583.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/120x90-6of9jpeg-6281745273583.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/320x240-6of9jpeg-6281745273583.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-6of9jpeg-6281745273583.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 15456,
                                        &quot;post_id&quot;: 9970,
                                        &quot;file_path&quot;: &quot;files/us/9970/6of9jpeg-6281745273583.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-6of9jpeg-6281745273583.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/120x90-6of9jpeg-6281745273583.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/320x240-6of9jpeg-6281745273583.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-6of9jpeg-6281745273583.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 15457,
                                        &quot;post_id&quot;: 9970,
                                        &quot;file_path&quot;: &quot;files/us/9970/600x-drapeau-beninjpg-61961745273583.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-600x-drapeau-beninjpg-61961745273583.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/120x90-600x-drapeau-beninjpg-61961745273583.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/320x240-600x-drapeau-beninjpg-61961745273583.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-600x-drapeau-beninjpg-61961745273583.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 15435,
                                        &quot;post_id&quot;: 9970,
                                        &quot;file_path&quot;: &quot;files/us/9970/800px-flag-of-benin-1975-1990svgpng-45051745260406.png&quot;,
                                        &quot;mime_type&quot;: &quot;image/png&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-800px-flag-of-benin-1975-1990svgpng-45051745260406.png&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/120x90-800px-flag-of-benin-1975-1990svgpng-45051745260406.png&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/320x240-800px-flag-of-benin-1975-1990svgpng-45051745260406.png&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-800px-flag-of-benin-1975-1990svgpng-45051745260406.png&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;babacool2&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-03-01T23:06:22.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-03-01 23:06:22&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-03-05 22:43:08&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 year ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-169751-167491006628503-100001028145118-381299-2017441-o-2-600xjpg-17061746180992.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;parent_id&quot;: 1,
                                    &quot;name&quot;: &quot;Cars&quot;,
                                    &quot;slug&quot;: &quot;cars&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 2,
                                    &quot;rgt&quot;: 3,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Automobiles&quot;,
                                        &quot;slug&quot;: &quot;automobiles&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 1,
                                        &quot;rgt&quot;: 10,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 45045,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Florissant&quot;,
                                    &quot;latitude&quot;: 38.79,
                                    &quot;longitude&quot;: -90.32,
                                    &quot;subadmin1_code&quot;: &quot;US.MO&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.MO.189&quot;,
                                    &quot;population&quot;: 52268,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 68,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 3,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 60,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;Handbags silver&quot;,
                                &quot;excerpt&quot;: &quot;Vel ea delectus ut labore. Incidunt aut autem officiis. Accusamus expedita asperiores nostrum eius s...&quot;,
                                &quot;description&quot;: &quot;Vel ea delectus ut labore. Incidunt aut autem officiis. Accusamus expedita asperiores nostrum eius sed sit deleniti.&quot;,
                                &quot;tags&quot;: [
                                    &quot;voluptates&quot;,
                                    &quot;tempore&quot;,
                                    &quot;quam&quot;
                                ],
                                &quot;price&quot;: &quot;20.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;User Demo&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 48958,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;user@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+11530188788&quot;,
                                &quot;phone_national&quot;: &quot;1530188788&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-03-29T14:35:49.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-03-29T14:35:49.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-03-29T14:35:49.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-03-29T13:59:59.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-05-17T08:23:55.894765Z&quot;,
                                &quot;reference&quot;: &quot;QJ0dNk6eLOv&quot;,
                                &quot;slug&quot;: &quot;handbags-silver&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/handbags-silver/QJ0dNk6eLOv&quot;,
                                &quot;phone_intl&quot;: &quot;1530188788&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/3/thumbnails/800x800-294656d3a1838c92a0c8d425dfac5a30.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$20&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;count_pictures&quot;: 2,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 197,
                                    &quot;post_id&quot;: 68,
                                    &quot;file_path&quot;: &quot;files/us/68/8b643bdec544b4088959784015780c5a.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/816x460-8b643bdec544b4088959784015780c5a.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/120x90-8b643bdec544b4088959784015780c5a.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/320x240-8b643bdec544b4088959784015780c5a.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/816x460-8b643bdec544b4088959784015780c5a.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 197,
                                        &quot;post_id&quot;: 68,
                                        &quot;file_path&quot;: &quot;files/us/68/8b643bdec544b4088959784015780c5a.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/816x460-8b643bdec544b4088959784015780c5a.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/120x90-8b643bdec544b4088959784015780c5a.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/320x240-8b643bdec544b4088959784015780c5a.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/816x460-8b643bdec544b4088959784015780c5a.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 196,
                                        &quot;post_id&quot;: 68,
                                        &quot;file_path&quot;: &quot;files/us/68/2d39d48e80f7b12d2a82d62461def136.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/816x460-2d39d48e80f7b12d2a82d62461def136.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/120x90-2d39d48e80f7b12d2a82d62461def136.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/320x240-2d39d48e80f7b12d2a82d62461def136.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/68/thumbnails/816x460-2d39d48e80f7b12d2a82d62461def136.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 3,
                                    &quot;name&quot;: &quot;User Demo&quot;,
                                    &quot;username&quot;: null,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-03-21T03:29:22.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-03-21 03:29:22&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-03-21 03:54:02&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 year ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/3/thumbnails/800x800-294656d3a1838c92a0c8d425dfac5a30.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 60,
                                    &quot;parent_id&quot;: 54,
                                    &quot;name&quot;: &quot;Watches&quot;,
                                    &quot;slug&quot;: &quot;watches&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 72,
                                    &quot;rgt&quot;: 73,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 54,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Fashion&quot;,
                                        &quot;slug&quot;: &quot;fashion&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-shirt&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 66,
                                        &quot;rgt&quot;: 75,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 48958,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Milton&quot;,
                                    &quot;latitude&quot;: 42.78,
                                    &quot;longitude&quot;: -88.94,
                                    &quot;subadmin1_code&quot;: &quot;US.WI&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.WI.105&quot;,
                                    &quot;population&quot;: 5593,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 55,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 3,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 16,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;MagSafe Charger red&quot;,
                                &quot;excerpt&quot;: &quot;Quasi sit porro doloremque voluptatem tenetur. Facere error labore tenetur voluptatum sapiente. Fuga...&quot;,
                                &quot;description&quot;: &quot;Quasi sit porro doloremque voluptatem tenetur. Facere error labore tenetur voluptatum sapiente. Fuga porro qui minus voluptas quia.&quot;,
                                &quot;tags&quot;: [
                                    &quot;quo&quot;,
                                    &quot;dolorem&quot;,
                                    &quot;occaecati&quot;
                                ],
                                &quot;price&quot;: &quot;2809.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;User Demo&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 50476,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;user@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+18357993680&quot;,
                                &quot;phone_national&quot;: &quot;(835) 799-3680&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-03-29T15:48:48.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-03-29T15:48:48.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-03-29T15:48:48.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-03-29T13:53:59.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-05-17T08:23:55.982086Z&quot;,
                                &quot;reference&quot;: &quot;7LDdwpRe1YK&quot;,
                                &quot;slug&quot;: &quot;magsafe-charger-red&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/magsafe-charger-red/7LDdwpRe1YK&quot;,
                                &quot;phone_intl&quot;: &quot;(835) 799-3680&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/3/thumbnails/800x800-294656d3a1838c92a0c8d425dfac5a30.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$2,809&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;count_pictures&quot;: 1,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 154,
                                    &quot;post_id&quot;: 55,
                                    &quot;file_path&quot;: &quot;files/us/55/884300773eee8af4001b9f6ebe73af11.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/55/thumbnails/816x460-884300773eee8af4001b9f6ebe73af11.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/55/thumbnails/120x90-884300773eee8af4001b9f6ebe73af11.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/55/thumbnails/320x240-884300773eee8af4001b9f6ebe73af11.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/55/thumbnails/816x460-884300773eee8af4001b9f6ebe73af11.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 154,
                                        &quot;post_id&quot;: 55,
                                        &quot;file_path&quot;: &quot;files/us/55/884300773eee8af4001b9f6ebe73af11.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/55/thumbnails/816x460-884300773eee8af4001b9f6ebe73af11.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/55/thumbnails/120x90-884300773eee8af4001b9f6ebe73af11.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/55/thumbnails/320x240-884300773eee8af4001b9f6ebe73af11.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/55/thumbnails/816x460-884300773eee8af4001b9f6ebe73af11.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 3,
                                    &quot;name&quot;: &quot;User Demo&quot;,
                                    &quot;username&quot;: null,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-03-21T03:29:22.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-03-21 03:29:22&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-03-21 03:54:02&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 year ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/3/thumbnails/800x800-294656d3a1838c92a0c8d425dfac5a30.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 16,
                                    &quot;parent_id&quot;: 14,
                                    &quot;name&quot;: &quot;Laptops &amp; Computers&quot;,
                                    &quot;slug&quot;: &quot;laptops-and-computers&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 20,
                                    &quot;rgt&quot;: 21,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 14,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Electronics&quot;,
                                        &quot;slug&quot;: &quot;electronics&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-laptop&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 18,
                                        &quot;rgt&quot;: 35,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 50476,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Gillette&quot;,
                                    &quot;latitude&quot;: 44.29,
                                    &quot;longitude&quot;: -105.5,
                                    &quot;subadmin1_code&quot;: &quot;US.WY&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.WY.005&quot;,
                                    &quot;population&quot;: 32649,
                                    &quot;time_zone&quot;: &quot;America/Denver&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 25,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 87,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;Urgent: Office Volunteer&quot;,
                                &quot;excerpt&quot;: &quot;Dicta est velit in aut libero. Eligendi tempore numquam recusandae fugit ut sunt earum. Debitis id t...&quot;,
                                &quot;description&quot;: &quot;Dicta est velit in aut libero. Eligendi tempore numquam recusandae fugit ut sunt earum. Debitis id temporibus ut et eum omnis ad. Natus ex et labore voluptatibus dignissimos sapiente non.&quot;,
                                &quot;tags&quot;: [
                                    &quot;modi&quot;,
                                    &quot;nihil&quot;,
                                    &quot;excepturi&quot;
                                ],
                                &quot;price&quot;: &quot;8.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 48772,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+12654672439&quot;,
                                &quot;phone_national&quot;: &quot;(265) 467-2439&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-03-29T13:42:42.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-03-29T13:42:42.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-03-29T13:42:42.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-03-29T12:25:27.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-05-17T08:23:56.072053Z&quot;,
                                &quot;reference&quot;: &quot;Gz3YaOpbxql&quot;,
                                &quot;slug&quot;: &quot;urgent-office-volunteer&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/urgent-office-volunteer/Gz3YaOpbxql&quot;,
                                &quot;phone_intl&quot;: &quot;(265) 467-2439&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-169751-167491006628503-100001028145118-381299-2017441-o-2-600xjpg-17061746180992.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                                &quot;price_label&quot;: &quot;Salary:&quot;,
                                &quot;price_formatted&quot;: &quot;$8&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;count_pictures&quot;: 5,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 68,
                                    &quot;post_id&quot;: 25,
                                    &quot;file_path&quot;: &quot;files/us/25/43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/120x90-43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/320x240-43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 68,
                                        &quot;post_id&quot;: 25,
                                        &quot;file_path&quot;: &quot;files/us/25/43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/120x90-43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/320x240-43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-43f6be7f7c4b59de1c0fae5fa4e8b628.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 67,
                                        &quot;post_id&quot;: 25,
                                        &quot;file_path&quot;: &quot;files/us/25/47c9c1d0e05c88be8086e9e7d1dc796a.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-47c9c1d0e05c88be8086e9e7d1dc796a.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/120x90-47c9c1d0e05c88be8086e9e7d1dc796a.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/320x240-47c9c1d0e05c88be8086e9e7d1dc796a.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-47c9c1d0e05c88be8086e9e7d1dc796a.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 65,
                                        &quot;post_id&quot;: 25,
                                        &quot;file_path&quot;: &quot;files/us/25/104770a01a17269b8d96690f54ff61e0.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-104770a01a17269b8d96690f54ff61e0.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/120x90-104770a01a17269b8d96690f54ff61e0.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/320x240-104770a01a17269b8d96690f54ff61e0.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-104770a01a17269b8d96690f54ff61e0.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 66,
                                        &quot;post_id&quot;: 25,
                                        &quot;file_path&quot;: &quot;files/us/25/67d4441d5951457b548ac79efa9ddef2.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-67d4441d5951457b548ac79efa9ddef2.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/120x90-67d4441d5951457b548ac79efa9ddef2.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/320x240-67d4441d5951457b548ac79efa9ddef2.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-67d4441d5951457b548ac79efa9ddef2.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 69,
                                        &quot;post_id&quot;: 25,
                                        &quot;file_path&quot;: &quot;files/us/25/66ab4de122aaa8c4ed4609149a0d51df.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 5,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-66ab4de122aaa8c4ed4609149a0d51df.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/120x90-66ab4de122aaa8c4ed4609149a0d51df.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/320x240-66ab4de122aaa8c4ed4609149a0d51df.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/25/thumbnails/816x460-66ab4de122aaa8c4ed4609149a0d51df.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;babacool2&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-03-01T23:06:22.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-03-01 23:06:22&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-03-05 22:43:08&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 year ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-169751-167491006628503-100001028145118-381299-2017441-o-2-600xjpg-17061746180992.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 87,
                                    &quot;parent_id&quot;: 73,
                                    &quot;name&quot;: &quot;Industry, Production &amp; engineering&quot;,
                                    &quot;slug&quot;: &quot;industry-production-engineering&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 103,
                                    &quot;rgt&quot;: 104,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;job-offer&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 73,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Jobs&quot;,
                                        &quot;slug&quot;: &quot;jobs&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-briefcase&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 89,
                                        &quot;rgt&quot;: 114,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;job-offer&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 48772,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Pottsville&quot;,
                                    &quot;latitude&quot;: 40.69,
                                    &quot;longitude&quot;: -76.2,
                                    &quot;subadmin1_code&quot;: &quot;US.PA&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.PA.107&quot;,
                                    &quot;population&quot;: 13802,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 62,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 3,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 11,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;Vivo Y73s gray&quot;,
                                &quot;excerpt&quot;: &quot;Dolorem quasi rem exercitationem aut et non nam. Molestiae ratione eius deleniti neque. Officia accu...&quot;,
                                &quot;description&quot;: &quot;Dolorem quasi rem exercitationem aut et non nam. Molestiae ratione eius deleniti neque. Officia accusantium dolor excepturi sed molestiae. Ab sit laboriosam vitae rerum. Quod sit et repellendus. Vel deserunt sed quam mollitia repudiandae et. Dolorum libero possimus qui consequuntur est rerum nihil. Non laboriosam beatae quos hic similique.&quot;,
                                &quot;tags&quot;: [
                                    &quot;illum&quot;,
                                    &quot;aut&quot;,
                                    &quot;omnis&quot;
                                ],
                                &quot;price&quot;: &quot;44.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;User Demo&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 49143,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;user@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+13424059507&quot;,
                                &quot;phone_national&quot;: &quot;(342) 405-9507&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-03-29T13:17:13.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-03-29T13:17:13.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-03-29T13:17:13.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-03-29T10:26:30.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-05-17T08:23:56.165654Z&quot;,
                                &quot;reference&quot;: &quot;K4oeERva0By&quot;,
                                &quot;slug&quot;: &quot;vivo-y73s-gray&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/vivo-y73s-gray/K4oeERva0By&quot;,
                                &quot;phone_intl&quot;: &quot;(342) 405-9507&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/3/thumbnails/800x800-294656d3a1838c92a0c8d425dfac5a30.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$44&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;count_pictures&quot;: 4,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 176,
                                    &quot;post_id&quot;: 62,
                                    &quot;file_path&quot;: &quot;files/us/62/442857fe2e274e970343e87246bfeb4f.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 2,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/62/thumbnails/816x460-442857fe2e274e970343e87246bfeb4f.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/62/thumbnails/120x90-442857fe2e274e970343e87246bfeb4f.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/62/thumbnails/320x240-442857fe2e274e970343e87246bfeb4f.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/62/thumbnails/816x460-442857fe2e274e970343e87246bfeb4f.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 176,
                                        &quot;post_id&quot;: 62,
                                        &quot;file_path&quot;: &quot;files/us/62/442857fe2e274e970343e87246bfeb4f.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/62/thumbnails/816x460-442857fe2e274e970343e87246bfeb4f.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/62/thumbnails/120x90-442857fe2e274e970343e87246bfeb4f.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/62/thumbnails/320x240-442857fe2e274e970343e87246bfeb4f.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/62/thumbnails/816x460-442857fe2e274e970343e87246bfeb4f.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 177,
                                        &quot;post_id&quot;: 62,
                                        &quot;file_path&quot;: &quot;files/us/62/d1620ebd6edbd97c896ff4642ae90b96.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 174,
                                        &quot;post_id&quot;: 62,
                                        &quot;file_path&quot;: &quot;files/us/62/f84116c56ef72356c462538cb5619084.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 175,
                                        &quot;post_id&quot;: 62,
                                        &quot;file_path&quot;: &quot;files/us/62/7bf8b7ed34d107471150fe5b49355df1.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 3,
                                    &quot;name&quot;: &quot;User Demo&quot;,
                                    &quot;username&quot;: null,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-03-21T03:29:22.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-03-21 03:29:22&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-03-21 03:54:02&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 year ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/3/thumbnails/800x800-294656d3a1838c92a0c8d425dfac5a30.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 11,
                                    &quot;parent_id&quot;: 9,
                                    &quot;name&quot;: &quot;Accessories for Mobile Phones &amp; Tablets&quot;,
                                    &quot;slug&quot;: &quot;mobile-phones-tablets-accessories&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 13,
                                    &quot;rgt&quot;: 14,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 9,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Phones &amp; Tablets&quot;,
                                        &quot;slug&quot;: &quot;phones-and-tablets&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-mobile-screen-button&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 11,
                                        &quot;rgt&quot;: 17,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 49143,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;American Canyon&quot;,
                                    &quot;latitude&quot;: 38.17,
                                    &quot;longitude&quot;: -122.26,
                                    &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.CA.055&quot;,
                                    &quot;population&quot;: 20554,
                                    &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 444,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 2877,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 63,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;Consectetur earum expedita repudiandae deleniti minima&quot;,
                                &quot;excerpt&quot;: &quot;Incidunt vel dolorem eligendi officiis corrupti eaque. Aspernatur consectetur quia in dolorum dicta...&quot;,
                                &quot;description&quot;: &quot;Incidunt vel dolorem eligendi officiis corrupti eaque. Aspernatur consectetur quia in dolorum dicta aliquid expedita. Aut cumque laborum repudiandae nulla neque ipsa. Dignissimos numquam assumenda natus sequi quia necessitatibus qui. Doloremque et officiis voluptates aut qui porro. Animi id quas aut labore illum. Dolorem dolor qui temporibus reprehenderit tempora et. Quisquam perspiciatis consequatur eum et.&quot;,
                                &quot;tags&quot;: [
                                    &quot;rerum&quot;,
                                    &quot;sequi&quot;,
                                    &quot;voluptate&quot;
                                ],
                                &quot;price&quot;: &quot;31413.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Jonatan Robel&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 45114,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;dhodkiewicz@hotmail.com&quot;,
                                &quot;phone&quot;: &quot;+18909621317&quot;,
                                &quot;phone_national&quot;: &quot;(890) 962-1317&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-03-29T11:20:08.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-03-29T11:20:08.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-03-29T11:20:08.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-03-29T06:02:55.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-05-17T08:23:56.256069Z&quot;,
                                &quot;reference&quot;: &quot;Wjneg7ZewZ1&quot;,
                                &quot;slug&quot;: &quot;consectetur-earum-expedita-repudiandae-deleniti-minima&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/consectetur-earum-expedita-repudiandae-deleniti-minima/Wjneg7ZewZ1&quot;,
                                &quot;phone_intl&quot;: &quot;(890) 962-1317&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$31,413&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;count_pictures&quot;: 4,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 772,
                                    &quot;post_id&quot;: 444,
                                    &quot;file_path&quot;: &quot;files/us/444/2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 3,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/120x90-2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/320x240-2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 772,
                                        &quot;post_id&quot;: 444,
                                        &quot;file_path&quot;: &quot;files/us/444/2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/120x90-2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/320x240-2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-2f2d9f1c6e0e81473bb57b32a5fdb6f7.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 771,
                                        &quot;post_id&quot;: 444,
                                        &quot;file_path&quot;: &quot;files/us/444/4d22c19b854c3c43f4e1f3b29a1f460f.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-4d22c19b854c3c43f4e1f3b29a1f460f.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/120x90-4d22c19b854c3c43f4e1f3b29a1f460f.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/320x240-4d22c19b854c3c43f4e1f3b29a1f460f.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-4d22c19b854c3c43f4e1f3b29a1f460f.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 770,
                                        &quot;post_id&quot;: 444,
                                        &quot;file_path&quot;: &quot;files/us/444/e66de8d197af3cef78fef4c72c235442.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-e66de8d197af3cef78fef4c72c235442.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/120x90-e66de8d197af3cef78fef4c72c235442.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/320x240-e66de8d197af3cef78fef4c72c235442.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-e66de8d197af3cef78fef4c72c235442.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 769,
                                        &quot;post_id&quot;: 444,
                                        &quot;file_path&quot;: &quot;files/us/444/8f852811d4f7d87fa12e2b0a1b7ceba6.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-8f852811d4f7d87fa12e2b0a1b7ceba6.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/120x90-8f852811d4f7d87fa12e2b0a1b7ceba6.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/320x240-8f852811d4f7d87fa12e2b0a1b7ceba6.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/444/thumbnails/816x460-8f852811d4f7d87fa12e2b0a1b7ceba6.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 2877,
                                    &quot;name&quot;: &quot;Jonatan Robel&quot;,
                                    &quot;username&quot;: &quot;aureliagleason&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2024-12-20T19:50:46.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2024-12-20 19:50:46&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;7 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/pt.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 63,
                                    &quot;parent_id&quot;: 62,
                                    &quot;name&quot;: &quot;Bath &amp; Body&quot;,
                                    &quot;slug&quot;: &quot;bath-and-body&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 77,
                                    &quot;rgt&quot;: 78,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 62,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Beauty &amp; Well being&quot;,
                                        &quot;slug&quot;: &quot;beauty-well-being&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-spa&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 76,
                                        &quot;rgt&quot;: 88,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 45114,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Sedalia&quot;,
                                    &quot;latitude&quot;: 38.7,
                                    &quot;longitude&quot;: -93.23,
                                    &quot;subadmin1_code&quot;: &quot;US.MO&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.MO.159&quot;,
                                    &quot;population&quot;: 21516,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 5734,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 2410,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 5,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;2016 Honda Accord&quot;,
                                &quot;excerpt&quot;: &quot;Dolorem unde sint odit quos. Ipsum et illo ducimus consectetur tempore nihil aut. Nostrum atque et m...&quot;,
                                &quot;description&quot;: &quot;Dolorem unde sint odit quos. Ipsum et illo ducimus consectetur tempore nihil aut. Nostrum atque et minima similique eaque. Placeat omnis cum cumque. Distinctio rem unde eos accusamus. Sed expedita minima voluptate. Vel in alias aliquam quo accusamus aut. Voluptatum deleniti consequatur nisi voluptatum deleniti nulla sint.&quot;,
                                &quot;tags&quot;: [
                                    &quot;quas&quot;,
                                    &quot;in&quot;,
                                    &quot;laboriosam&quot;
                                ],
                                &quot;price&quot;: &quot;7770.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Stanford Langosh&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47818,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;lexi.langosh@hotmail.com&quot;,
                                &quot;phone&quot;: &quot;+17957885753&quot;,
                                &quot;phone_national&quot;: &quot;(795) 788-5753&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-03-29T03:17:29.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-03-29T03:17:29.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-03-29T03:17:29.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-03-29T02:47:48.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-05-17T08:23:56.344538Z&quot;,
                                &quot;reference&quot;: &quot;EKQe1jm3aJY&quot;,
                                &quot;slug&quot;: &quot;2016-honda-accord&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/2016-honda-accord/EKQe1jm3aJY&quot;,
                                &quot;phone_intl&quot;: &quot;(795) 788-5753&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$7,770&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;count_pictures&quot;: 5,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 8866,
                                    &quot;post_id&quot;: 5734,
                                    &quot;file_path&quot;: &quot;files/us/5734/37ec322971be1196484baf26a0eaa228.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 2,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-37ec322971be1196484baf26a0eaa228.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/120x90-37ec322971be1196484baf26a0eaa228.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/320x240-37ec322971be1196484baf26a0eaa228.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-37ec322971be1196484baf26a0eaa228.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 8866,
                                        &quot;post_id&quot;: 5734,
                                        &quot;file_path&quot;: &quot;files/us/5734/37ec322971be1196484baf26a0eaa228.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-37ec322971be1196484baf26a0eaa228.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/120x90-37ec322971be1196484baf26a0eaa228.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/320x240-37ec322971be1196484baf26a0eaa228.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-37ec322971be1196484baf26a0eaa228.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 8865,
                                        &quot;post_id&quot;: 5734,
                                        &quot;file_path&quot;: &quot;files/us/5734/d3ef2513727a41a903c800587b43d178.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-d3ef2513727a41a903c800587b43d178.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/120x90-d3ef2513727a41a903c800587b43d178.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/320x240-d3ef2513727a41a903c800587b43d178.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-d3ef2513727a41a903c800587b43d178.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 8864,
                                        &quot;post_id&quot;: 5734,
                                        &quot;file_path&quot;: &quot;files/us/5734/7b47d2ebd4fe966ae8127ec8e04c1352.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-7b47d2ebd4fe966ae8127ec8e04c1352.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/120x90-7b47d2ebd4fe966ae8127ec8e04c1352.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/320x240-7b47d2ebd4fe966ae8127ec8e04c1352.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-7b47d2ebd4fe966ae8127ec8e04c1352.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 8863,
                                        &quot;post_id&quot;: 5734,
                                        &quot;file_path&quot;: &quot;files/us/5734/c752d40543c76181298c8f8e6a3ca17d.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-c752d40543c76181298c8f8e6a3ca17d.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/120x90-c752d40543c76181298c8f8e6a3ca17d.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/320x240-c752d40543c76181298c8f8e6a3ca17d.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-c752d40543c76181298c8f8e6a3ca17d.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 8867,
                                        &quot;post_id&quot;: 5734,
                                        &quot;file_path&quot;: &quot;files/us/5734/a5e517fb915e46770e8792a45b4a1128.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-a5e517fb915e46770e8792a45b4a1128.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/120x90-a5e517fb915e46770e8792a45b4a1128.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/320x240-a5e517fb915e46770e8792a45b4a1128.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5734/thumbnails/816x460-a5e517fb915e46770e8792a45b4a1128.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 2410,
                                    &quot;name&quot;: &quot;Stanford Langosh&quot;,
                                    &quot;username&quot;: null,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-03-14T05:26:49.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-03-14 05:26:49&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;4 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/qa.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 5,
                                    &quot;parent_id&quot;: 1,
                                    &quot;name&quot;: &quot;Motorcycles &amp; Scooters&quot;,
                                    &quot;slug&quot;: &quot;motorcycles-and-scooters&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;fa-solid fa-folder&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 5,
                                    &quot;rgt&quot;: 6,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Automobiles&quot;,
                                        &quot;slug&quot;: &quot;automobiles&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 1,
                                        &quot;rgt&quot;: 10,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47818,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;New Brunswick&quot;,
                                    &quot;latitude&quot;: 40.49,
                                    &quot;longitude&quot;: -74.45,
                                    &quot;subadmin1_code&quot;: &quot;US.NJ&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.NJ.023&quot;,
                                    &quot;population&quot;: 57035,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            }
                        ],
                        &quot;totalPosts&quot;: 232
                    }
                },
                &quot;options&quot;: {
                    &quot;max_items&quot;: &quot;8&quot;,
                    &quot;show_view_more_btn&quot;: &quot;1&quot;
                },
                &quot;lft&quot;: 8
            },
            &quot;stats&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;key&quot;: &quot;stats&quot;,
                &quot;data&quot;: {
                    &quot;count&quot;: {
                        &quot;posts&quot;: 232,
                        &quot;users&quot;: 3309,
                        &quot;locations&quot;: 7200
                    }
                },
                &quot;options&quot;: {
                    &quot;icon_count_listings&quot;: &quot;bi bi-megaphone&quot;,
                    &quot;icon_count_users&quot;: &quot;bi bi-people&quot;,
                    &quot;icon_count_locations&quot;: &quot;bi bi-geo-alt&quot;,
                    &quot;counter_up_delay&quot;: 10,
                    &quot;counter_up_time&quot;: 2000
                },
                &quot;lft&quot;: 10
            }
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-sections" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-sections"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-sections"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-sections" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-sections">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-sections" data-method="GET"
      data-path="api/sections"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-sections', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-sections"
                    onclick="tryItOut('GETapi-sections');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-sections"
                    onclick="cancelTryOut('GETapi-sections');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-sections"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/sections</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-sections"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-sections"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-sections"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-sections"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-sections"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                    <h2 id="home-GETapi-sections--method-">Get section</h2>

<p>
</p>

<p>Get category by its unique slug or ID.</p>

<span id="example-requests-GETapi-sections--method-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/sections/1?parentCatSlug=automobiles" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/sections/1"
);

const params = {
    "parentCatSlug": "automobiles",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/sections/1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'parentCatSlug' =&gt; 'automobiles',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/sections/1'
params = {
  'parentCatSlug': 'automobiles',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-sections--method-">
            <blockquote>
            <p>Example response (404):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;Section not found&quot;,
    &quot;result&quot;: null,
    &quot;error&quot;: &quot;Section not found&quot;
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-sections--method-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-sections--method-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-sections--method-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-sections--method-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-sections--method-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-sections--method-" data-method="GET"
      data-path="api/sections/{method}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-sections--method-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-sections--method-"
                    onclick="tryItOut('GETapi-sections--method-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-sections--method-"
                    onclick="cancelTryOut('GETapi-sections--method-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-sections--method-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/sections/{method}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-sections--method-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-sections--method-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-sections--method-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-sections--method-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-sections--method-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>method</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="method"                data-endpoint="GETapi-sections--method-"
               value="1"
               data-component="url">
    <br>
<p>Example: <code>1</code></p>
            </div>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="key"                data-endpoint="GETapi-sections--method-"
               value="getCategories"
               data-component="url">
    <br>
<p>The key/method of the section. Example: <code>getCategories</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>parentCatSlug</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="parentCatSlug"                data-endpoint="GETapi-sections--method-"
               value="automobiles"
               data-component="query">
    <br>
<p>The slug of the parent category to retrieve used when category's slug provided instead of ID. Example: <code>automobiles</code></p>
            </div>
                </form>

                <h1 id="languages">Languages</h1>

    

                                <h2 id="languages-GETapi-languages">List languages</h2>

<p>
</p>



<span id="example-requests-GETapi-languages">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/languages" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/languages"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/languages';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/languages'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-languages">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;code&quot;: &quot;en&quot;,
                &quot;locale&quot;: &quot;en_US&quot;,
                &quot;name&quot;: &quot;English&quot;,
                &quot;native&quot;: &quot;English&quot;,
                &quot;flag&quot;: &quot;flag-icon-gb&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;MMM Do, YYYY&quot;,
                &quot;datetime_format&quot;: &quot;MMM Do, YYYY [at] HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 2,
                &quot;rgt&quot;: 3,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;en_US&quot;,
                &quot;tag&quot;: &quot;en&quot;,
                &quot;primary&quot;: &quot;en&quot;
            },
            {
                &quot;code&quot;: &quot;fr&quot;,
                &quot;locale&quot;: &quot;fr_FR&quot;,
                &quot;name&quot;: &quot;French&quot;,
                &quot;native&quot;: &quot;Fran&ccedil;ais&quot;,
                &quot;flag&quot;: &quot;flag-icon-fr&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;Do MMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;Do MMM YYYY [&agrave;] H[h]mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 4,
                &quot;rgt&quot;: 5,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;fr_FR&quot;,
                &quot;tag&quot;: &quot;fr&quot;,
                &quot;primary&quot;: &quot;fr&quot;
            },
            {
                &quot;code&quot;: &quot;es&quot;,
                &quot;locale&quot;: &quot;es_ES&quot;,
                &quot;name&quot;: &quot;Spanish&quot;,
                &quot;native&quot;: &quot;Espa&ntilde;ol&quot;,
                &quot;flag&quot;: &quot;flag-icon-es&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D [de] MMMM [de] YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D [de] MMMM [de] YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 6,
                &quot;rgt&quot;: 7,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;es_ES&quot;,
                &quot;tag&quot;: &quot;es&quot;,
                &quot;primary&quot;: &quot;es&quot;
            },
            {
                &quot;code&quot;: &quot;ar&quot;,
                &quot;locale&quot;: &quot;ar_SA&quot;,
                &quot;name&quot;: &quot;Arabic&quot;,
                &quot;native&quot;: &quot;العربية&quot;,
                &quot;flag&quot;: &quot;flag-icon-sa&quot;,
                &quot;script&quot;: &quot;Arab&quot;,
                &quot;direction&quot;: &quot;rtl&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;DD/MMMM/YYYY&quot;,
                &quot;datetime_format&quot;: &quot;DD/MMMM/YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 8,
                &quot;rgt&quot;: 9,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;ar_SA&quot;,
                &quot;tag&quot;: &quot;ar&quot;,
                &quot;primary&quot;: &quot;ar&quot;
            },
            {
                &quot;code&quot;: &quot;pt&quot;,
                &quot;locale&quot;: &quot;pt_PT&quot;,
                &quot;name&quot;: &quot;Portuguese&quot;,
                &quot;native&quot;: &quot;Portugu&ecirc;s&quot;,
                &quot;flag&quot;: &quot;flag-icon-pt&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D [de] MMMM [de] YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D [de] MMMM [de] YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 10,
                &quot;rgt&quot;: 11,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;pt_PT&quot;,
                &quot;tag&quot;: &quot;pt&quot;,
                &quot;primary&quot;: &quot;pt&quot;
            },
            {
                &quot;code&quot;: &quot;de&quot;,
                &quot;locale&quot;: &quot;de_DE&quot;,
                &quot;name&quot;: &quot;German&quot;,
                &quot;native&quot;: &quot;Deutsch&quot;,
                &quot;flag&quot;: &quot;flag-icon-de&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;dddd, D. MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;dddd, D. MMMM YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 12,
                &quot;rgt&quot;: 13,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;de_DE&quot;,
                &quot;tag&quot;: &quot;de&quot;,
                &quot;primary&quot;: &quot;de&quot;
            },
            {
                &quot;code&quot;: &quot;it&quot;,
                &quot;locale&quot;: &quot;it_IT&quot;,
                &quot;name&quot;: &quot;Italian&quot;,
                &quot;native&quot;: &quot;Italiano&quot;,
                &quot;flag&quot;: &quot;flag-icon-it&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 14,
                &quot;rgt&quot;: 15,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;it_IT&quot;,
                &quot;tag&quot;: &quot;it&quot;,
                &quot;primary&quot;: &quot;it&quot;
            },
            {
                &quot;code&quot;: &quot;tr&quot;,
                &quot;locale&quot;: &quot;tr_TR.UTF-8&quot;,
                &quot;name&quot;: &quot;Turkish&quot;,
                &quot;native&quot;: &quot;T&uuml;rk&ccedil;e&quot;,
                &quot;flag&quot;: &quot;flag-icon-tr&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;DD MMMM YYYY dddd&quot;,
                &quot;datetime_format&quot;: &quot;DD MMMM YYYY dddd HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 16,
                &quot;rgt&quot;: 17,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;tr_TR&quot;,
                &quot;tag&quot;: &quot;tr&quot;,
                &quot;primary&quot;: &quot;tr&quot;
            },
            {
                &quot;code&quot;: &quot;ru&quot;,
                &quot;locale&quot;: &quot;ru_RU&quot;,
                &quot;name&quot;: &quot;Russian&quot;,
                &quot;native&quot;: &quot;Русский&quot;,
                &quot;flag&quot;: &quot;flag-icon-ru&quot;,
                &quot;script&quot;: &quot;Cyrl&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 1,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY [ г.] H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 18,
                &quot;rgt&quot;: 19,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;ru_RU&quot;,
                &quot;tag&quot;: &quot;ru&quot;,
                &quot;primary&quot;: &quot;ru&quot;
            },
            {
                &quot;code&quot;: &quot;hi&quot;,
                &quot;locale&quot;: &quot;hi_IN&quot;,
                &quot;name&quot;: &quot;Hindi&quot;,
                &quot;native&quot;: &quot;हिन्दी&quot;,
                &quot;flag&quot;: &quot;flag-icon-in&quot;,
                &quot;script&quot;: &quot;Deva&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 20,
                &quot;rgt&quot;: 21,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;hi_IN&quot;,
                &quot;tag&quot;: &quot;hi&quot;,
                &quot;primary&quot;: &quot;hi&quot;
            },
            {
                &quot;code&quot;: &quot;bn&quot;,
                &quot;locale&quot;: &quot;bn_BD&quot;,
                &quot;name&quot;: &quot;Bengali&quot;,
                &quot;native&quot;: &quot;বাংলা&quot;,
                &quot;flag&quot;: &quot;flag-icon-bd&quot;,
                &quot;script&quot;: &quot;Beng&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H.mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 22,
                &quot;rgt&quot;: 23,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;bn_BD&quot;,
                &quot;tag&quot;: &quot;bn&quot;,
                &quot;primary&quot;: &quot;bn&quot;
            },
            {
                &quot;code&quot;: &quot;zh&quot;,
                &quot;locale&quot;: &quot;zh_CN&quot;,
                &quot;name&quot;: &quot;Simplified Chinese&quot;,
                &quot;native&quot;: &quot;简体中文&quot;,
                &quot;flag&quot;: &quot;flag-icon-cn&quot;,
                &quot;script&quot;: &quot;Hans&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 24,
                &quot;rgt&quot;: 25,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;zh_CN&quot;,
                &quot;tag&quot;: &quot;zh&quot;,
                &quot;primary&quot;: &quot;zh&quot;
            },
            {
                &quot;code&quot;: &quot;ja&quot;,
                &quot;locale&quot;: &quot;ja_JP&quot;,
                &quot;name&quot;: &quot;Japanese&quot;,
                &quot;native&quot;: &quot;日本語&quot;,
                &quot;flag&quot;: &quot;flag-icon-jp&quot;,
                &quot;script&quot;: &quot;Jpan&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 26,
                &quot;rgt&quot;: 27,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;ja_JP&quot;,
                &quot;tag&quot;: &quot;ja&quot;,
                &quot;primary&quot;: &quot;ja&quot;
            },
            {
                &quot;code&quot;: &quot;he&quot;,
                &quot;locale&quot;: &quot;he_IL&quot;,
                &quot;name&quot;: &quot;Hebrew&quot;,
                &quot;native&quot;: &quot;עִברִית&quot;,
                &quot;flag&quot;: &quot;flag-icon-il&quot;,
                &quot;script&quot;: &quot;Hebr&quot;,
                &quot;direction&quot;: &quot;rtl&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 28,
                &quot;rgt&quot;: 29,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;he_IL&quot;,
                &quot;tag&quot;: &quot;he&quot;,
                &quot;primary&quot;: &quot;he&quot;
            },
            {
                &quot;code&quot;: &quot;th&quot;,
                &quot;locale&quot;: &quot;th_TH&quot;,
                &quot;name&quot;: &quot;Thai&quot;,
                &quot;native&quot;: &quot;ไทย&quot;,
                &quot;flag&quot;: &quot;flag-icon-th&quot;,
                &quot;script&quot;: &quot;Thai&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 30,
                &quot;rgt&quot;: 31,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;th_TH&quot;,
                &quot;tag&quot;: &quot;th&quot;,
                &quot;primary&quot;: &quot;th&quot;
            },
            {
                &quot;code&quot;: &quot;ro&quot;,
                &quot;locale&quot;: &quot;ro_RO&quot;,
                &quot;name&quot;: &quot;Romanian&quot;,
                &quot;native&quot;: &quot;Rom&acirc;nă&quot;,
                &quot;flag&quot;: &quot;flag-icon-ro&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 32,
                &quot;rgt&quot;: 33,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;ro_RO&quot;,
                &quot;tag&quot;: &quot;ro&quot;,
                &quot;primary&quot;: &quot;ro&quot;
            },
            {
                &quot;code&quot;: &quot;ka&quot;,
                &quot;locale&quot;: &quot;ka_GE&quot;,
                &quot;name&quot;: &quot;Georgian&quot;,
                &quot;native&quot;: &quot;ქართული&quot;,
                &quot;flag&quot;: &quot;flag-icon-ge&quot;,
                &quot;script&quot;: &quot;Geor&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;YYYY [წლის] DD MM&quot;,
                &quot;datetime_format&quot;: &quot;YYYY [წლის] DD MMMM, dddd H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 34,
                &quot;rgt&quot;: 35,
                &quot;depth&quot;: 1,
                &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
                &quot;iso_locale&quot;: &quot;ka_GE&quot;,
                &quot;tag&quot;: &quot;ka&quot;,
                &quot;primary&quot;: &quot;ka&quot;
            }
        ]
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-languages" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-languages"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-languages"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-languages" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-languages">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-languages" data-method="GET"
      data-path="api/languages"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-languages', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-languages"
                    onclick="tryItOut('GETapi-languages');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-languages"
                    onclick="cancelTryOut('GETapi-languages');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-languages"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/languages</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-languages"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-languages"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-languages"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-languages"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-languages"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                    <h2 id="languages-GETapi-languages--code-">Get language</h2>

<p>
</p>



<span id="example-requests-GETapi-languages--code-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/languages/en" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/languages/en"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/languages/en';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/languages/en'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-languages--code-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;code&quot;: &quot;en&quot;,
        &quot;locale&quot;: &quot;en_US&quot;,
        &quot;name&quot;: &quot;English&quot;,
        &quot;native&quot;: &quot;English&quot;,
        &quot;flag&quot;: &quot;flag-icon-gb&quot;,
        &quot;script&quot;: &quot;Latn&quot;,
        &quot;direction&quot;: &quot;ltr&quot;,
        &quot;russian_pluralization&quot;: 0,
        &quot;date_format&quot;: &quot;MMM Do, YYYY&quot;,
        &quot;datetime_format&quot;: &quot;MMM Do, YYYY [at] HH:mm&quot;,
        &quot;active&quot;: 1,
        &quot;default&quot;: 1,
        &quot;parent_id&quot;: null,
        &quot;lft&quot;: 2,
        &quot;rgt&quot;: 3,
        &quot;depth&quot;: 1,
        &quot;created_at&quot;: &quot;2025-03-29 16:14:22&quot;,
        &quot;updated_at&quot;: &quot;2025-03-29 16:14:22&quot;,
        &quot;iso_locale&quot;: &quot;en_US&quot;,
        &quot;tag&quot;: &quot;en&quot;,
        &quot;primary&quot;: &quot;en&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-languages--code-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-languages--code-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-languages--code-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-languages--code-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-languages--code-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-languages--code-" data-method="GET"
      data-path="api/languages/{code}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-languages--code-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-languages--code-"
                    onclick="tryItOut('GETapi-languages--code-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-languages--code-"
                    onclick="cancelTryOut('GETapi-languages--code-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-languages--code-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/languages/{code}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-languages--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-languages--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-languages--code-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-languages--code-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-languages--code-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="code"                data-endpoint="GETapi-languages--code-"
               value="en"
               data-component="url">
    <br>
<p>The language's code. Example: <code>en</code></p>
            </div>
                    </form>

                <h1 id="listings">Listings</h1>

    

                                <h2 id="listings-GETapi-postTypes">List listing types</h2>

<p>
</p>



<span id="example-requests-GETapi-postTypes">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/postTypes" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/postTypes"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/postTypes';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/postTypes'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-postTypes">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;1&quot;: {
            &quot;id&quot;: 1,
            &quot;name&quot;: &quot;INDIVIDUAL&quot;,
            &quot;label&quot;: &quot;Individual&quot;
        },
        &quot;2&quot;: {
            &quot;id&quot;: 2,
            &quot;name&quot;: &quot;PROFESSIONAL&quot;,
            &quot;label&quot;: &quot;Professional&quot;
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-postTypes" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-postTypes"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-postTypes"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-postTypes" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-postTypes">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-postTypes" data-method="GET"
      data-path="api/postTypes"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-postTypes', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-postTypes"
                    onclick="tryItOut('GETapi-postTypes');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-postTypes"
                    onclick="cancelTryOut('GETapi-postTypes');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-postTypes"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/postTypes</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-postTypes"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-postTypes"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-postTypes"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-postTypes"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-postTypes"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                    <h2 id="listings-GETapi-postTypes--id-">Get listing type</h2>

<p>
</p>



<span id="example-requests-GETapi-postTypes--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/postTypes/1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/postTypes/1"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/postTypes/1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/postTypes/1'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-postTypes--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 1,
        &quot;name&quot;: &quot;INDIVIDUAL&quot;,
        &quot;label&quot;: &quot;Individual&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-postTypes--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-postTypes--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-postTypes--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-postTypes--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-postTypes--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-postTypes--id-" data-method="GET"
      data-path="api/postTypes/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-postTypes--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-postTypes--id-"
                    onclick="tryItOut('GETapi-postTypes--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-postTypes--id-"
                    onclick="cancelTryOut('GETapi-postTypes--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-postTypes--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/postTypes/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-postTypes--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-postTypes--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-postTypes--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-postTypes--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-postTypes--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-postTypes--id-"
               value="1"
               data-component="url">
    <br>
<p>The listing type's ID. Example: <code>1</code></p>
            </div>
                    </form>

                    <h2 id="listings-GETapi-reportTypes">List report types</h2>

<p>
</p>



<span id="example-requests-GETapi-reportTypes">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/reportTypes" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/reportTypes"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/reportTypes';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/reportTypes'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-reportTypes">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 5,
                &quot;name&quot;: &quot;Other&quot;
            },
            {
                &quot;id&quot;: 4,
                &quot;name&quot;: &quot;Wrong category&quot;
            },
            {
                &quot;id&quot;: 3,
                &quot;name&quot;: &quot;Spam&quot;
            },
            {
                &quot;id&quot;: 2,
                &quot;name&quot;: &quot;Duplicate&quot;
            },
            {
                &quot;id&quot;: 1,
                &quot;name&quot;: &quot;Fraud&quot;
            }
        ]
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-reportTypes" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-reportTypes"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-reportTypes"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-reportTypes" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-reportTypes">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-reportTypes" data-method="GET"
      data-path="api/reportTypes"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-reportTypes', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-reportTypes"
                    onclick="tryItOut('GETapi-reportTypes');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-reportTypes"
                    onclick="cancelTryOut('GETapi-reportTypes');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-reportTypes"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/reportTypes</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-reportTypes"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-reportTypes"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-reportTypes"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-reportTypes"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-reportTypes"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                    <h2 id="listings-GETapi-reportTypes--id-">Get report type</h2>

<p>
</p>



<span id="example-requests-GETapi-reportTypes--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/reportTypes/1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/reportTypes/1"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/reportTypes/1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/reportTypes/1'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-reportTypes--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 1,
        &quot;name&quot;: &quot;Fraud&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-reportTypes--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-reportTypes--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-reportTypes--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-reportTypes--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-reportTypes--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-reportTypes--id-" data-method="GET"
      data-path="api/reportTypes/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-reportTypes--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-reportTypes--id-"
                    onclick="tryItOut('GETapi-reportTypes--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-reportTypes--id-"
                    onclick="cancelTryOut('GETapi-reportTypes--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-reportTypes--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/reportTypes/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-reportTypes--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-reportTypes--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-reportTypes--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-reportTypes--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-reportTypes--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-reportTypes--id-"
               value="1"
               data-component="url">
    <br>
<p>The report type's ID. Example: <code>1</code></p>
            </div>
                    </form>

                    <h2 id="listings-GETapi-posts">List listings</h2>

<p>
</p>

<p>Note: The main picture of the listings is fetched via a 'picture' attribute (added as fake column),
that provide default picture as image placeholder when the listing has no pictures.
In addition, for performance reasons, default picture is also provided when the 'pictures' table is not embed in the endpoint.
So you need to embed the picture table like: /api/posts?embed=pictures to retrieve right main picture data.</p>

<span id="example-requests-GETapi-posts">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/posts?op=&amp;postId=&amp;distance=&amp;belongLoggedUser=&amp;pendingApproval=&amp;archived=&amp;embed=&amp;sort=created_at&amp;perPage=2" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts"
);

const params = {
    "op": "",
    "postId": "",
    "distance": "",
    "belongLoggedUser": "0",
    "pendingApproval": "0",
    "archived": "0",
    "embed": "",
    "sort": "created_at",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'op' =&gt; '',
            'postId' =&gt; '',
            'distance' =&gt; '',
            'belongLoggedUser' =&gt; '0',
            'pendingApproval' =&gt; '0',
            'archived' =&gt; '0',
            'embed' =&gt; '',
            'sort' =&gt; 'created_at',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts'
params = {
  'op': '',
  'postId': '',
  'distance': '',
  'belongLoggedUser': '0',
  'pendingApproval': '0',
  'archived': '0',
  'embed': '',
  'sort': 'created_at',
  'perPage': '2',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-posts">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 9971,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 1,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 4,
                &quot;post_type_id&quot;: 2,
                &quot;title&quot;: &quot;Highlander 2022 4x4&quot;,
                &quot;excerpt&quot;: &quot;Avez-vous quelque chose &agrave; vendre, &agrave; louer, un service &agrave; offrir ou une offre d&#039;emploi? Publiez gratui...&quot;,
                &quot;description&quot;: &quot;Avez-vous quelque chose &agrave; vendre, &agrave; louer, un service &agrave; offrir ou une offre d&#039;emploi? Publiez gratuitement vos annonces ou &eacute;v&eacute;nements sur LaraClassifier, c&#039;est 100% gratuit, fiable, pens&eacute; business local et tr&egrave;s facile &agrave; utiliser!&quot;,
                &quot;tags&quot;: [
                    &quot;voiture&quot;,
                    &quot;vehicule&quot;,
                    &quot;car&quot;,
                    &quot;motor&quot;
                ],
                &quot;price&quot;: &quot;9000000.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Administrator&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 43751,
                &quot;lat&quot;: 34.75,
                &quot;lon&quot;: -92.29,
                &quot;create_from_ip&quot;: &quot;::1&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 0,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                &quot;phone&quot;: &quot;&quot;,
                &quot;phone_national&quot;: &quot;&quot;,
                &quot;phone_country&quot;: &quot;us&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: null,
                &quot;email_verified_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: null,
                &quot;accept_terms&quot;: 0,
                &quot;accept_marketing_offers&quot;: 0,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: &quot;f0ff4e16945b3338507a3513d5cf0751&quot;,
                &quot;reviewed_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-07T03:07:47.000000Z&quot;,
                &quot;reference&quot;: &quot;LYqaQk6ldnj&quot;,
                &quot;slug&quot;: &quot;highlander-2022-4x4&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/highlander-2022-4x4/LYqaQk6ldnj&quot;,
                &quot;phone_intl&quot;: &quot;&quot;,
                &quot;created_at_formatted&quot;: &quot;May 6th, 2025 at 23:07&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 6th, 2025 at 23:07&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-169751-167491006628503-100001028145118-381299-2017441-o-2-600xjpg-17061746180992.jpg&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$9,000,000&quot;,
                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 15458,
                    &quot;post_id&quot;: 9971,
                    &quot;file_path&quot;: &quot;files/us/9971/01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 0,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/120x90-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/320x240-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9971/thumbnails/816x460-01-techpoint-new-office-12jpg-81501746540991jpg-30651746587267.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9970,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 1,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 2,
                &quot;post_type_id&quot;: 2,
                &quot;title&quot;: &quot;Publier une annonce&quot;,
                &quot;excerpt&quot;: &quot;Avez-vous quelque chose &agrave; vendre, &agrave; louer, un service &agrave; offrir ou une offre d&#039;emploi? Publiez gratui...&quot;,
                &quot;description&quot;: &quot;Avez-vous quelque chose &agrave; vendre, &agrave; louer, un service &agrave; offrir ou une offre d&#039;emploi? Publiez gratuitement vos annonces ou &eacute;v&eacute;nements sur LaraClassifier, c&#039;est 100% gratuit, fiable, pens&eacute; business local et tr&egrave;s facile &agrave; utiliser!&quot;,
                &quot;tags&quot;: [
                    &quot;lola&quot;,
                    &quot;papa&quot;,
                    &quot;maman&quot;
                ],
                &quot;price&quot;: &quot;200000.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Administrator&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 45045,
                &quot;lat&quot;: 38.79,
                &quot;lon&quot;: -90.32,
                &quot;create_from_ip&quot;: &quot;::1&quot;,
                &quot;latest_update_ip&quot;: &quot;::1&quot;,
                &quot;visits&quot;: 0,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                &quot;phone&quot;: &quot;+15537797114&quot;,
                &quot;phone_national&quot;: &quot;(553) 779-7114&quot;,
                &quot;phone_country&quot;: &quot;us&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: null,
                &quot;email_verified_at&quot;: &quot;2025-04-20T18:55:05.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-04-20T18:55:05.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: null,
                &quot;accept_terms&quot;: 0,
                &quot;accept_marketing_offers&quot;: 0,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: &quot;bd0d759b4528e30acefa6ed14af59cfc&quot;,
                &quot;reviewed_at&quot;: &quot;2025-04-20T18:55:05.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-04-20T18:55:05.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-04-28T13:46:16.000000Z&quot;,
                &quot;reference&quot;: &quot;mWZdPjzwaKg&quot;,
                &quot;slug&quot;: &quot;publier-une-annonce&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/publier-une-annonce/mWZdPjzwaKg&quot;,
                &quot;phone_intl&quot;: &quot;+1 553-779-7114&quot;,
                &quot;created_at_formatted&quot;: &quot;Apr 20th, 2025 at 14:55&quot;,
                &quot;updated_at_formatted&quot;: &quot;Apr 28th, 2025 at 09:46&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-169751-167491006628503-100001028145118-381299-2017441-o-2-600xjpg-17061746180992.jpg&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$200,000&quot;,
                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 15456,
                    &quot;post_id&quot;: 9970,
                    &quot;file_path&quot;: &quot;files/us/9970/6of9jpeg-6281745273583.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 0,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-6of9jpeg-6281745273583.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/120x90-6of9jpeg-6281745273583.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/320x240-6of9jpeg-6281745273583.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9970/thumbnails/816x460-6of9jpeg-6281745273583.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9880,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 1048,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 50,
                &quot;post_type_id&quot;: 1,
                &quot;title&quot;: &quot;Adult Eskimo Dog Available&quot;,
                &quot;excerpt&quot;: &quot;Fugit esse quo culpa possimus accusantium. Qui tempora molestiae neque. Eligendi quos quam sint expe...&quot;,
                &quot;description&quot;: &quot;Fugit esse quo culpa possimus accusantium. Qui tempora molestiae neque. Eligendi quos quam sint expedita quidem et. Ex nihil sapiente repellendus nam animi est eaque. Sint quam perspiciatis dolores exercitationem nobis aliquid laborum et. Minima incidunt unde voluptas.&quot;,
                &quot;tags&quot;: [
                    &quot;necessitatibus&quot;,
                    &quot;non&quot;,
                    &quot;sit&quot;
                ],
                &quot;price&quot;: &quot;30.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Casandra Corkery&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 49445,
                &quot;lat&quot;: 37.23,
                &quot;lon&quot;: -121.97,
                &quot;create_from_ip&quot;: &quot;23.171.47.96&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 845,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;jean.kuhlman@hotmail.com&quot;,
                &quot;phone&quot;: &quot;+16611737766&quot;,
                &quot;phone_national&quot;: &quot;(661) 173-7766&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-09T12:28:34.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-09T12:28:34.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 0,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-09T12:28:34.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-02-10T19:25:21.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-02-26T23:05:54.000000Z&quot;,
                &quot;reference&quot;: &quot;GELe36Qxd69&quot;,
                &quot;slug&quot;: &quot;adult-eskimo-dog-available&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/adult-eskimo-dog-available/GELe36Qxd69&quot;,
                &quot;phone_intl&quot;: &quot;(661) 173-7766&quot;,
                &quot;created_at_formatted&quot;: &quot;Feb 10th, 2025 at 14:25&quot;,
                &quot;updated_at_formatted&quot;: &quot;Feb 26th, 2025 at 18:05&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$30&quot;,
                &quot;visits_formatted&quot;: &quot;845 views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 15278,
                    &quot;post_id&quot;: 9880,
                    &quot;file_path&quot;: &quot;files/us/9880/fe9b4956873948c53910242d21f13085.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 3,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9880/thumbnails/816x460-fe9b4956873948c53910242d21f13085.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9880/thumbnails/120x90-fe9b4956873948c53910242d21f13085.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9880/thumbnails/320x240-fe9b4956873948c53910242d21f13085.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9880/thumbnails/816x460-fe9b4956873948c53910242d21f13085.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9878,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 235,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 66,
                &quot;post_type_id&quot;: 2,
                &quot;title&quot;: &quot;Eum animi ad magnam&quot;,
                &quot;excerpt&quot;: &quot;Perspiciatis nam necessitatibus dolores repellat commodi qui velit. Sit cupiditate eos distinctio mo...&quot;,
                &quot;description&quot;: &quot;Perspiciatis nam necessitatibus dolores repellat commodi qui velit. Sit cupiditate eos distinctio molestias id incidunt. Aliquid totam minus consequatur consequatur veniam. Quis sapiente aut asperiores exercitationem autem. Libero possimus quas dolores saepe delectus ut temporibus. Ea est beatae ipsam iusto commodi temporibus. Dignissimos quo culpa accusantium ab laborum vero eos et. Quaerat ullam aperiam fugiat dolorum iusto. Et ut possimus dolorem ut qui voluptatem placeat consequatur. Ea cumque vel a velit itaque quos iure. Ut voluptatem tempora non vero qui illo molestiae.&quot;,
                &quot;tags&quot;: [
                    &quot;dolorum&quot;,
                    &quot;enim&quot;,
                    &quot;occaecati&quot;
                ],
                &quot;price&quot;: &quot;573.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Rogelio Hand&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 45920,
                &quot;lat&quot;: 30.51,
                &quot;lon&quot;: -97.82,
                &quot;create_from_ip&quot;: &quot;55.162.163.78&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 70,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;qkling@hotmail.com&quot;,
                &quot;phone&quot;: &quot;+14963592438&quot;,
                &quot;phone_national&quot;: &quot;(496) 359-2438&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-27T23:00:44.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-27T23:00:44.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 1,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-27T23:00:44.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-03-21T06:26:30.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-03-29T00:49:32.000000Z&quot;,
                &quot;reference&quot;: &quot;EKQe16WPaJY&quot;,
                &quot;slug&quot;: &quot;eum-animi-ad-magnam&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/eum-animi-ad-magnam/EKQe16WPaJY&quot;,
                &quot;phone_intl&quot;: &quot;(496) 359-2438&quot;,
                &quot;created_at_formatted&quot;: &quot;Mar 21st, 2025 at 02:26&quot;,
                &quot;updated_at_formatted&quot;: &quot;Mar 28th, 2025 at 20:49&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$573&quot;,
                &quot;visits_formatted&quot;: &quot;70 views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 15270,
                    &quot;post_id&quot;: 9878,
                    &quot;file_path&quot;: &quot;files/us/9878/003f75350062e01573e381b2ce8e844b.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 1,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9878/thumbnails/816x460-003f75350062e01573e381b2ce8e844b.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9878/thumbnails/120x90-003f75350062e01573e381b2ce8e844b.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9878/thumbnails/320x240-003f75350062e01573e381b2ce8e844b.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9878/thumbnails/816x460-003f75350062e01573e381b2ce8e844b.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9833,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 838,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 71,
                &quot;post_type_id&quot;: 2,
                &quot;title&quot;: &quot;Vel illo excepturi in&quot;,
                &quot;excerpt&quot;: &quot;Pariatur enim esse fugit dignissimos quod. Labore totam laborum minima eveniet dolore aut.&quot;,
                &quot;description&quot;: &quot;Pariatur enim esse fugit dignissimos quod. Labore totam laborum minima eveniet dolore aut.&quot;,
                &quot;tags&quot;: [
                    &quot;illum&quot;,
                    &quot;autem&quot;,
                    &quot;vero&quot;
                ],
                &quot;price&quot;: &quot;39658.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Hertha Collins&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 49344,
                &quot;lat&quot;: 36.32,
                &quot;lon&quot;: -121.24,
                &quot;create_from_ip&quot;: &quot;87.79.251.134&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 158,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;carmel.hickle@hotmail.com&quot;,
                &quot;phone&quot;: &quot;+14683119540&quot;,
                &quot;phone_national&quot;: &quot;(468) 311-9540&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-20T23:35:28.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-20T23:35:28.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 1,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-20T23:35:28.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-03-17T02:34:29.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-17T08:23:38.911251Z&quot;,
                &quot;reference&quot;: &quot;joQeZ8VRbpZ&quot;,
                &quot;slug&quot;: &quot;vel-illo-excepturi-in&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/vel-illo-excepturi-in/joQeZ8VRbpZ&quot;,
                &quot;phone_intl&quot;: &quot;(468) 311-9540&quot;,
                &quot;created_at_formatted&quot;: &quot;Mar 16th, 2025 at 22:34&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$39,658&quot;,
                &quot;visits_formatted&quot;: &quot;158 views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 15200,
                    &quot;post_id&quot;: 9833,
                    &quot;file_path&quot;: &quot;files/us/9833/2a8df509e0ea9aaff63a6ae8e6e9cf2c.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 1,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9833/thumbnails/816x460-2a8df509e0ea9aaff63a6ae8e6e9cf2c.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9833/thumbnails/120x90-2a8df509e0ea9aaff63a6ae8e6e9cf2c.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9833/thumbnails/320x240-2a8df509e0ea9aaff63a6ae8e6e9cf2c.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9833/thumbnails/816x460-2a8df509e0ea9aaff63a6ae8e6e9cf2c.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9817,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 3079,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 18,
                &quot;post_type_id&quot;: 2,
                &quot;title&quot;: &quot;Apple Pencil white color&quot;,
                &quot;excerpt&quot;: &quot;Sit porro architecto quia cumque perspiciatis. Ea aliquid ut ipsam quidem quisquam eum molestias. Ip...&quot;,
                &quot;description&quot;: &quot;Sit porro architecto quia cumque perspiciatis. Ea aliquid ut ipsam quidem quisquam eum molestias. Ipsam vero et odit commodi aut numquam. Accusamus et modi nisi ad aliquid. Ea incidunt suscipit in iusto facilis nesciunt. Sunt deleniti ad dolorem ipsa. Itaque hic illum ducimus omnis voluptas. Placeat labore maiores et consectetur vel.&quot;,
                &quot;tags&quot;: [
                    &quot;nostrum&quot;,
                    &quot;in&quot;,
                    &quot;aut&quot;
                ],
                &quot;price&quot;: &quot;930.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Fidel Hammes&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 48616,
                &quot;lat&quot;: 40.43,
                &quot;lon&quot;: -75.18,
                &quot;create_from_ip&quot;: &quot;70.83.61.79&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 751,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;karelle.block@gmail.com&quot;,
                &quot;phone&quot;: &quot;+13397820786&quot;,
                &quot;phone_national&quot;: &quot;(339) 782-0786&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-02-27T18:46:37.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-02-27T18:46:37.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 0,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-02-27T18:46:37.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-02-21T21:33:38.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-17T08:23:39.043257Z&quot;,
                &quot;reference&quot;: &quot;oBDbDq9qdl2&quot;,
                &quot;slug&quot;: &quot;apple-pencil-white-color&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/apple-pencil-white-color/oBDbDq9qdl2&quot;,
                &quot;phone_intl&quot;: &quot;(339) 782-0786&quot;,
                &quot;created_at_formatted&quot;: &quot;Feb 21st, 2025 at 16:33&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$930&quot;,
                &quot;visits_formatted&quot;: &quot;751 views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 15175,
                    &quot;post_id&quot;: 9817,
                    &quot;file_path&quot;: &quot;files/us/9817/0e8ab1155f7317df6716d33e3fd05d94.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 1,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9817/thumbnails/816x460-0e8ab1155f7317df6716d33e3fd05d94.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9817/thumbnails/120x90-0e8ab1155f7317df6716d33e3fd05d94.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9817/thumbnails/320x240-0e8ab1155f7317df6716d33e3fd05d94.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9817/thumbnails/816x460-0e8ab1155f7317df6716d33e3fd05d94.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9799,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 2541,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 13,
                &quot;post_type_id&quot;: 1,
                &quot;title&quot;: &quot;For sale: Samsung W21 5G&quot;,
                &quot;excerpt&quot;: &quot;Quaerat omnis quis sunt accusamus. Magnam ut commodi et est recusandae voluptas nihil.&quot;,
                &quot;description&quot;: &quot;Quaerat omnis quis sunt accusamus. Magnam ut commodi et est recusandae voluptas nihil.&quot;,
                &quot;tags&quot;: [
                    &quot;odit&quot;,
                    &quot;optio&quot;,
                    &quot;temporibus&quot;
                ],
                &quot;price&quot;: &quot;3528.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Maybelle Rosenbaum&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 49556,
                &quot;lat&quot;: 34.43,
                &quot;lon&quot;: -117.65,
                &quot;create_from_ip&quot;: &quot;153.202.4.131&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 113,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;tebert@gmail.com&quot;,
                &quot;phone&quot;: &quot;+19631520619&quot;,
                &quot;phone_national&quot;: &quot;(963) 152-0619&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-04T11:09:58.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-04T11:09:58.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 0,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-04T11:09:58.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-01-29T03:32:42.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-17T08:23:39.168519Z&quot;,
                &quot;reference&quot;: &quot;7LDdw0j1e1Y&quot;,
                &quot;slug&quot;: &quot;for-sale-samsung-w21-5g&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/for-sale-samsung-w21-5g/7LDdw0j1e1Y&quot;,
                &quot;phone_intl&quot;: &quot;(963) 152-0619&quot;,
                &quot;created_at_formatted&quot;: &quot;Jan 28th, 2025 at 22:32&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$3,528&quot;,
                &quot;visits_formatted&quot;: &quot;113 views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 15147,
                    &quot;post_id&quot;: 9799,
                    &quot;file_path&quot;: &quot;files/us/9799/57a02aeeb54bd20413f45a276d16c532.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 3,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9799/thumbnails/816x460-57a02aeeb54bd20413f45a276d16c532.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9799/thumbnails/120x90-57a02aeeb54bd20413f45a276d16c532.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9799/thumbnails/320x240-57a02aeeb54bd20413f45a276d16c532.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9799/thumbnails/816x460-57a02aeeb54bd20413f45a276d16c532.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9773,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 1938,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 59,
                &quot;post_type_id&quot;: 1,
                &quot;title&quot;: &quot;Ballet shoe yellow&quot;,
                &quot;excerpt&quot;: &quot;Doloribus aut hic omnis provident accusamus sed. Reprehenderit veniam et aliquid vero. Similique odi...&quot;,
                &quot;description&quot;: &quot;Doloribus aut hic omnis provident accusamus sed. Reprehenderit veniam et aliquid vero. Similique odit et quia fugit labore ut quos error. Dolorem voluptas autem modi architecto et. Sunt nulla eius facere. Facere aut praesentium aut possimus ipsam dolorem eveniet. Sed saepe velit enim ad iste voluptatem corrupti nulla. Omnis et ab beatae ipsa et officia alias laudantium. Reiciendis tempore ducimus rem perferendis repellendus illum aut.&quot;,
                &quot;tags&quot;: [
                    &quot;qui&quot;,
                    &quot;et&quot;,
                    &quot;nulla&quot;
                ],
                &quot;price&quot;: &quot;76352.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Otilia Hahn&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 49244,
                &quot;lat&quot;: 36.1,
                &quot;lon&quot;: -119.56,
                &quot;create_from_ip&quot;: &quot;236.212.223.69&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 8219,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;leatha63@gmail.com&quot;,
                &quot;phone&quot;: &quot;+19116623591&quot;,
                &quot;phone_national&quot;: &quot;(911) 662-3591&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-20T00:27:59.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-20T00:27:59.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 1,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 1,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-20T00:27:59.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-02-26T15:02:21.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-17T08:23:39.306111Z&quot;,
                &quot;reference&quot;: &quot;Oy5eVvmveEP&quot;,
                &quot;slug&quot;: &quot;ballet-shoe-yellow&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/ballet-shoe-yellow/Oy5eVvmveEP&quot;,
                &quot;phone_intl&quot;: &quot;(911) 662-3591&quot;,
                &quot;created_at_formatted&quot;: &quot;Feb 26th, 2025 at 10:02&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$76,352&quot;,
                &quot;visits_formatted&quot;: &quot;8.2K views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 15105,
                    &quot;post_id&quot;: 9773,
                    &quot;file_path&quot;: &quot;files/us/9773/6b9729a76f41a7d5c94d774ff467e1ba.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 1,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9773/thumbnails/816x460-6b9729a76f41a7d5c94d774ff467e1ba.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9773/thumbnails/120x90-6b9729a76f41a7d5c94d774ff467e1ba.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9773/thumbnails/320x240-6b9729a76f41a7d5c94d774ff467e1ba.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9773/thumbnails/816x460-6b9729a76f41a7d5c94d774ff467e1ba.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9688,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 3048,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 59,
                &quot;post_type_id&quot;: 1,
                &quot;title&quot;: &quot;Slip-on shoe&quot;,
                &quot;excerpt&quot;: &quot;Odit tempora ut aut officia ullam. Aut odio quia occaecati commodi et alias aut non. Perferendis arc...&quot;,
                &quot;description&quot;: &quot;Odit tempora ut aut officia ullam. Aut odio quia occaecati commodi et alias aut non. Perferendis architecto perspiciatis odio accusantium reprehenderit. Culpa occaecati et repellat labore quia. Est nobis eos ipsa omnis. Reiciendis debitis non odio id rerum aut. Vel et dolorum dignissimos ullam id. Aperiam et consequatur distinctio ad assumenda ut.&quot;,
                &quot;tags&quot;: [
                    &quot;ducimus&quot;,
                    &quot;vero&quot;,
                    &quot;quis&quot;
                ],
                &quot;price&quot;: &quot;620.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Benedict Fadel&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 50320,
                &quot;lat&quot;: 47.74,
                &quot;lon&quot;: -122.08,
                &quot;create_from_ip&quot;: &quot;243.161.144.73&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 93,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;rose.hills@yahoo.com&quot;,
                &quot;phone&quot;: &quot;+12088647517&quot;,
                &quot;phone_national&quot;: &quot;(208) 864-7517&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-27T22:58:06.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-27T22:58:06.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 1,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-27T22:58:06.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-03-04T04:46:29.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-17T08:23:39.435035Z&quot;,
                &quot;reference&quot;: &quot;WjnegpYkawZ&quot;,
                &quot;slug&quot;: &quot;slip-on-shoe&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/slip-on-shoe/WjnegpYkawZ&quot;,
                &quot;phone_intl&quot;: &quot;(208) 864-7517&quot;,
                &quot;created_at_formatted&quot;: &quot;Mar 3rd, 2025 at 23:46&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$620&quot;,
                &quot;visits_formatted&quot;: &quot;93 views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 14984,
                    &quot;post_id&quot;: 9688,
                    &quot;file_path&quot;: &quot;files/us/9688/89a64619902592a556f436ef84f7c252.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 1,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9688/thumbnails/816x460-89a64619902592a556f436ef84f7c252.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9688/thumbnails/120x90-89a64619902592a556f436ef84f7c252.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9688/thumbnails/320x240-89a64619902592a556f436ef84f7c252.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9688/thumbnails/816x460-89a64619902592a556f436ef84f7c252.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9662,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 2318,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 27,
                &quot;post_type_id&quot;: 2,
                &quot;title&quot;: &quot;Canon EOS 5D Mark IV white&quot;,
                &quot;excerpt&quot;: &quot;Esse nesciunt dolores officia repellat ex. Quasi aut voluptatum aut id velit dolorum ducimus. Repell...&quot;,
                &quot;description&quot;: &quot;Esse nesciunt dolores officia repellat ex. Quasi aut voluptatum aut id velit dolorum ducimus. Repellendus quaerat natus ipsum tempore vitae id necessitatibus. Temporibus saepe et cum sit molestiae fugit. Porro dolores ratione animi molestiae. Nesciunt qui tempora natus consequatur sit fugit. Quod repellendus esse sint porro optio earum. Enim aperiam earum culpa consequatur laborum reprehenderit ducimus. Dolorem et est dolor debitis. Possimus rerum dolores atque.&quot;,
                &quot;tags&quot;: [
                    &quot;molestias&quot;,
                    &quot;rem&quot;,
                    &quot;ab&quot;
                ],
                &quot;price&quot;: &quot;72517.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Adolfo Kling&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 47323,
                &quot;lat&quot;: 42.13,
                &quot;lon&quot;: -83.14,
                &quot;create_from_ip&quot;: &quot;88.88.204.217&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 4067,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;moriah.willms@gmail.com&quot;,
                &quot;phone&quot;: &quot;+13198413610&quot;,
                &quot;phone_national&quot;: &quot;(319) 841-3610&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-18T11:08:11.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-18T11:08:11.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 1,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-18T11:08:11.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-03-13T12:05:49.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-17T08:23:39.567655Z&quot;,
                &quot;reference&quot;: &quot;K4oeE8rgd0B&quot;,
                &quot;slug&quot;: &quot;canon-eos-5d-mark-iv-white&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/canon-eos-5d-mark-iv-white/K4oeE8rgd0B&quot;,
                &quot;phone_intl&quot;: &quot;(319) 841-3610&quot;,
                &quot;created_at_formatted&quot;: &quot;Mar 13th, 2025 at 08:05&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$72,517&quot;,
                &quot;visits_formatted&quot;: &quot;4.1K views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 14942,
                    &quot;post_id&quot;: 9662,
                    &quot;file_path&quot;: &quot;files/us/9662/4defa6d9445f7e5188283ab1effa6aee.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 1,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9662/thumbnails/816x460-4defa6d9445f7e5188283ab1effa6aee.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9662/thumbnails/120x90-4defa6d9445f7e5188283ab1effa6aee.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9662/thumbnails/320x240-4defa6d9445f7e5188283ab1effa6aee.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9662/thumbnails/816x460-4defa6d9445f7e5188283ab1effa6aee.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9627,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 2968,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 15,
                &quot;post_type_id&quot;: 2,
                &quot;title&quot;: &quot;2023 MacBook Air&quot;,
                &quot;excerpt&quot;: &quot;Nesciunt quae eos soluta qui nemo. Accusantium eaque et autem ratione. Sapiente quis aut aliquid qui...&quot;,
                &quot;description&quot;: &quot;Nesciunt quae eos soluta qui nemo. Accusantium eaque et autem ratione. Sapiente quis aut aliquid quibusdam. Omnis quidem rerum placeat ullam quod. Quidem ea ad eos voluptatem dolorem. Dolorem debitis enim qui quia sint iure minima fugit. Tempora qui aut aperiam autem et numquam ipsam. Sunt numquam iure porro hic eligendi voluptatum corrupti reiciendis. Eos qui nam impedit quidem non. Sed temporibus numquam blanditiis qui ab pariatur illo incidunt. Eaque enim est autem voluptatum nam sint.&quot;,
                &quot;tags&quot;: [
                    &quot;velit&quot;,
                    &quot;cum&quot;
                ],
                &quot;price&quot;: &quot;47.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Wilfred Walsh&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 50569,
                &quot;lat&quot;: 41.88,
                &quot;lon&quot;: -72.81,
                &quot;create_from_ip&quot;: &quot;179.152.121.16&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 197,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;gutkowski.kayden@hotmail.com&quot;,
                &quot;phone&quot;: &quot;+15467218473&quot;,
                &quot;phone_national&quot;: &quot;(546) 721-8473&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-19T20:35:30.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-19T20:35:30.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 1,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 1,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-19T20:35:30.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-03-07T20:16:19.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-17T08:23:39.741392Z&quot;,
                &quot;reference&quot;: &quot;LYqaQn39bnj&quot;,
                &quot;slug&quot;: &quot;2023-macbook-air&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/2023-macbook-air/LYqaQn39bnj&quot;,
                &quot;phone_intl&quot;: &quot;(546) 721-8473&quot;,
                &quot;created_at_formatted&quot;: &quot;Mar 7th, 2025 at 15:16&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$47&quot;,
                &quot;visits_formatted&quot;: &quot;197 views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 14890,
                    &quot;post_id&quot;: 9627,
                    &quot;file_path&quot;: &quot;files/us/9627/711ba65c2dc3454ae5d2eabc95e3ce1e.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 1,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9627/thumbnails/816x460-711ba65c2dc3454ae5d2eabc95e3ce1e.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9627/thumbnails/120x90-711ba65c2dc3454ae5d2eabc95e3ce1e.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9627/thumbnails/320x240-711ba65c2dc3454ae5d2eabc95e3ce1e.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9627/thumbnails/816x460-711ba65c2dc3454ae5d2eabc95e3ce1e.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            },
            {
                &quot;id&quot;: 9582,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;user_id&quot;: 2291,
                &quot;payment_id&quot;: null,
                &quot;category_id&quot;: 71,
                &quot;post_type_id&quot;: 1,
                &quot;title&quot;: &quot;Repellendus ducimus rerum unde odit&quot;,
                &quot;excerpt&quot;: &quot;Commodi numquam ea aut id asperiores nobis et. Fugiat maxime excepturi magni consequatur dolor et. R...&quot;,
                &quot;description&quot;: &quot;Commodi numquam ea aut id asperiores nobis et. Fugiat maxime excepturi magni consequatur dolor et. Rem natus reiciendis qui consequatur. Rerum perspiciatis cum nemo eos est eum expedita.&quot;,
                &quot;tags&quot;: [
                    &quot;quia&quot;,
                    &quot;natus&quot;,
                    &quot;autem&quot;
                ],
                &quot;price&quot;: &quot;518.00&quot;,
                &quot;currency_code&quot;: null,
                &quot;negotiable&quot;: 0,
                &quot;contact_name&quot;: &quot;Neil Klein&quot;,
                &quot;address&quot;: null,
                &quot;city_id&quot;: 49731,
                &quot;lat&quot;: 33.97,
                &quot;lon&quot;: -118.23,
                &quot;create_from_ip&quot;: &quot;53.236.217.4&quot;,
                &quot;latest_update_ip&quot;: null,
                &quot;visits&quot;: 29475,
                &quot;auth_field&quot;: &quot;email&quot;,
                &quot;email&quot;: &quot;ssimonis@hotmail.com&quot;,
                &quot;phone&quot;: &quot;+19435352427&quot;,
                &quot;phone_national&quot;: &quot;(943) 535-2427&quot;,
                &quot;phone_country&quot;: &quot;US&quot;,
                &quot;email_token&quot;: null,
                &quot;phone_token&quot;: &quot;demoFaker&quot;,
                &quot;email_verified_at&quot;: &quot;2025-03-05T06:27:51.000000Z&quot;,
                &quot;phone_verified_at&quot;: &quot;2025-03-05T06:27:51.000000Z&quot;,
                &quot;otp_expires_at&quot;: null,
                &quot;last_otp_sent_at&quot;: null,
                &quot;otp_resend_attempts&quot;: 0,
                &quot;otp_resend_attempts_expires_at&quot;: null,
                &quot;total_otp_resend_attempts&quot;: 0,
                &quot;locked_at&quot;: null,
                &quot;phone_hidden&quot;: 0,
                &quot;accept_terms&quot;: 1,
                &quot;accept_marketing_offers&quot;: 1,
                &quot;is_permanent&quot;: 0,
                &quot;featured&quot;: 0,
                &quot;tmp_token&quot;: null,
                &quot;reviewed_at&quot;: &quot;2025-03-05T06:27:51.000000Z&quot;,
                &quot;archived_at&quot;: null,
                &quot;archived_manually_at&quot;: null,
                &quot;deletion_mail_sent_at&quot;: null,
                &quot;created_at&quot;: &quot;2025-01-25T09:00:14.000000Z&quot;,
                &quot;updated_at&quot;: &quot;2025-05-17T08:23:39.929457Z&quot;,
                &quot;reference&quot;: &quot;qM7e5QjYe2v&quot;,
                &quot;slug&quot;: &quot;repellendus-ducimus-rerum-unde-odit&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/repellendus-ducimus-rerum-unde-odit/qM7e5QjYe2v&quot;,
                &quot;phone_intl&quot;: &quot;(943) 535-2427&quot;,
                &quot;created_at_formatted&quot;: &quot;Jan 25th, 2025 at 04:00&quot;,
                &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
                &quot;archived_at_formatted&quot;: &quot;&quot;,
                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
                &quot;price_label&quot;: &quot;Price:&quot;,
                &quot;price_formatted&quot;: &quot;$518&quot;,
                &quot;visits_formatted&quot;: &quot;29.5K views&quot;,
                &quot;distance_info&quot;: null,
                &quot;count_pictures&quot;: 0,
                &quot;picture&quot;: {
                    &quot;id&quot;: 14821,
                    &quot;post_id&quot;: 9582,
                    &quot;file_path&quot;: &quot;files/us/9582/05749c3b8b0ff7e82ccd956cdea5ebd0.jpg&quot;,
                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                    &quot;position&quot;: 1,
                    &quot;active&quot;: 1,
                    &quot;url&quot;: {
                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9582/thumbnails/816x460-05749c3b8b0ff7e82ccd956cdea5ebd0.jpg&quot;,
                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9582/thumbnails/120x90-05749c3b8b0ff7e82ccd956cdea5ebd0.jpg&quot;,
                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9582/thumbnails/320x240-05749c3b8b0ff7e82ccd956cdea5ebd0.jpg&quot;,
                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9582/thumbnails/816x460-05749c3b8b0ff7e82ccd956cdea5ebd0.jpg&quot;
                    }
                },
                &quot;rating_cache&quot;: 0,
                &quot;rating_count&quot;: 0
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=21&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 21,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=7&quot;,
                    &quot;label&quot;: &quot;7&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=8&quot;,
                    &quot;label&quot;: &quot;8&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=9&quot;,
                    &quot;label&quot;: &quot;9&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=10&quot;,
                    &quot;label&quot;: &quot;10&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;...&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=20&quot;,
                    &quot;label&quot;: &quot;20&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=21&quot;,
                    &quot;label&quot;: &quot;21&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts?page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/posts&quot;,
            &quot;per_page&quot;: 12,
            &quot;to&quot;: 12,
            &quot;total&quot;: 251
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-posts" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-posts"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-posts"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-posts" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-posts">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-posts" data-method="GET"
      data-path="api/posts"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-posts', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-posts"
                    onclick="tryItOut('GETapi-posts');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-posts"
                    onclick="cancelTryOut('GETapi-posts');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-posts"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/posts</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-posts"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-posts"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-posts"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-posts"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-posts"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>op</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="op"                data-endpoint="GETapi-posts"
               value=""
               data-component="query">
    <br>
<p>Type of listings list (optional) - Possible value: search,premium,latest,free,premiumFirst,similar.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>postId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="postId"                data-endpoint="GETapi-posts"
               value=""
               data-component="query">
    <br>
<p>Base Listing's ID to get similar listings (optional) - Mandatory to get similar listings (when op=similar).</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>distance</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="distance"                data-endpoint="GETapi-posts"
               value=""
               data-component="query">
    <br>
<p>Distance to get similar listings (optional) - Also optional when the type of similar listings is based on the current listing's category. Mandatory when the type of similar listings is based on the current listing's location. So, its usage is limited to get similar listings (when op=similar) based on the current listing's location.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>belongLoggedUser</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="belongLoggedUser"
                   value="1"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="belongLoggedUser"
                   value="0"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Force users to be logged to get data that belongs to him. Authentication token needs to be sent in the header, and the &quot;op&quot; parameter needs to be null or unset - Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>pendingApproval</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="pendingApproval"
                   value="1"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="pendingApproval"
                   value="0"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>To list a user's listings in pending approval. Authentication token needs to be sent in the header, and the &quot;op&quot; parameter needs to be null or unset - Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>archived</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="archived"
                   value="1"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="archived"
                   value="0"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>To list a user's archived listings. Authentication token needs to be sent in the header, and the &quot;op&quot; parameter need be null or unset - Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-posts"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the post relationships for Eager Loading - Possible values: user,category,parent,postType,city,currency,savedByLoggedUser,pictures,payment,package.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-posts"
               value="created_at"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: created_at. Example: <code>created_at</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-posts"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                    <h2 id="listings-GETapi-posts--id-">Get listing</h2>

<p>
</p>

<p>Note: The main picture of the listing is fetched via a 'picture' attribute (added as fake column),
that provide default picture as image placeholder when the listing has no pictures.
In addition, for performance reasons, default picture is also provided when the 'pictures' table is not embed in the endpoint.
So you need to embed the picture table like: /api/posts/1?embed=pictures to retrieve right main picture data.</p>

<span id="example-requests-GETapi-posts--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/posts/2?unactivatedIncluded=1&amp;belongLoggedUser=&amp;noCache=&amp;embed=user%2CpostType&amp;detailed=" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/2"
);

const params = {
    "unactivatedIncluded": "1",
    "belongLoggedUser": "0",
    "noCache": "0",
    "embed": "user,postType",
    "detailed": "0",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/2';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'unactivatedIncluded' =&gt; '1',
            'belongLoggedUser' =&gt; '0',
            'noCache' =&gt; '0',
            'embed' =&gt; 'user,postType',
            'detailed' =&gt; '0',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/2'
params = {
  'unactivatedIncluded': '1',
  'belongLoggedUser': '0',
  'noCache': '0',
  'embed': 'user,postType',
  'detailed': '0',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-posts--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 2,
        &quot;country_code&quot;: &quot;US&quot;,
        &quot;user_id&quot;: 2,
        &quot;payment_id&quot;: null,
        &quot;category_id&quot;: 128,
        &quot;post_type_id&quot;: 1,
        &quot;title&quot;: &quot;Voluptas inventore repellendus veniam&quot;,
        &quot;excerpt&quot;: &quot;Tenetur sed impedit ullam est sint libero minima qui. Alias laboriosam omnis quisquam nemo et tenetu...&quot;,
        &quot;description&quot;: &quot;Tenetur sed impedit ullam est sint libero minima qui. Alias laboriosam omnis quisquam nemo et tenetur. Corporis veritatis natus voluptatem in vitae est consequuntur. Tempora vel nam deserunt explicabo nesciunt. Ab et est delectus facilis iure ut. Sapiente ratione blanditiis quaerat nemo. Earum et dolorem sed temporibus vel est laudantium. Et aperiam maxime sequi ut id consequatur. Est est harum corporis dolorem ratione officia. Enim iste autem in aut.&quot;,
        &quot;tags&quot;: [
            &quot;et&quot;,
            &quot;dolores&quot;,
            &quot;voluptatum&quot;
        ],
        &quot;price&quot;: &quot;75594.00&quot;,
        &quot;currency_code&quot;: null,
        &quot;negotiable&quot;: 0,
        &quot;contact_name&quot;: &quot;Admin Demo&quot;,
        &quot;address&quot;: null,
        &quot;city_id&quot;: 46920,
        &quot;lat&quot;: 42.11,
        &quot;lon&quot;: -87.74,
        &quot;create_from_ip&quot;: &quot;246.76.57.28&quot;,
        &quot;latest_update_ip&quot;: null,
        &quot;visits&quot;: 96,
        &quot;auth_field&quot;: &quot;email&quot;,
        &quot;email&quot;: &quot;admin@domain.tld&quot;,
        &quot;phone&quot;: &quot;+18333836966&quot;,
        &quot;phone_national&quot;: &quot;(833) 383-6966&quot;,
        &quot;phone_country&quot;: &quot;US&quot;,
        &quot;email_token&quot;: null,
        &quot;phone_token&quot;: &quot;demoFaker&quot;,
        &quot;email_verified_at&quot;: &quot;2025-03-09T22:30:09.000000Z&quot;,
        &quot;phone_verified_at&quot;: &quot;2025-03-09T22:30:09.000000Z&quot;,
        &quot;otp_expires_at&quot;: null,
        &quot;last_otp_sent_at&quot;: null,
        &quot;otp_resend_attempts&quot;: 0,
        &quot;otp_resend_attempts_expires_at&quot;: null,
        &quot;total_otp_resend_attempts&quot;: 0,
        &quot;locked_at&quot;: null,
        &quot;phone_hidden&quot;: 0,
        &quot;accept_terms&quot;: 1,
        &quot;accept_marketing_offers&quot;: 0,
        &quot;is_permanent&quot;: 0,
        &quot;featured&quot;: 1,
        &quot;tmp_token&quot;: null,
        &quot;reviewed_at&quot;: &quot;2025-03-09T22:30:09.000000Z&quot;,
        &quot;archived_at&quot;: null,
        &quot;archived_manually_at&quot;: null,
        &quot;deletion_mail_sent_at&quot;: null,
        &quot;created_at&quot;: &quot;2025-02-14T15:40:02.000000Z&quot;,
        &quot;updated_at&quot;: &quot;2025-05-17T08:23:41.000000Z&quot;,
        &quot;reference&quot;: &quot;GWpmbk5ezJn&quot;,
        &quot;slug&quot;: &quot;voluptas-inventore-repellendus-veniam&quot;,
        &quot;url&quot;: &quot;https://demo.laraclassifier.local/voluptas-inventore-repellendus-veniam/GWpmbk5ezJn&quot;,
        &quot;phone_intl&quot;: &quot;(833) 383-6966&quot;,
        &quot;created_at_formatted&quot;: &quot;3 months ago&quot;,
        &quot;updated_at_formatted&quot;: &quot;May 17th, 2025 at 04:23&quot;,
        &quot;archived_at_formatted&quot;: &quot;&quot;,
        &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
        &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/2/thumbnails/800x800-41ccbeb517f138cf49aa5048e8f07b68.jpg&quot;,
        &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;,
        &quot;price_label&quot;: &quot;Price:&quot;,
        &quot;price_formatted&quot;: &quot;$75,594&quot;,
        &quot;visits_formatted&quot;: &quot;96 views&quot;,
        &quot;distance_info&quot;: null,
        &quot;count_pictures&quot;: 0,
        &quot;picture&quot;: {
            &quot;id&quot;: 4,
            &quot;post_id&quot;: 2,
            &quot;file_path&quot;: &quot;files/us/2/eb4a05e800c6ea5fbf9d16171777fce3.jpg&quot;,
            &quot;mime_type&quot;: &quot;image/jpeg&quot;,
            &quot;position&quot;: 1,
            &quot;active&quot;: 1,
            &quot;url&quot;: {
                &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2/thumbnails/816x460-eb4a05e800c6ea5fbf9d16171777fce3.jpg&quot;,
                &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2/thumbnails/120x90-eb4a05e800c6ea5fbf9d16171777fce3.jpg&quot;,
                &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2/thumbnails/320x240-eb4a05e800c6ea5fbf9d16171777fce3.jpg&quot;,
                &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2/thumbnails/816x460-eb4a05e800c6ea5fbf9d16171777fce3.jpg&quot;
            }
        },
        &quot;user&quot;: {
            &quot;id&quot;: 2,
            &quot;name&quot;: &quot;Admin Demo&quot;,
            &quot;username&quot;: null,
            &quot;two_factor_enabled&quot;: false,
            &quot;two_factor_method&quot;: &quot;email&quot;,
            &quot;updated_at&quot;: &quot;2025-01-21T16:23:44.000000Z&quot;,
            &quot;original_updated_at&quot;: &quot;2025-01-21 16:23:44&quot;,
            &quot;original_last_activity&quot;: null,
            &quot;created_at_formatted&quot;: &quot;1 year ago&quot;,
            &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/2/thumbnails/800x800-41ccbeb517f138cf49aa5048e8f07b68.jpg&quot;,
            &quot;p_is_online&quot;: false,
            &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/circle/16/us.png&quot;
        },
        &quot;postType&quot;: {
            &quot;id&quot;: 1,
            &quot;name&quot;: &quot;INDIVIDUAL&quot;,
            &quot;label&quot;: &quot;Individual&quot;
        },
        &quot;rating_cache&quot;: 0,
        &quot;rating_count&quot;: 0
    },
    &quot;extra&quot;: {
        &quot;fieldsValues&quot;: []
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-posts--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-posts--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-posts--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-posts--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-posts--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-posts--id-" data-method="GET"
      data-path="api/posts/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-posts--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-posts--id-"
                    onclick="tryItOut('GETapi-posts--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-posts--id-"
                    onclick="cancelTryOut('GETapi-posts--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-posts--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/posts/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-posts--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-posts--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-posts--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-posts--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-posts--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-posts--id-"
               value="2"
               data-component="url">
    <br>
<p>The post/listing's ID. Example: <code>2</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>unactivatedIncluded</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="unactivatedIncluded"
                   value="1"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="unactivatedIncluded"
                   value="0"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Include or not unactivated entries - Possible value: 0 or 1. Example: <code>true</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>belongLoggedUser</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="belongLoggedUser"
                   value="1"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="belongLoggedUser"
                   value="0"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Force users to be logged to get data that belongs to him - Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>noCache</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="noCache"
                   value="1"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="noCache"
                   value="0"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Disable the cache for this request - Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-posts--id-"
               value="user,postType"
               data-component="query">
    <br>
<p>Comma-separated list of the post relationships for Eager Loading - Possible values: user,category,parent,postType,city,currency,savedByLoggedUser,pictures,payment,package,fieldsValues. Example: <code>user,postType</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>detailed</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="detailed"
                   value="1"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="detailed"
                   value="0"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the listing's details with all its relationships (No need to set the 'embed' parameter). Example: <code>false</code></p>
            </div>
                </form>

                    <h2 id="listings-POSTapi-posts">Store listing</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>For both types of listing's creation (Single step or Multi steps).
Note: The field 'admin_code' is only available when the listing's country's 'admin_type' column is set to 1 or 2.</p>

<span id="example-requests-POSTapi-posts">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/posts" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: multipart/form-data" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --form "category_id=1"\
    --form "post_type_id=1"\
    --form "title=John Doe"\
    --form "description=Beatae placeat atque tempore consequatur animi magni omnis."\
    --form "contact_name=John Doe"\
    --form "auth_field=email"\
    --form "phone=+17656766467"\
    --form "phone_country="\
    --form "city_id=8"\
    --form "accept_terms="\
    --form "admin_code=0"\
    --form "email=john.doe@domain.tld"\
    --form "country_code=US"\
    --form "price=5000"\
    --form "negotiable="\
    --form "phone_hidden="\
    --form "create_from_ip=127.0.0.1"\
    --form "accept_marketing_offers="\
    --form "is_permanent="\
    --form "tags=car,automotive,tesla,cyber,truck"\
    --form "package_id=2"\
    --form "payment_method_id=5"\
    --form "captcha_key=ullam"\
    --form "pictures[]=@/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpwe80U7" </code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "multipart/form-data",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

const body = new FormData();
body.append('category_id', '1');
body.append('post_type_id', '1');
body.append('title', 'John Doe');
body.append('description', 'Beatae placeat atque tempore consequatur animi magni omnis.');
body.append('contact_name', 'John Doe');
body.append('auth_field', 'email');
body.append('phone', '+17656766467');
body.append('phone_country', '');
body.append('city_id', '8');
body.append('accept_terms', '');
body.append('admin_code', '0');
body.append('email', 'john.doe@domain.tld');
body.append('country_code', 'US');
body.append('price', '5000');
body.append('negotiable', '');
body.append('phone_hidden', '');
body.append('create_from_ip', '127.0.0.1');
body.append('accept_marketing_offers', '');
body.append('is_permanent', '');
body.append('tags', 'car,automotive,tesla,cyber,truck');
body.append('package_id', '2');
body.append('payment_method_id', '5');
body.append('captcha_key', 'ullam');
body.append('pictures[]', document.querySelector('input[name="pictures[]"]').files[0]);

fetch(url, {
    method: "POST",
    headers,
    body,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'multipart/form-data',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'multipart' =&gt; [
            [
                'name' =&gt; 'category_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'post_type_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'title',
                'contents' =&gt; 'John Doe'
            ],
            [
                'name' =&gt; 'description',
                'contents' =&gt; 'Beatae placeat atque tempore consequatur animi magni omnis.'
            ],
            [
                'name' =&gt; 'contact_name',
                'contents' =&gt; 'John Doe'
            ],
            [
                'name' =&gt; 'auth_field',
                'contents' =&gt; 'email'
            ],
            [
                'name' =&gt; 'phone',
                'contents' =&gt; '+17656766467'
            ],
            [
                'name' =&gt; 'phone_country',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'city_id',
                'contents' =&gt; '8'
            ],
            [
                'name' =&gt; 'accept_terms',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'admin_code',
                'contents' =&gt; '0'
            ],
            [
                'name' =&gt; 'email',
                'contents' =&gt; 'john.doe@domain.tld'
            ],
            [
                'name' =&gt; 'country_code',
                'contents' =&gt; 'US'
            ],
            [
                'name' =&gt; 'price',
                'contents' =&gt; '5000'
            ],
            [
                'name' =&gt; 'negotiable',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'phone_hidden',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'create_from_ip',
                'contents' =&gt; '127.0.0.1'
            ],
            [
                'name' =&gt; 'accept_marketing_offers',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'is_permanent',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'tags',
                'contents' =&gt; 'car,automotive,tesla,cyber,truck'
            ],
            [
                'name' =&gt; 'package_id',
                'contents' =&gt; '2'
            ],
            [
                'name' =&gt; 'payment_method_id',
                'contents' =&gt; '5'
            ],
            [
                'name' =&gt; 'captcha_key',
                'contents' =&gt; 'ullam'
            ],
            [
                'name' =&gt; 'pictures[]',
                'contents' =&gt; fopen('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpwe80U7', 'r')
            ],
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts'
files = {
  'category_id': (None, '1'),
  'post_type_id': (None, '1'),
  'title': (None, 'John Doe'),
  'description': (None, 'Beatae placeat atque tempore consequatur animi magni omnis.'),
  'contact_name': (None, 'John Doe'),
  'auth_field': (None, 'email'),
  'phone': (None, '+17656766467'),
  'phone_country': (None, ''),
  'city_id': (None, '8'),
  'accept_terms': (None, ''),
  'admin_code': (None, '0'),
  'email': (None, 'john.doe@domain.tld'),
  'country_code': (None, 'US'),
  'price': (None, '5000'),
  'negotiable': (None, ''),
  'phone_hidden': (None, ''),
  'create_from_ip': (None, '127.0.0.1'),
  'accept_marketing_offers': (None, ''),
  'is_permanent': (None, ''),
  'tags': (None, 'car,automotive,tesla,cyber,truck'),
  'package_id': (None, '2'),
  'payment_method_id': (None, '5'),
  'captcha_key': (None, 'ullam'),
  'pictures[]': open('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpwe80U7', 'rb')}
payload = {
    "category_id": 1,
    "post_type_id": 1,
    "title": "John Doe",
    "description": "Beatae placeat atque tempore consequatur animi magni omnis.",
    "contact_name": "John Doe",
    "auth_field": "email",
    "phone": "+17656766467",
    "phone_country": null,
    "city_id": 8,
    "accept_terms": false,
    "admin_code": "0",
    "email": "john.doe@domain.tld",
    "country_code": "US",
    "price": 5000,
    "negotiable": false,
    "phone_hidden": false,
    "create_from_ip": "127.0.0.1",
    "accept_marketing_offers": false,
    "is_permanent": false,
    "tags": "car,automotive,tesla,cyber,truck",
    "package_id": 2,
    "payment_method_id": 5,
    "captcha_key": "ullam"
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'multipart/form-data',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, files=files)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-posts">
</span>
<span id="execution-results-POSTapi-posts" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-posts"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-posts"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-posts" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-posts">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-posts" data-method="POST"
      data-path="api/posts"
      data-authed="1"
      data-hasfiles="1"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-posts', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-posts"
                    onclick="tryItOut('POSTapi-posts');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-posts"
                    onclick="cancelTryOut('POSTapi-posts');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-posts"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/posts</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="POSTapi-posts"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-posts"
               value="multipart/form-data"
               data-component="header">
    <br>
<p>Example: <code>multipart/form-data</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-posts"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-posts"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-posts"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-posts"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>category_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="category_id"                data-endpoint="POSTapi-posts"
               value="1"
               data-component="body">
    <br>
<p>The category's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_type_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_type_id"                data-endpoint="POSTapi-posts"
               value="1"
               data-component="body">
    <br>
<p>The listing type's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>title</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="title"                data-endpoint="POSTapi-posts"
               value="John Doe"
               data-component="body">
    <br>
<p>The listing's title. Example: <code>John Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>description</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="description"                data-endpoint="POSTapi-posts"
               value="Beatae placeat atque tempore consequatur animi magni omnis."
               data-component="body">
    <br>
<p>The listing's description. Example: <code>Beatae placeat atque tempore consequatur animi magni omnis.</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>contact_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="contact_name"                data-endpoint="POSTapi-posts"
               value="John Doe"
               data-component="body">
    <br>
<p>The listing's author name. Example: <code>John Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="POSTapi-posts"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-posts"
               value="+17656766467"
               data-component="body">
    <br>
<p>The listing's author mobile number (Required when 'auth_field' value is 'phone'). Example: <code>+17656766467</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="POSTapi-posts"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>city_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="city_id"                data-endpoint="POSTapi-posts"
               value="8"
               data-component="body">
    <br>
<p>The city's ID. Example: <code>8</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>accept_terms</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
 &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="accept_terms"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="accept_terms"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Accept the website terms and conditions. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>pictures</code></b>&nbsp;&nbsp;
<small>file[]</small>&nbsp;
 &nbsp;
                <input type="file" style="display: none"
                              name="pictures[0]"                data-endpoint="POSTapi-posts"
               data-component="body">
        <input type="file" style="display: none"
               name="pictures[1]"                data-endpoint="POSTapi-posts"
               data-component="body">
    <br>
<p>The listing's pictures.</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>admin_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin_code"                data-endpoint="POSTapi-posts"
               value="0"
               data-component="body">
    <br>
<p>The administrative division's code. Example: <code>0</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-posts"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The listing's author email address (Required when 'auth_field' value is 'email'). Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_code"                data-endpoint="POSTapi-posts"
               value="US"
               data-component="body">
    <br>
<p>The code of the user's country. Example: <code>US</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>price</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="price"                data-endpoint="POSTapi-posts"
               value="5000"
               data-component="body">
    <br>
<p>The price. Example: <code>5000</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>negotiable</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="negotiable"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="negotiable"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Negotiable price or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_hidden</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="phone_hidden"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="phone_hidden"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Mobile phone number will be hidden in public or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>create_from_ip</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="create_from_ip"                data-endpoint="POSTapi-posts"
               value="127.0.0.1"
               data-component="body">
    <br>
<p>The listing's author IP address. Example: <code>127.0.0.1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>accept_marketing_offers</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="accept_marketing_offers"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="accept_marketing_offers"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Accept to receive marketing offers or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>is_permanent</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="is_permanent"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="is_permanent"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Is it permanent post or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>tags</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="tags"                data-endpoint="POSTapi-posts"
               value="car,automotive,tesla,cyber,truck"
               data-component="body">
    <br>
<p>Comma-separated tags list. Example: <code>car,automotive,tesla,cyber,truck</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>package_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="package_id"                data-endpoint="POSTapi-posts"
               value="2"
               data-component="body">
    <br>
<p>The package's ID. Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>payment_method_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="payment_method_id"                data-endpoint="POSTapi-posts"
               value="5"
               data-component="body">
    <br>
<p>The payment method's ID (required when the selected package's price is &gt; 0). Example: <code>5</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-posts"
               value="ullam"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>ullam</code></p>
        </div>
        </form>

                    <h2 id="listings-PUTapi-posts--id-">Update listing</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>Note: The fields 'pictures', 'package_id' and 'payment_method_id' are only available with the single step listing edition.
The field 'admin_code' is only available when the listing's country's 'admin_type' column is set to 1 or 2.</p>

<span id="example-requests-PUTapi-posts--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request PUT \
    "https://demo.laraclassifier.local/api/posts/6" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: multipart/form-data" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --form "category_id=1"\
    --form "post_type_id=1"\
    --form "title=John Doe"\
    --form "description=Beatae placeat atque tempore consequatur animi magni omnis."\
    --form "contact_name=John Doe"\
    --form "auth_field=email"\
    --form "phone=+17656766467"\
    --form "phone_country="\
    --form "city_id=20"\
    --form "accept_terms="\
    --form "admin_code=0"\
    --form "email=john.doe@domain.tld"\
    --form "country_code=US"\
    --form "price=5000"\
    --form "negotiable="\
    --form "phone_hidden="\
    --form "latest_update_ip=127.0.0.1"\
    --form "accept_marketing_offers="\
    --form "is_permanent=1"\
    --form "tags=car,automotive,tesla,cyber,truck"\
    --form "package_id=2"\
    --form "payment_method_id=5"\
    --form "pictures[]=@/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpzZPPje" </code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/6"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "multipart/form-data",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

const body = new FormData();
body.append('category_id', '1');
body.append('post_type_id', '1');
body.append('title', 'John Doe');
body.append('description', 'Beatae placeat atque tempore consequatur animi magni omnis.');
body.append('contact_name', 'John Doe');
body.append('auth_field', 'email');
body.append('phone', '+17656766467');
body.append('phone_country', '');
body.append('city_id', '20');
body.append('accept_terms', '');
body.append('admin_code', '0');
body.append('email', 'john.doe@domain.tld');
body.append('country_code', 'US');
body.append('price', '5000');
body.append('negotiable', '');
body.append('phone_hidden', '');
body.append('latest_update_ip', '127.0.0.1');
body.append('accept_marketing_offers', '');
body.append('is_permanent', '1');
body.append('tags', 'car,automotive,tesla,cyber,truck');
body.append('package_id', '2');
body.append('payment_method_id', '5');
body.append('pictures[]', document.querySelector('input[name="pictures[]"]').files[0]);

fetch(url, {
    method: "PUT",
    headers,
    body,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/6';
$response = $client-&gt;put(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'multipart/form-data',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'multipart' =&gt; [
            [
                'name' =&gt; 'category_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'post_type_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'title',
                'contents' =&gt; 'John Doe'
            ],
            [
                'name' =&gt; 'description',
                'contents' =&gt; 'Beatae placeat atque tempore consequatur animi magni omnis.'
            ],
            [
                'name' =&gt; 'contact_name',
                'contents' =&gt; 'John Doe'
            ],
            [
                'name' =&gt; 'auth_field',
                'contents' =&gt; 'email'
            ],
            [
                'name' =&gt; 'phone',
                'contents' =&gt; '+17656766467'
            ],
            [
                'name' =&gt; 'phone_country',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'city_id',
                'contents' =&gt; '20'
            ],
            [
                'name' =&gt; 'accept_terms',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'admin_code',
                'contents' =&gt; '0'
            ],
            [
                'name' =&gt; 'email',
                'contents' =&gt; 'john.doe@domain.tld'
            ],
            [
                'name' =&gt; 'country_code',
                'contents' =&gt; 'US'
            ],
            [
                'name' =&gt; 'price',
                'contents' =&gt; '5000'
            ],
            [
                'name' =&gt; 'negotiable',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'phone_hidden',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'latest_update_ip',
                'contents' =&gt; '127.0.0.1'
            ],
            [
                'name' =&gt; 'accept_marketing_offers',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'is_permanent',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'tags',
                'contents' =&gt; 'car,automotive,tesla,cyber,truck'
            ],
            [
                'name' =&gt; 'package_id',
                'contents' =&gt; '2'
            ],
            [
                'name' =&gt; 'payment_method_id',
                'contents' =&gt; '5'
            ],
            [
                'name' =&gt; 'pictures[]',
                'contents' =&gt; fopen('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpzZPPje', 'r')
            ],
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/6'
files = {
  'category_id': (None, '1'),
  'post_type_id': (None, '1'),
  'title': (None, 'John Doe'),
  'description': (None, 'Beatae placeat atque tempore consequatur animi magni omnis.'),
  'contact_name': (None, 'John Doe'),
  'auth_field': (None, 'email'),
  'phone': (None, '+17656766467'),
  'phone_country': (None, ''),
  'city_id': (None, '20'),
  'accept_terms': (None, ''),
  'admin_code': (None, '0'),
  'email': (None, 'john.doe@domain.tld'),
  'country_code': (None, 'US'),
  'price': (None, '5000'),
  'negotiable': (None, ''),
  'phone_hidden': (None, ''),
  'latest_update_ip': (None, '127.0.0.1'),
  'accept_marketing_offers': (None, ''),
  'is_permanent': (None, '1'),
  'tags': (None, 'car,automotive,tesla,cyber,truck'),
  'package_id': (None, '2'),
  'payment_method_id': (None, '5'),
  'pictures[]': open('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpzZPPje', 'rb')}
payload = {
    "category_id": 1,
    "post_type_id": 1,
    "title": "John Doe",
    "description": "Beatae placeat atque tempore consequatur animi magni omnis.",
    "contact_name": "John Doe",
    "auth_field": "email",
    "phone": "+17656766467",
    "phone_country": null,
    "city_id": 20,
    "accept_terms": false,
    "admin_code": "0",
    "email": "john.doe@domain.tld",
    "country_code": "US",
    "price": 5000,
    "negotiable": false,
    "phone_hidden": false,
    "latest_update_ip": "127.0.0.1",
    "accept_marketing_offers": false,
    "is_permanent": true,
    "tags": "car,automotive,tesla,cyber,truck",
    "package_id": 2,
    "payment_method_id": 5
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'multipart/form-data',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('PUT', url, headers=headers, files=files)
response.json()</code></pre></div>

</span>

<span id="example-responses-PUTapi-posts--id-">
</span>
<span id="execution-results-PUTapi-posts--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-PUTapi-posts--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-PUTapi-posts--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-PUTapi-posts--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-PUTapi-posts--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-PUTapi-posts--id-" data-method="PUT"
      data-path="api/posts/{id}"
      data-authed="1"
      data-hasfiles="1"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('PUTapi-posts--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-PUTapi-posts--id-"
                    onclick="tryItOut('PUTapi-posts--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-PUTapi-posts--id-"
                    onclick="cancelTryOut('PUTapi-posts--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-PUTapi-posts--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-darkblue">PUT</small>
            <b><code>api/posts/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="PUTapi-posts--id-"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="PUTapi-posts--id-"
               value="multipart/form-data"
               data-component="header">
    <br>
<p>Example: <code>multipart/form-data</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="PUTapi-posts--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="PUTapi-posts--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="PUTapi-posts--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="PUTapi-posts--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="PUTapi-posts--id-"
               value="6"
               data-component="url">
    <br>
<p>The post/listing's ID. Example: <code>6</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>category_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="category_id"                data-endpoint="PUTapi-posts--id-"
               value="1"
               data-component="body">
    <br>
<p>The category's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_type_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_type_id"                data-endpoint="PUTapi-posts--id-"
               value="1"
               data-component="body">
    <br>
<p>The listing type's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>title</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="title"                data-endpoint="PUTapi-posts--id-"
               value="John Doe"
               data-component="body">
    <br>
<p>The listing's title. Example: <code>John Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>description</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="description"                data-endpoint="PUTapi-posts--id-"
               value="Beatae placeat atque tempore consequatur animi magni omnis."
               data-component="body">
    <br>
<p>The listing's description. Example: <code>Beatae placeat atque tempore consequatur animi magni omnis.</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>contact_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="contact_name"                data-endpoint="PUTapi-posts--id-"
               value="John Doe"
               data-component="body">
    <br>
<p>The listing's author name. Example: <code>John Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="PUTapi-posts--id-"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="PUTapi-posts--id-"
               value="+17656766467"
               data-component="body">
    <br>
<p>The listing's author mobile number (Required when 'auth_field' value is 'phone'). Example: <code>+17656766467</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="PUTapi-posts--id-"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>city_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="city_id"                data-endpoint="PUTapi-posts--id-"
               value="20"
               data-component="body">
    <br>
<p>The city's ID. Example: <code>20</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>accept_terms</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
 &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="accept_terms"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="accept_terms"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Accept the website terms and conditions. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>admin_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin_code"                data-endpoint="PUTapi-posts--id-"
               value="0"
               data-component="body">
    <br>
<p>The administrative division's code. Example: <code>0</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="PUTapi-posts--id-"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The listing's author email address (Required when 'auth_field' value is 'email'). Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_code"                data-endpoint="PUTapi-posts--id-"
               value="US"
               data-component="body">
    <br>
<p>The code of the user's country. Example: <code>US</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>price</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="price"                data-endpoint="PUTapi-posts--id-"
               value="5000"
               data-component="body">
    <br>
<p>The price. Example: <code>5000</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>negotiable</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="negotiable"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="negotiable"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Negotiable price or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_hidden</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="phone_hidden"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="phone_hidden"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Mobile phone number will be hidden in public or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>latest_update_ip</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="latest_update_ip"                data-endpoint="PUTapi-posts--id-"
               value="127.0.0.1"
               data-component="body">
    <br>
<p>The listing's author IP address. Example: <code>127.0.0.1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>accept_marketing_offers</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="accept_marketing_offers"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="accept_marketing_offers"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Accept to receive marketing offers or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>is_permanent</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="is_permanent"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="is_permanent"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Is it permanent post or no. Example: <code>true</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>tags</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="tags"                data-endpoint="PUTapi-posts--id-"
               value="car,automotive,tesla,cyber,truck"
               data-component="body">
    <br>
<p>Comma-separated tags list. Example: <code>car,automotive,tesla,cyber,truck</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>pictures</code></b>&nbsp;&nbsp;
<small>file[]</small>&nbsp;
 &nbsp;
                <input type="file" style="display: none"
                              name="pictures[0]"                data-endpoint="PUTapi-posts--id-"
               data-component="body">
        <input type="file" style="display: none"
               name="pictures[1]"                data-endpoint="PUTapi-posts--id-"
               data-component="body">
    <br>
<p>The listing's pictures.</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>package_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="package_id"                data-endpoint="PUTapi-posts--id-"
               value="2"
               data-component="body">
    <br>
<p>The package's ID. Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>payment_method_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="payment_method_id"                data-endpoint="PUTapi-posts--id-"
               value="5"
               data-component="body">
    <br>
<p>The payment method's ID (Required when the selected package's price is &gt; 0). Example: <code>5</code></p>
        </div>
        </form>

                    <h2 id="listings-DELETEapi-posts--ids-">Delete listing(s)</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-DELETEapi-posts--ids-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request DELETE \
    "https://demo.laraclassifier.local/api/posts/111111,222222,333333" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/111111,222222,333333"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "DELETE",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/111111,222222,333333';
$response = $client-&gt;delete(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/111111,222222,333333'
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('DELETE', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-DELETEapi-posts--ids-">
</span>
<span id="execution-results-DELETEapi-posts--ids-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-DELETEapi-posts--ids-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-DELETEapi-posts--ids-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-DELETEapi-posts--ids-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-DELETEapi-posts--ids-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-DELETEapi-posts--ids-" data-method="DELETE"
      data-path="api/posts/{ids}"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('DELETEapi-posts--ids-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-DELETEapi-posts--ids-"
                    onclick="tryItOut('DELETEapi-posts--ids-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-DELETEapi-posts--ids-"
                    onclick="cancelTryOut('DELETEapi-posts--ids-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-DELETEapi-posts--ids-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-red">DELETE</small>
            <b><code>api/posts/{ids}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="DELETEapi-posts--ids-"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="DELETEapi-posts--ids-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="DELETEapi-posts--ids-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="DELETEapi-posts--ids-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="DELETEapi-posts--ids-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="DELETEapi-posts--ids-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>ids</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="ids"                data-endpoint="DELETEapi-posts--ids-"
               value="111111,222222,333333"
               data-component="url">
    <br>
<p>The ID or comma-separated IDs list of listing(s). Example: <code>111111,222222,333333</code></p>
            </div>
                    </form>

                <h1 id="packages">Packages</h1>

    

                                <h2 id="packages-GETapi-packages-promotion">List packages</h2>

<p>
</p>



<span id="example-requests-GETapi-packages-promotion">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/packages/promotion?embed=&amp;sort=-lft" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/packages/promotion"
);

const params = {
    "embed": "",
    "sort": "-lft",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/packages/promotion';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'sort' =&gt; '-lft',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/packages/promotion'
params = {
  'embed': '',
  'sort': '-lft',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-packages-promotion">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 3,
                &quot;type&quot;: &quot;promotion&quot;,
                &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                &quot;short_name&quot;: &quot;Premium+&quot;,
                &quot;ribbon&quot;: &quot;green&quot;,
                &quot;has_badge&quot;: 1,
                &quot;price&quot;: &quot;9.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: 30,
                &quot;interval&quot;: null,
                &quot;listings_limit&quot;: null,
                &quot;pictures_limit&quot;: 15,
                &quot;expiration_time&quot;: 120,
                &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 0,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 6,
                &quot;rgt&quot;: 7,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-05-17T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-06-16T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;30 days of promotion&quot;,
                    &quot;Up to 15 images allowed&quot;,
                    &quot;Featured on the homepage&quot;,
                    &quot;Featured in the category&quot;,
                    &quot;Keep online for 120 days&quot;
                ],
                &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                &quot;price_formatted&quot;: &quot;$9&quot;
            },
            {
                &quot;id&quot;: 2,
                &quot;type&quot;: &quot;promotion&quot;,
                &quot;name&quot;: &quot;Premium Listing&quot;,
                &quot;short_name&quot;: &quot;Premium&quot;,
                &quot;ribbon&quot;: &quot;orange&quot;,
                &quot;has_badge&quot;: 1,
                &quot;price&quot;: &quot;7.50&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: 7,
                &quot;interval&quot;: null,
                &quot;listings_limit&quot;: null,
                &quot;pictures_limit&quot;: 10,
                &quot;expiration_time&quot;: 60,
                &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 1,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 4,
                &quot;rgt&quot;: 5,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-05-17T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-05-24T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;7 days of promotion&quot;,
                    &quot;Up to 10 images allowed&quot;,
                    &quot;Featured on the homepage&quot;,
                    &quot;Featured in the category&quot;,
                    &quot;Keep online for 60 days&quot;
                ],
                &quot;description_string&quot;: &quot;7 days of promotion. \nUp to 10 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 60 days&quot;,
                &quot;price_formatted&quot;: &quot;$7.50&quot;
            },
            {
                &quot;id&quot;: 1,
                &quot;type&quot;: &quot;promotion&quot;,
                &quot;name&quot;: &quot;Free&quot;,
                &quot;short_name&quot;: &quot;Free&quot;,
                &quot;ribbon&quot;: &quot;red&quot;,
                &quot;has_badge&quot;: 1,
                &quot;price&quot;: &quot;0.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: null,
                &quot;interval&quot;: null,
                &quot;listings_limit&quot;: null,
                &quot;pictures_limit&quot;: null,
                &quot;expiration_time&quot;: null,
                &quot;description&quot;: &quot;&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 0,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 2,
                &quot;rgt&quot;: 3,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-05-17T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-06-16T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;Up to 6 images allowed&quot;,
                    &quot;Keep online for 30 days&quot;
                ],
                &quot;description_string&quot;: &quot;Up to 6 images allowed. \nKeep online for 30 days&quot;,
                &quot;price_formatted&quot;: &quot;$0&quot;
            }
        ]
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-packages-promotion" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-packages-promotion"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-packages-promotion"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-packages-promotion" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-packages-promotion">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-packages-promotion" data-method="GET"
      data-path="api/packages/promotion"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-packages-promotion', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-packages-promotion"
                    onclick="tryItOut('GETapi-packages-promotion');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-packages-promotion"
                    onclick="cancelTryOut('GETapi-packages-promotion');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-packages-promotion"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/packages/promotion</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-packages-promotion"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-packages-promotion"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-packages-promotion"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-packages-promotion"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-packages-promotion"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-packages-promotion"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the package relationships for Eager Loading - Possible values: currency.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-packages-promotion"
               value="-lft"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: lft. Example: <code>-lft</code></p>
            </div>
                </form>

                    <h2 id="packages-GETapi-packages-subscription">List packages</h2>

<p>
</p>



<span id="example-requests-GETapi-packages-subscription">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/packages/subscription?embed=&amp;sort=-lft" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/packages/subscription"
);

const params = {
    "embed": "",
    "sort": "-lft",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/packages/subscription';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'sort' =&gt; '-lft',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/packages/subscription'
params = {
  'embed': '',
  'sort': '-lft',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-packages-subscription">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 5,
                &quot;type&quot;: &quot;subscription&quot;,
                &quot;name&quot;: &quot;Premium&quot;,
                &quot;short_name&quot;: &quot;Premium&quot;,
                &quot;ribbon&quot;: null,
                &quot;has_badge&quot;: 0,
                &quot;price&quot;: &quot;9.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: null,
                &quot;interval&quot;: &quot;month&quot;,
                &quot;listings_limit&quot;: 100,
                &quot;pictures_limit&quot;: 10,
                &quot;expiration_time&quot;: 90,
                &quot;description&quot;: &quot;&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 1,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 10,
                &quot;rgt&quot;: 11,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-05-17T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-06-17T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;Publish up to 100 listings per month&quot;,
                    &quot;Add 10 pictures per listing&quot;,
                    &quot;Keep listings online for 90 days&quot;
                ],
                &quot;description_string&quot;: &quot;Publish up to 100 listings per month. \nAdd 10 pictures per listing. \nKeep listings online for 90 days&quot;,
                &quot;price_formatted&quot;: &quot;$9&quot;
            },
            {
                &quot;id&quot;: 4,
                &quot;type&quot;: &quot;subscription&quot;,
                &quot;name&quot;: &quot;Basic&quot;,
                &quot;short_name&quot;: &quot;Basic&quot;,
                &quot;ribbon&quot;: null,
                &quot;has_badge&quot;: 0,
                &quot;price&quot;: &quot;0.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: null,
                &quot;interval&quot;: &quot;month&quot;,
                &quot;listings_limit&quot;: null,
                &quot;pictures_limit&quot;: null,
                &quot;expiration_time&quot;: null,
                &quot;description&quot;: &quot;&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 0,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 8,
                &quot;rgt&quot;: 9,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-05-17T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-06-17T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;Up to 50 listings allowed&quot;,
                    &quot;Add 6 pictures per listing&quot;,
                    &quot;Keep listings online for 30 days&quot;
                ],
                &quot;description_string&quot;: &quot;Up to 50 listings allowed. \nAdd 6 pictures per listing. \nKeep listings online for 30 days&quot;,
                &quot;price_formatted&quot;: &quot;$0&quot;
            }
        ]
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-packages-subscription" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-packages-subscription"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-packages-subscription"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-packages-subscription" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-packages-subscription">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-packages-subscription" data-method="GET"
      data-path="api/packages/subscription"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-packages-subscription', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-packages-subscription"
                    onclick="tryItOut('GETapi-packages-subscription');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-packages-subscription"
                    onclick="cancelTryOut('GETapi-packages-subscription');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-packages-subscription"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/packages/subscription</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-packages-subscription"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-packages-subscription"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-packages-subscription"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-packages-subscription"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-packages-subscription"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-packages-subscription"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the package relationships for Eager Loading - Possible values: currency.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-packages-subscription"
               value="-lft"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: lft. Example: <code>-lft</code></p>
            </div>
                </form>

                    <h2 id="packages-GETapi-packages--id-">Get package</h2>

<p>
</p>



<span id="example-requests-GETapi-packages--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/packages/2?embed=currency" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/packages/2"
);

const params = {
    "embed": "currency",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/packages/2';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; 'currency',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/packages/2'
params = {
  'embed': 'currency',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-packages--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 2,
        &quot;type&quot;: &quot;promotion&quot;,
        &quot;name&quot;: &quot;Premium Listing&quot;,
        &quot;short_name&quot;: &quot;Premium&quot;,
        &quot;ribbon&quot;: &quot;orange&quot;,
        &quot;has_badge&quot;: 1,
        &quot;price&quot;: &quot;7.50&quot;,
        &quot;currency_code&quot;: &quot;USD&quot;,
        &quot;promotion_time&quot;: 7,
        &quot;interval&quot;: null,
        &quot;listings_limit&quot;: null,
        &quot;pictures_limit&quot;: 10,
        &quot;expiration_time&quot;: 60,
        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
        &quot;facebook_ads_duration&quot;: 0,
        &quot;google_ads_duration&quot;: 0,
        &quot;twitter_ads_duration&quot;: 0,
        &quot;linkedin_ads_duration&quot;: 0,
        &quot;recommended&quot;: 1,
        &quot;active&quot;: 1,
        &quot;parent_id&quot;: null,
        &quot;lft&quot;: 4,
        &quot;rgt&quot;: 5,
        &quot;depth&quot;: 0,
        &quot;period_start&quot;: &quot;2025-05-17T00:00:00.000000Z&quot;,
        &quot;period_end&quot;: &quot;2025-05-24T23:59:59.999999Z&quot;,
        &quot;description_array&quot;: [
            &quot;7 days of promotion&quot;,
            &quot;Up to 10 images allowed&quot;,
            &quot;Featured on the homepage&quot;,
            &quot;Featured in the category&quot;,
            &quot;Keep online for 60 days&quot;
        ],
        &quot;description_string&quot;: &quot;7 days of promotion. \nUp to 10 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 60 days&quot;,
        &quot;price_formatted&quot;: &quot;$7.50&quot;,
        &quot;currency&quot;: {
            &quot;code&quot;: &quot;USD&quot;,
            &quot;name&quot;: &quot;United States Dollar&quot;,
            &quot;symbol&quot;: &quot;$&quot;,
            &quot;html_entities&quot;: &quot;&amp;#36;&quot;,
            &quot;in_left&quot;: 1,
            &quot;decimal_places&quot;: 2,
            &quot;decimal_separator&quot;: &quot;.&quot;,
            &quot;thousand_separator&quot;: &quot;,&quot;
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-packages--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-packages--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-packages--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-packages--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-packages--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-packages--id-" data-method="GET"
      data-path="api/packages/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-packages--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-packages--id-"
                    onclick="tryItOut('GETapi-packages--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-packages--id-"
                    onclick="cancelTryOut('GETapi-packages--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-packages--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/packages/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-packages--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-packages--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-packages--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-packages--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-packages--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-packages--id-"
               value="2"
               data-component="url">
    <br>
<p>The package's ID. Example: <code>2</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-packages--id-"
               value="currency"
               data-component="query">
    <br>
<p>Comma-separated list of the package relationships for Eager Loading - Possible values: currency. Example: <code>currency</code></p>
            </div>
                </form>

                <h1 id="pages">Pages</h1>

    

                                <h2 id="pages-GETapi-pages">List pages</h2>

<p>
</p>



<span id="example-requests-GETapi-pages">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/pages?excludedFromFooter=&amp;sort=-lft&amp;perPage=2" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/pages"
);

const params = {
    "excludedFromFooter": "0",
    "sort": "-lft",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/pages';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'excludedFromFooter' =&gt; '0',
            'sort' =&gt; '-lft',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/pages'
params = {
  'excludedFromFooter': '0',
  'sort': '-lft',
  'perPage': '2',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-pages">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 4,
                &quot;parent_id&quot;: null,
                &quot;type&quot;: &quot;standard&quot;,
                &quot;name&quot;: &quot;FAQ&quot;,
                &quot;slug&quot;: &quot;faq&quot;,
                &quot;image_path&quot;: null,
                &quot;title&quot;: &quot;Frequently Asked Questions&quot;,
                &quot;content&quot;: &quot;&lt;p&gt;&lt;b&gt;How do I place an ad?&lt;/b&gt;&lt;/p&gt;&lt;p&gt;It&#039;s very easy to place an ad: click on the button \&quot;Post free Ads\&quot; above right.&lt;/p&gt;&lt;p&gt;&lt;b&gt;What does it cost to advertise?&lt;/b&gt;&lt;/p&gt;&lt;p&gt;The publication is 100% free throughout the website.&lt;/p&gt;&lt;p&gt;&lt;b&gt;If I post an listing, will I also get more spam e-mails?&lt;/b&gt;&lt;/p&gt;&lt;p&gt;Absolutely not because your email address is not visible on the website.&lt;/p&gt;&lt;p&gt;&lt;b&gt;How long will my listing remain on the website?&lt;/b&gt;&lt;/p&gt;&lt;p&gt;In general, an listing is automatically deactivated from the website after 3 months. You will receive an email a week before D-Day and another on the day of deactivation. You have the ability to put them online in the following month by logging into your account on the site. After this delay, your listing will be automatically removed permanently from the website.&lt;/p&gt;&lt;p&gt;&lt;b&gt;I sold my item. How do I delete my ad?&lt;/b&gt;&lt;/p&gt;&lt;p&gt;Once your product is sold or leased, log in to your account to remove your listing.&lt;/p&gt;&quot;,
                &quot;external_link&quot;: null,
                &quot;name_color&quot;: null,
                &quot;title_color&quot;: null,
                &quot;target_blank&quot;: 0,
                &quot;seo_title&quot;: &quot;&quot;,
                &quot;seo_description&quot;: &quot;&quot;,
                &quot;seo_keywords&quot;: &quot;&quot;,
                &quot;excluded_from_footer&quot;: 0,
                &quot;active&quot;: 1,
                &quot;lft&quot;: 2,
                &quot;rgt&quot;: 3,
                &quot;depth&quot;: 1,
                &quot;image_url&quot;: null
            },
            {
                &quot;id&quot;: 3,
                &quot;parent_id&quot;: null,
                &quot;type&quot;: &quot;standard&quot;,
                &quot;name&quot;: &quot;Anti-Scam&quot;,
                &quot;slug&quot;: &quot;anti-scam&quot;,
                &quot;image_path&quot;: null,
                &quot;title&quot;: &quot;Anti-Scam&quot;,
                &quot;content&quot;: &quot;&lt;p&gt;&lt;b&gt;Protect yourself against Internet fraud!&lt;/b&gt;&lt;/p&gt;&lt;p&gt;The vast majority of listings are posted by honest people and trust. So you can do excellent business. Despite this, it is important to follow a few common sense rules following to prevent any attempt to scam.&lt;/p&gt;&lt;p&gt;&lt;b&gt;Our advices&lt;/b&gt;&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Doing business with people you can meet in person.&lt;/li&gt;&lt;li&gt;Never send money by Western Union, MoneyGram or other anonymous payment systems.&lt;/li&gt;&lt;li&gt;Never send money or products abroad.&lt;/li&gt;&lt;li&gt;Do not accept checks.&lt;/li&gt;&lt;li&gt;Ask about the person you&#039;re dealing with another confirming source name, address and telephone number.&lt;/li&gt;&lt;li&gt;Keep copies of all correspondence (emails, listings, letters, etc.) and details of the person.&lt;/li&gt;&lt;li&gt;If a deal seems too good to be true, there is every chance that this is the case. Refrain.&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;b&gt;Recognize attempted scam&lt;/b&gt;&lt;/p&gt;&lt;ul&gt;&lt;li&gt;The majority of scams have one or more of these characteristics:&lt;/li&gt;&lt;li&gt;The person is abroad or traveling abroad.&lt;/li&gt;&lt;li&gt;The person refuses to meet you in person.&lt;/li&gt;&lt;li&gt;Payment is made through Western Union, Money Gram or check.&lt;/li&gt;&lt;li&gt;The messages are in broken language (English or French or ...).&lt;/li&gt;&lt;li&gt;The texts seem to be copied and pasted.&lt;/li&gt;&lt;li&gt;The deal seems to be too good to be true.&lt;/li&gt;&lt;/ul&gt;&quot;,
                &quot;external_link&quot;: null,
                &quot;name_color&quot;: null,
                &quot;title_color&quot;: null,
                &quot;target_blank&quot;: 0,
                &quot;seo_title&quot;: &quot;&quot;,
                &quot;seo_description&quot;: &quot;&quot;,
                &quot;seo_keywords&quot;: &quot;&quot;,
                &quot;excluded_from_footer&quot;: 0,
                &quot;active&quot;: 1,
                &quot;lft&quot;: 4,
                &quot;rgt&quot;: 5,
                &quot;depth&quot;: 1,
                &quot;image_url&quot;: null
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/pages?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/pages?page=2&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/pages?page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 2,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/pages?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/pages?page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/pages?page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/pages&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 4
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-pages" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-pages"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-pages"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-pages" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-pages">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-pages" data-method="GET"
      data-path="api/pages"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-pages', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-pages"
                    onclick="tryItOut('GETapi-pages');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-pages"
                    onclick="cancelTryOut('GETapi-pages');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-pages"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/pages</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-pages"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-pages"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-pages"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-pages"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-pages"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>excludedFromFooter</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-pages" style="display: none">
            <input type="radio" name="excludedFromFooter"
                   value="1"
                   data-endpoint="GETapi-pages"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-pages" style="display: none">
            <input type="radio" name="excludedFromFooter"
                   value="0"
                   data-endpoint="GETapi-pages"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Select or unselect pages that can list in footer. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-pages"
               value="-lft"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: lft, created_at. Example: <code>-lft</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-pages"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                    <h2 id="pages-GETapi-pages--slugOrId-">Get page</h2>

<p>
</p>



<span id="example-requests-GETapi-pages--slugOrId-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/pages/terms" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/pages/terms"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/pages/terms';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/pages/terms'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-pages--slugOrId-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 1,
        &quot;parent_id&quot;: null,
        &quot;type&quot;: &quot;terms&quot;,
        &quot;name&quot;: &quot;Terms&quot;,
        &quot;slug&quot;: &quot;terms&quot;,
        &quot;image_path&quot;: null,
        &quot;title&quot;: &quot;Terms &amp; Conditions&quot;,
        &quot;content&quot;: &quot;&lt;h4&gt;&lt;b&gt;Definitions&lt;/b&gt;&lt;/h4&gt;&lt;p&gt;Each of the terms mentioned below have in these Conditions of Sale LaraClassifier Service (hereinafter the \&quot;Conditions\&quot;) the following meanings:&lt;/p&gt;&lt;ol&gt;&lt;li&gt;Announcement&amp;nbsp;: refers to all the elements and data (visual, textual, sound, photographs, drawings), presented by an Advertiser editorial under his sole responsibility, in order to buy, rent or sell a product or service and broadcast on the Website and Mobile Site.&lt;/li&gt;&lt;li&gt;Advertiser&amp;nbsp;: means any natural or legal person, a major, established in France, holds an account and having submitted an announcement, from it, on the Website. Any Advertiser must be connected to the Personal Account for deposit and or manage its listings. Add first deposit automatically entails the establishment of a Personal Account to the Advertiser.&lt;/li&gt;&lt;li&gt;Personal Account&amp;nbsp;: refers to the free space than any Advertiser must create and which it should connect from the Website to disseminate, manage and view its listings.&lt;/li&gt;&lt;li&gt;LaraClassifier&amp;nbsp;: means the company that publishes and operates the Website and Mobile Site {YourCompany}, registered at the Trade and Companies Register of {YourCity} under the number {YourCompany Registration Number} whose registered office is at {YourCompany Address}.&lt;/li&gt;&lt;li&gt;Customer Service&amp;nbsp;: LaraClassifier means the department to which the Advertiser may obtain further information. This service can be contacted via email by clicking the link on the Website and Mobile Site.&lt;/li&gt;&lt;li&gt;LaraClassifier Service&amp;nbsp;: LaraClassifier means the services made available to Users and Advertisers on the Website and Mobile Site.&lt;/li&gt;&lt;li&gt;Website&amp;nbsp;: means the website operated by LaraClassifier accessed mainly from the URL &lt;a href=\&quot;https://laraclassifier.com\&quot;&gt;https://laraclassifier.com&lt;/a&gt; and allowing Users and Advertisers to access the Service via internet LaraClassifier.&lt;/li&gt;&lt;li&gt;Mobile Site&amp;nbsp;: is the mobile site operated by LaraClassifier accessible from the URL &lt;a href=\&quot;https://laraclassifier.com\&quot;&gt;https://laraclassifier.com&lt;/a&gt; and allowing Users and Advertisers to access via their mobile phone service {YourSiteName}.&lt;/li&gt;&lt;li&gt;User&amp;nbsp;: any visitor with access to LaraClassifier Service via the Website and Mobile Site and Consultant Service LaraClassifier accessible from different media.&lt;/li&gt;&lt;/ol&gt;&lt;h4&gt;&lt;b&gt;Subject&lt;/b&gt;&lt;/h4&gt;&lt;p&gt;These Terms and Conditions Of Use establish the contractual conditions applicable to any subscription by an Advertiser connected to its Personal Account from the Website and Mobile Site.&lt;br&gt;&lt;/p&gt;&lt;h4&gt;&lt;b&gt;Acceptance&lt;/b&gt;&lt;/h4&gt;&lt;p&gt;Any use of the website by an Advertiser is full acceptance of the current Terms.&lt;br&gt;&lt;/p&gt;&lt;h4&gt;&lt;b&gt;Responsibility&lt;/b&gt;&lt;/h4&gt;&lt;p&gt;Responsibility for LaraClassifier can not be held liable for non-performance or improper performance of due control, either because of the Advertiser, or a case of major force.&lt;br&gt;&lt;/p&gt;&lt;h4&gt;&lt;b&gt;Modification of these terms&lt;/b&gt;&lt;/h4&gt;&lt;p&gt;LaraClassifier reserves the right, at any time, to modify all or part of the Terms and Conditions.&lt;/p&gt;&lt;p&gt;Advertisers are advised to consult the Terms to be aware of the changes.&lt;/p&gt;&lt;h4&gt;&lt;b&gt;Miscellaneous&lt;/b&gt;&lt;/h4&gt;&lt;p&gt;If part of the Terms should be illegal, invalid or unenforceable for any reason whatsoever, the provisions in question would be deemed unwritten, without questioning the validity of the remaining provisions will continue to apply between Advertisers and LaraClassifier.&lt;/p&gt;&lt;p&gt;Any complaints should be addressed to Customer Service LaraClassifier.&lt;/p&gt;&quot;,
        &quot;external_link&quot;: null,
        &quot;name_color&quot;: null,
        &quot;title_color&quot;: null,
        &quot;target_blank&quot;: 0,
        &quot;seo_title&quot;: &quot;&quot;,
        &quot;seo_description&quot;: &quot;&quot;,
        &quot;seo_keywords&quot;: &quot;&quot;,
        &quot;excluded_from_footer&quot;: 0,
        &quot;active&quot;: 1,
        &quot;lft&quot;: 6,
        &quot;rgt&quot;: 7,
        &quot;depth&quot;: 1,
        &quot;image_url&quot;: null
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-pages--slugOrId-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-pages--slugOrId-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-pages--slugOrId-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-pages--slugOrId-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-pages--slugOrId-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-pages--slugOrId-" data-method="GET"
      data-path="api/pages/{slugOrId}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-pages--slugOrId-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-pages--slugOrId-"
                    onclick="tryItOut('GETapi-pages--slugOrId-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-pages--slugOrId-"
                    onclick="cancelTryOut('GETapi-pages--slugOrId-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-pages--slugOrId-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/pages/{slugOrId}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-pages--slugOrId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-pages--slugOrId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-pages--slugOrId-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-pages--slugOrId-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-pages--slugOrId-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>slugOrId</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="slugOrId"                data-endpoint="GETapi-pages--slugOrId-"
               value="terms"
               data-component="url">
    <br>
<p>The slug or ID of the page. Example: <code>terms</code></p>
            </div>
                    </form>

                <h1 id="payment-methods">Payment Methods</h1>

    

                                <h2 id="payment-methods-GETapi-paymentMethods">List payment methods</h2>

<p>
</p>



<span id="example-requests-GETapi-paymentMethods">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/paymentMethods?countryCode=US&amp;sort=-lft" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/paymentMethods"
);

const params = {
    "countryCode": "US",
    "sort": "-lft",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/paymentMethods';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'countryCode' =&gt; 'US',
            'sort' =&gt; '-lft',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/paymentMethods'
params = {
  'countryCode': 'US',
  'sort': '-lft',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-paymentMethods">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: &quot;No payment methods found&quot;,
    &quot;result&quot;: {
        &quot;data&quot;: []
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-paymentMethods" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-paymentMethods"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-paymentMethods"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-paymentMethods" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-paymentMethods">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-paymentMethods" data-method="GET"
      data-path="api/paymentMethods"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-paymentMethods', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-paymentMethods"
                    onclick="tryItOut('GETapi-paymentMethods');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-paymentMethods"
                    onclick="cancelTryOut('GETapi-paymentMethods');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-paymentMethods"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/paymentMethods</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-paymentMethods"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-paymentMethods"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-paymentMethods"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-paymentMethods"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-paymentMethods"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-paymentMethods"
               value="US"
               data-component="query">
    <br>
<p>Country code. Select only the payment methods related to a country. Example: <code>US</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-paymentMethods"
               value="-lft"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: lft. Example: <code>-lft</code></p>
            </div>
                </form>

                    <h2 id="payment-methods-GETapi-paymentMethods--id-">Get payment method</h2>

<p>
</p>



<span id="example-requests-GETapi-paymentMethods--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/paymentMethods/1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/paymentMethods/1"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/paymentMethods/1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/paymentMethods/1'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-paymentMethods--id-">
            <blockquote>
            <p>Example response (404):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;Payment method not found&quot;,
    &quot;result&quot;: null,
    &quot;error&quot;: &quot;Payment method not found&quot;
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-paymentMethods--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-paymentMethods--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-paymentMethods--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-paymentMethods--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-paymentMethods--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-paymentMethods--id-" data-method="GET"
      data-path="api/paymentMethods/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-paymentMethods--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-paymentMethods--id-"
                    onclick="tryItOut('GETapi-paymentMethods--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-paymentMethods--id-"
                    onclick="cancelTryOut('GETapi-paymentMethods--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-paymentMethods--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/paymentMethods/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-paymentMethods--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-paymentMethods--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-paymentMethods--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-paymentMethods--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-paymentMethods--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-paymentMethods--id-"
               value="1"
               data-component="url">
    <br>
<p>Can be the ID (int) or name (string) of the payment method. Example: <code>1</code></p>
            </div>
                    </form>

                <h1 id="payments">Payments</h1>

    

                                <h2 id="payments-GETapi-payments-promotion">List payments</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-GETapi-payments-promotion">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/payments/promotion?embed=&amp;valid=&amp;active=&amp;sort=created_at&amp;perPage=2" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/payments/promotion"
);

const params = {
    "embed": "",
    "valid": "0",
    "active": "0",
    "sort": "created_at",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/payments/promotion';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'valid' =&gt; '0',
            'active' =&gt; '0',
            'sort' =&gt; 'created_at',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/payments/promotion'
params = {
  'embed': '',
  'valid': '0',
  'active': '0',
  'sort': 'created_at',
  'perPage': '2',
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-payments-promotion">
            <blockquote>
            <p>Example response (401):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;Unauthenticated or Token Expired, Please Login.&quot;,
    &quot;result&quot;: null,
    &quot;error&quot;: &quot;Unauthenticated or Token Expired, Please Login.&quot;
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-payments-promotion" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-payments-promotion"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-payments-promotion"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-payments-promotion" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-payments-promotion">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-payments-promotion" data-method="GET"
      data-path="api/payments/promotion"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-payments-promotion', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-payments-promotion"
                    onclick="tryItOut('GETapi-payments-promotion');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-payments-promotion"
                    onclick="cancelTryOut('GETapi-payments-promotion');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-payments-promotion"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/payments/promotion</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="GETapi-payments-promotion"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-payments-promotion"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-payments-promotion"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-payments-promotion"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-payments-promotion"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-payments-promotion"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-payments-promotion"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the payment relationships for Eager Loading - Possible values: payable,paymentMethod,package,currency.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>valid</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-payments-promotion" style="display: none">
            <input type="radio" name="valid"
                   value="1"
                   data-endpoint="GETapi-payments-promotion"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-payments-promotion" style="display: none">
            <input type="radio" name="valid"
                   value="0"
                   data-endpoint="GETapi-payments-promotion"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the valid payment list. Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>active</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-payments-promotion" style="display: none">
            <input type="radio" name="active"
                   value="1"
                   data-endpoint="GETapi-payments-promotion"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-payments-promotion" style="display: none">
            <input type="radio" name="active"
                   value="0"
                   data-endpoint="GETapi-payments-promotion"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the active payment list. Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-payments-promotion"
               value="created_at"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: created_at. Example: <code>created_at</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-payments-promotion"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                    <h2 id="payments-GETapi-payments-subscription">List payments</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-GETapi-payments-subscription">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/payments/subscription?embed=&amp;valid=&amp;active=&amp;sort=created_at&amp;perPage=2" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/payments/subscription"
);

const params = {
    "embed": "",
    "valid": "0",
    "active": "0",
    "sort": "created_at",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/payments/subscription';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'valid' =&gt; '0',
            'active' =&gt; '0',
            'sort' =&gt; 'created_at',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/payments/subscription'
params = {
  'embed': '',
  'valid': '0',
  'active': '0',
  'sort': 'created_at',
  'perPage': '2',
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-payments-subscription">
            <blockquote>
            <p>Example response (401):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;Unauthenticated or Token Expired, Please Login.&quot;,
    &quot;result&quot;: null,
    &quot;error&quot;: &quot;Unauthenticated or Token Expired, Please Login.&quot;
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-payments-subscription" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-payments-subscription"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-payments-subscription"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-payments-subscription" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-payments-subscription">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-payments-subscription" data-method="GET"
      data-path="api/payments/subscription"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-payments-subscription', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-payments-subscription"
                    onclick="tryItOut('GETapi-payments-subscription');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-payments-subscription"
                    onclick="cancelTryOut('GETapi-payments-subscription');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-payments-subscription"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/payments/subscription</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="GETapi-payments-subscription"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-payments-subscription"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-payments-subscription"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-payments-subscription"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-payments-subscription"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-payments-subscription"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-payments-subscription"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the payment relationships for Eager Loading - Possible values: payable,paymentMethod,package,currency.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>valid</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-payments-subscription" style="display: none">
            <input type="radio" name="valid"
                   value="1"
                   data-endpoint="GETapi-payments-subscription"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-payments-subscription" style="display: none">
            <input type="radio" name="valid"
                   value="0"
                   data-endpoint="GETapi-payments-subscription"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the valid payment list. Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>active</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-payments-subscription" style="display: none">
            <input type="radio" name="active"
                   value="1"
                   data-endpoint="GETapi-payments-subscription"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-payments-subscription" style="display: none">
            <input type="radio" name="active"
                   value="0"
                   data-endpoint="GETapi-payments-subscription"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the active payment list. Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-payments-subscription"
               value="created_at"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: created_at. Example: <code>created_at</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-payments-subscription"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                    <h2 id="payments-GETapi-payments-subscription-users--userId--payments">List payments</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-GETapi-payments-subscription-users--userId--payments">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/payments/subscription/users/1/payments?embed=&amp;valid=&amp;active=&amp;sort=created_at&amp;perPage=2" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/payments/subscription/users/1/payments"
);

const params = {
    "embed": "",
    "valid": "0",
    "active": "0",
    "sort": "created_at",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/payments/subscription/users/1/payments';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'valid' =&gt; '0',
            'active' =&gt; '0',
            'sort' =&gt; 'created_at',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/payments/subscription/users/1/payments'
params = {
  'embed': '',
  'valid': '0',
  'active': '0',
  'sort': 'created_at',
  'perPage': '2',
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-payments-subscription-users--userId--payments">
            <blockquote>
            <p>Example response (401):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;Unauthenticated or Token Expired, Please Login.&quot;,
    &quot;result&quot;: null,
    &quot;error&quot;: &quot;Unauthenticated or Token Expired, Please Login.&quot;
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-payments-subscription-users--userId--payments" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-payments-subscription-users--userId--payments"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-payments-subscription-users--userId--payments"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-payments-subscription-users--userId--payments" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-payments-subscription-users--userId--payments">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-payments-subscription-users--userId--payments" data-method="GET"
      data-path="api/payments/subscription/users/{userId}/payments"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-payments-subscription-users--userId--payments', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-payments-subscription-users--userId--payments"
                    onclick="tryItOut('GETapi-payments-subscription-users--userId--payments');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-payments-subscription-users--userId--payments"
                    onclick="cancelTryOut('GETapi-payments-subscription-users--userId--payments');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-payments-subscription-users--userId--payments"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/payments/subscription/users/{userId}/payments</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>userId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="userId"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="1"
               data-component="url">
    <br>
<p>Example: <code>1</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the payment relationships for Eager Loading - Possible values: payable,paymentMethod,package,currency.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>valid</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-payments-subscription-users--userId--payments" style="display: none">
            <input type="radio" name="valid"
                   value="1"
                   data-endpoint="GETapi-payments-subscription-users--userId--payments"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-payments-subscription-users--userId--payments" style="display: none">
            <input type="radio" name="valid"
                   value="0"
                   data-endpoint="GETapi-payments-subscription-users--userId--payments"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the valid payment list. Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>active</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-payments-subscription-users--userId--payments" style="display: none">
            <input type="radio" name="active"
                   value="1"
                   data-endpoint="GETapi-payments-subscription-users--userId--payments"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-payments-subscription-users--userId--payments" style="display: none">
            <input type="radio" name="active"
                   value="0"
                   data-endpoint="GETapi-payments-subscription-users--userId--payments"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the active payment list. Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="created_at"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: created_at. Example: <code>created_at</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-payments-subscription-users--userId--payments"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                    <h2 id="payments-GETapi-payments--id-">Get payment</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-GETapi-payments--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/payments/2?embed=" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/payments/2"
);

const params = {
    "embed": "",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/payments/2';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/payments/2'
params = {
  'embed': '',
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-payments--id-">
            <blockquote>
            <p>Example response (401):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;Unauthenticated or Token Expired, Please Login.&quot;,
    &quot;result&quot;: null,
    &quot;error&quot;: &quot;Unauthenticated or Token Expired, Please Login.&quot;
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-payments--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-payments--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-payments--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-payments--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-payments--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-payments--id-" data-method="GET"
      data-path="api/payments/{id}"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-payments--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-payments--id-"
                    onclick="tryItOut('GETapi-payments--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-payments--id-"
                    onclick="cancelTryOut('GETapi-payments--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-payments--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/payments/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="GETapi-payments--id-"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-payments--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-payments--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-payments--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-payments--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-payments--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-payments--id-"
               value="2"
               data-component="url">
    <br>
<p>The payment's ID. Example: <code>2</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-payments--id-"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the payment relationships for Eager Loading - Possible values: payable,paymentMethod,package,currency.</p>
            </div>
                </form>

                    <h2 id="payments-POSTapi-payments">Store payment</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>Note: This endpoint is only available for the multi steps form edition.</p>

<span id="example-requests-POSTapi-payments">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/payments?package=19" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"country_code\": \"US\",
    \"payable_id\": 2,
    \"payable_type\": \"Post\",
    \"package_id\": 17,
    \"payment_method_id\": 5
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/payments"
);

const params = {
    "package": "19",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "country_code": "US",
    "payable_id": 2,
    "payable_type": "Post",
    "package_id": 17,
    "payment_method_id": 5
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/payments';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'package' =&gt; '19',
        ],
        'json' =&gt; [
            'country_code' =&gt; 'US',
            'payable_id' =&gt; 2,
            'payable_type' =&gt; 'Post',
            'package_id' =&gt; 17,
            'payment_method_id' =&gt; 5,
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/payments'
payload = {
    "country_code": "US",
    "payable_id": 2,
    "payable_type": "Post",
    "package_id": 17,
    "payment_method_id": 5
}
params = {
  'package': '19',
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-payments">
</span>
<span id="execution-results-POSTapi-payments" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-payments"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-payments"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-payments" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-payments">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-payments" data-method="POST"
      data-path="api/payments"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-payments', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-payments"
                    onclick="tryItOut('POSTapi-payments');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-payments"
                    onclick="cancelTryOut('POSTapi-payments');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-payments"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/payments</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="POSTapi-payments"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-payments"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-payments"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-payments"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-payments"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-payments"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>package</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="package"                data-endpoint="POSTapi-payments"
               value="19"
               data-component="query">
    <br>
<p>Selected package ID. Example: <code>19</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_code"                data-endpoint="POSTapi-payments"
               value="US"
               data-component="body">
    <br>
<p>The code of the user's country. Example: <code>US</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>payable_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="payable_id"                data-endpoint="POSTapi-payments"
               value="2"
               data-component="body">
    <br>
<p>The payable's ID (ID of the listing or user). Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>payable_type</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="payable_type"                data-endpoint="POSTapi-payments"
               value="Post"
               data-component="body">
    <br>
<p>The payable model's name - Possible values: Post,User. Example: <code>Post</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>package_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="package_id"                data-endpoint="POSTapi-payments"
               value="17"
               data-component="body">
    <br>
<p>The package's ID (Auto filled when the query parameter 'package' is set). Example: <code>17</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>payment_method_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="payment_method_id"                data-endpoint="POSTapi-payments"
               value="5"
               data-component="body">
    <br>
<p>The payment method's ID (required when the selected package's price is &gt; 0). Example: <code>5</code></p>
        </div>
        </form>

                <h1 id="pictures">Pictures</h1>

    

                                <h2 id="pictures-GETapi-pictures--id-">Get picture</h2>

<p>
</p>



<span id="example-requests-GETapi-pictures--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/pictures/298?embed=" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/pictures/298"
);

const params = {
    "embed": "",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/pictures/298';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/pictures/298'
params = {
  'embed': '',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-pictures--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 298,
        &quot;post_id&quot;: 137,
        &quot;file_path&quot;: &quot;files/es/137/580f9baed5841264cffd415d51e56ad0.jpg&quot;,
        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
        &quot;position&quot;: 2,
        &quot;active&quot;: 1,
        &quot;url&quot;: {
            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-pictures--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-pictures--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-pictures--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-pictures--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-pictures--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-pictures--id-" data-method="GET"
      data-path="api/pictures/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-pictures--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-pictures--id-"
                    onclick="tryItOut('GETapi-pictures--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-pictures--id-"
                    onclick="cancelTryOut('GETapi-pictures--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-pictures--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/pictures/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-pictures--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-pictures--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-pictures--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-pictures--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-pictures--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-pictures--id-"
               value="298"
               data-component="url">
    <br>
<p>The picture's ID. Example: <code>298</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-pictures--id-"
               value=""
               data-component="query">
    <br>
<p>The list of the picture relationships separated by comma for Eager Loading.</p>
            </div>
                </form>

                    <h2 id="pictures-POSTapi-pictures">Store picture</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>Note: This endpoint is only available for the multi steps post edition.</p>

<span id="example-requests-POSTapi-pictures">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/pictures" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: multipart/form-data" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --form "country_code=US"\
    --form "count_packages=3"\
    --form "count_payment_methods=1"\
    --form "post_id=2"\
    --form "pictures[]=@/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/php5lfAq3" </code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/pictures"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "multipart/form-data",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

const body = new FormData();
body.append('country_code', 'US');
body.append('count_packages', '3');
body.append('count_payment_methods', '1');
body.append('post_id', '2');
body.append('pictures[]', document.querySelector('input[name="pictures[]"]').files[0]);

fetch(url, {
    method: "POST",
    headers,
    body,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/pictures';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'multipart/form-data',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'multipart' =&gt; [
            [
                'name' =&gt; 'country_code',
                'contents' =&gt; 'US'
            ],
            [
                'name' =&gt; 'count_packages',
                'contents' =&gt; '3'
            ],
            [
                'name' =&gt; 'count_payment_methods',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'post_id',
                'contents' =&gt; '2'
            ],
            [
                'name' =&gt; 'pictures[]',
                'contents' =&gt; fopen('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/php5lfAq3', 'r')
            ],
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/pictures'
files = {
  'country_code': (None, 'US'),
  'count_packages': (None, '3'),
  'count_payment_methods': (None, '1'),
  'post_id': (None, '2'),
  'pictures[]': open('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/php5lfAq3', 'rb')}
payload = {
    "country_code": "US",
    "count_packages": 3,
    "count_payment_methods": 1,
    "post_id": 2
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'multipart/form-data',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, files=files)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-pictures">
</span>
<span id="execution-results-POSTapi-pictures" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-pictures"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-pictures"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-pictures" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-pictures">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-pictures" data-method="POST"
      data-path="api/pictures"
      data-authed="1"
      data-hasfiles="1"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-pictures', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-pictures"
                    onclick="tryItOut('POSTapi-pictures');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-pictures"
                    onclick="cancelTryOut('POSTapi-pictures');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-pictures"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/pictures</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="POSTapi-pictures"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-pictures"
               value="multipart/form-data"
               data-component="header">
    <br>
<p>Example: <code>multipart/form-data</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-pictures"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-pictures"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-pictures"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-pictures"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_code"                data-endpoint="POSTapi-pictures"
               value="US"
               data-component="body">
    <br>
<p>The code of the user's country. Example: <code>US</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>count_packages</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="count_packages"                data-endpoint="POSTapi-pictures"
               value="3"
               data-component="body">
    <br>
<p>The number of available packages. Example: <code>3</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>count_payment_methods</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="count_payment_methods"                data-endpoint="POSTapi-pictures"
               value="1"
               data-component="body">
    <br>
<p>The number of available payment methods. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_id"                data-endpoint="POSTapi-pictures"
               value="2"
               data-component="body">
    <br>
<p>The post's ID. Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>pictures</code></b>&nbsp;&nbsp;
<small>file[]</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="file" style="display: none"
                              name="pictures[0]"                data-endpoint="POSTapi-pictures"
               data-component="body">
        <input type="file" style="display: none"
               name="pictures[1]"                data-endpoint="POSTapi-pictures"
               data-component="body">
    <br>
<p>The files to upload.</p>
        </div>
        </form>

                    <h2 id="pictures-DELETEapi-pictures--id-">Delete picture</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>Note: This endpoint is only available for the multi steps form edition.
For newly created listings, the post's ID needs to be added in the request input with the key 'new_post_id'.
The 'new_post_id' and 'new_post_tmp_token' fields need to be removed or unset during the listing edition steps.</p>

<span id="example-requests-DELETEapi-pictures--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request DELETE \
    "https://demo.laraclassifier.local/api/pictures/999999999" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"post_id\": 2
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/pictures/999999999"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "post_id": 2
};

fetch(url, {
    method: "DELETE",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/pictures/999999999';
$response = $client-&gt;delete(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'post_id' =&gt; 2,
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/pictures/999999999'
payload = {
    "post_id": 2
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('DELETE', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-DELETEapi-pictures--id-">
</span>
<span id="execution-results-DELETEapi-pictures--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-DELETEapi-pictures--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-DELETEapi-pictures--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-DELETEapi-pictures--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-DELETEapi-pictures--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-DELETEapi-pictures--id-" data-method="DELETE"
      data-path="api/pictures/{id}"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('DELETEapi-pictures--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-DELETEapi-pictures--id-"
                    onclick="tryItOut('DELETEapi-pictures--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-DELETEapi-pictures--id-"
                    onclick="cancelTryOut('DELETEapi-pictures--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-DELETEapi-pictures--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-red">DELETE</small>
            <b><code>api/pictures/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="DELETEapi-pictures--id-"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="DELETEapi-pictures--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="DELETEapi-pictures--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="DELETEapi-pictures--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="DELETEapi-pictures--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="DELETEapi-pictures--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="DELETEapi-pictures--id-"
               value="999999999"
               data-component="url">
    <br>
<p>The picture's ID. Example: <code>999999999</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_id"                data-endpoint="DELETEapi-pictures--id-"
               value="2"
               data-component="body">
    <br>
<p>The post's ID. Example: <code>2</code></p>
        </div>
        </form>

                    <h2 id="pictures-POSTapi-pictures-reorder">Reorder pictures</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>Note: This endpoint is only available for the multi steps form edition.</p>

<span id="example-requests-POSTapi-pictures-reorder">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/pictures/reorder" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "X-Action: bulk" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"post_id\": 2,
    \"body\": \"suscipit\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/pictures/reorder"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "X-Action": "bulk",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "post_id": 2,
    "body": "suscipit"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/pictures/reorder';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'X-Action' =&gt; 'bulk',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'post_id' =&gt; 2,
            'body' =&gt; 'suscipit',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/pictures/reorder'
payload = {
    "post_id": 2,
    "body": "suscipit"
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'X-Action': 'bulk',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-pictures-reorder">
</span>
<span id="execution-results-POSTapi-pictures-reorder" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-pictures-reorder"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-pictures-reorder"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-pictures-reorder" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-pictures-reorder">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-pictures-reorder" data-method="POST"
      data-path="api/pictures/reorder"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-pictures-reorder', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-pictures-reorder"
                    onclick="tryItOut('POSTapi-pictures-reorder');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-pictures-reorder"
                    onclick="cancelTryOut('POSTapi-pictures-reorder');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-pictures-reorder"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/pictures/reorder</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="POSTapi-pictures-reorder"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-Action</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-Action"                data-endpoint="POSTapi-pictures-reorder"
               value="bulk"
               data-component="header">
    <br>
<p>Example: <code>bulk</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-pictures-reorder"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-pictures-reorder"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-pictures-reorder"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-pictures-reorder"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-pictures-reorder"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_id"                data-endpoint="POSTapi-pictures-reorder"
               value="2"
               data-component="body">
    <br>
<p>The post's ID. Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>body</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="body"                data-endpoint="POSTapi-pictures-reorder"
               value="suscipit"
               data-component="body">
    <br>
<p>Encoded json of the new pictures' positions array [['id' =&gt; 2, 'position' =&gt; 1], ['id' =&gt; 1, 'position' =&gt; 2], ...] Example: <code>suscipit</code></p>
        </div>
        </form>

                    <h2 id="pictures-GETapi-posts--postId--pictures">List pictures</h2>

<p>
</p>



<span id="example-requests-GETapi-posts--postId--pictures">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/posts/4621/pictures?embed=&amp;postId=1&amp;latest=&amp;sort=-position&amp;perPage=2" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/4621/pictures"
);

const params = {
    "embed": "",
    "postId": "1",
    "latest": "0",
    "sort": "-position",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/4621/pictures';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'postId' =&gt; '1',
            'latest' =&gt; '0',
            'sort' =&gt; '-position',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/4621/pictures'
params = {
  'embed': '',
  'postId': '1',
  'latest': '0',
  'sort': '-position',
  'perPage': '2',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-posts--postId--pictures">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 3,
                &quot;post_id&quot;: 1,
                &quot;file_path&quot;: &quot;files/us/1/070907f995fd5c828e90834bf495d9fd.jpg&quot;,
                &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                &quot;position&quot;: 1,
                &quot;active&quot;: 1,
                &quot;url&quot;: {
                    &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1/thumbnails/816x460-070907f995fd5c828e90834bf495d9fd.jpg&quot;,
                    &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1/thumbnails/120x90-070907f995fd5c828e90834bf495d9fd.jpg&quot;,
                    &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1/thumbnails/320x240-070907f995fd5c828e90834bf495d9fd.jpg&quot;,
                    &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1/thumbnails/816x460-070907f995fd5c828e90834bf495d9fd.jpg&quot;
                }
            },
            {
                &quot;id&quot;: 2,
                &quot;post_id&quot;: 1,
                &quot;file_path&quot;: &quot;files/us/1/d6f0e344c97d44e8c071df4983ab8ec1.jpg&quot;,
                &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                &quot;position&quot;: 2,
                &quot;active&quot;: 1,
                &quot;url&quot;: {
                    &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                    &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                    &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                    &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                }
            },
            {
                &quot;id&quot;: 1,
                &quot;post_id&quot;: 1,
                &quot;file_path&quot;: &quot;files/us/1/11443ff3405cfd84b3291fe521f1eded.jpg&quot;,
                &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                &quot;position&quot;: 1,
                &quot;active&quot;: 1,
                &quot;url&quot;: {
                    &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                    &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                    &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                    &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                }
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/posts/4621/pictures?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/posts/4621/pictures?page=1&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: null
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 1,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/posts/4621/pictures?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/posts/4621/pictures&quot;,
            &quot;per_page&quot;: 10,
            &quot;to&quot;: 3,
            &quot;total&quot;: 3
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-posts--postId--pictures" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-posts--postId--pictures"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-posts--postId--pictures"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-posts--postId--pictures" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-posts--postId--pictures">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-posts--postId--pictures" data-method="GET"
      data-path="api/posts/{postId}/pictures"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-posts--postId--pictures', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-posts--postId--pictures"
                    onclick="tryItOut('GETapi-posts--postId--pictures');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-posts--postId--pictures"
                    onclick="cancelTryOut('GETapi-posts--postId--pictures');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-posts--postId--pictures"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/posts/{postId}/pictures</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-posts--postId--pictures"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-posts--postId--pictures"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-posts--postId--pictures"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-posts--postId--pictures"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-posts--postId--pictures"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>postId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="postId"                data-endpoint="GETapi-posts--postId--pictures"
               value="4621"
               data-component="url">
    <br>
<p>Example: <code>4621</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-posts--postId--pictures"
               value=""
               data-component="query">
    <br>
<p>The list of the picture relationships separated by comma for Eager Loading. Possible values: post.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>postId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="postId"                data-endpoint="GETapi-posts--postId--pictures"
               value="1"
               data-component="query">
    <br>
<p>List of pictures related to a listing (using the listing ID). Example: <code>1</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>latest</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--postId--pictures" style="display: none">
            <input type="radio" name="latest"
                   value="1"
                   data-endpoint="GETapi-posts--postId--pictures"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--postId--pictures" style="display: none">
            <input type="radio" name="latest"
                   value="0"
                   data-endpoint="GETapi-posts--postId--pictures"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Get only the first picture after ordering (as object instead of collection). Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-posts--postId--pictures"
               value="-position"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: position, created_at. Example: <code>-position</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-posts--postId--pictures"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                <h1 id="reviews">Reviews</h1>

    

                                <h2 id="reviews-GETapi-plugins-posts--postId--reviews">List reviews</h2>

<p>
</p>



<span id="example-requests-GETapi-plugins-posts--postId--reviews">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/plugins/posts/3/reviews" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"postId\": 2
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/plugins/posts/3/reviews"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "postId": 2
};

fetch(url, {
    method: "GET",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/plugins/posts/3/reviews';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'postId' =&gt; 2,
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/plugins/posts/3/reviews'
payload = {
    "postId": 2
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-plugins-posts--postId--reviews">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: &quot;No reviews found&quot;,
    &quot;result&quot;: {
        &quot;data&quot;: [],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/plugins/posts/3/reviews?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/plugins/posts/3/reviews?page=1&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: null
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: null,
            &quot;last_page&quot;: 1,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/plugins/posts/3/reviews?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/plugins/posts/3/reviews&quot;,
            &quot;per_page&quot;: 10,
            &quot;to&quot;: null,
            &quot;total&quot;: 0
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-plugins-posts--postId--reviews" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-plugins-posts--postId--reviews"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-plugins-posts--postId--reviews"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-plugins-posts--postId--reviews" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-plugins-posts--postId--reviews">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-plugins-posts--postId--reviews" data-method="GET"
      data-path="api/plugins/posts/{postId}/reviews"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-plugins-posts--postId--reviews', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-plugins-posts--postId--reviews"
                    onclick="tryItOut('GETapi-plugins-posts--postId--reviews');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-plugins-posts--postId--reviews"
                    onclick="cancelTryOut('GETapi-plugins-posts--postId--reviews');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-plugins-posts--postId--reviews"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/plugins/posts/{postId}/reviews</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-plugins-posts--postId--reviews"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-plugins-posts--postId--reviews"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-plugins-posts--postId--reviews"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-plugins-posts--postId--reviews"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-plugins-posts--postId--reviews"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>postId</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="postId"                data-endpoint="GETapi-plugins-posts--postId--reviews"
               value="3"
               data-component="url">
    <br>
<p>Example: <code>3</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>postId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="postId"                data-endpoint="GETapi-plugins-posts--postId--reviews"
               value="2"
               data-component="body">
    <br>
<p>The post's ID. Example: <code>2</code></p>
        </div>
        </form>

                    <h2 id="reviews-POSTapi-plugins-posts--postId--reviews">Store review</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-POSTapi-plugins-posts--postId--reviews">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/plugins/posts/2/reviews" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"comment\": null,
    \"rating\": 4,
    \"post_id\": null,
    \"user_id\": null,
    \"captcha_key\": \"ad\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/plugins/posts/2/reviews"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "comment": null,
    "rating": 4,
    "post_id": null,
    "user_id": null,
    "captcha_key": "ad"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/plugins/posts/2/reviews';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'comment' =&gt; null,
            'rating' =&gt; 4,
            'post_id' =&gt; null,
            'user_id' =&gt; null,
            'captcha_key' =&gt; 'ad',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/plugins/posts/2/reviews'
payload = {
    "comment": null,
    "rating": 4,
    "post_id": null,
    "user_id": null,
    "captcha_key": "ad"
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-plugins-posts--postId--reviews">
</span>
<span id="execution-results-POSTapi-plugins-posts--postId--reviews" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-plugins-posts--postId--reviews"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-plugins-posts--postId--reviews"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-plugins-posts--postId--reviews" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-plugins-posts--postId--reviews">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-plugins-posts--postId--reviews" data-method="POST"
      data-path="api/plugins/posts/{postId}/reviews"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-plugins-posts--postId--reviews', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-plugins-posts--postId--reviews"
                    onclick="tryItOut('POSTapi-plugins-posts--postId--reviews');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-plugins-posts--postId--reviews"
                    onclick="cancelTryOut('POSTapi-plugins-posts--postId--reviews');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-plugins-posts--postId--reviews"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/plugins/posts/{postId}/reviews</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>postId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="postId"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="2"
               data-component="url">
    <br>
<p>The listing's ID. Example: <code>2</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>comment</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="comment"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value=""
               data-component="body">
    <br>
<p>The review's message.</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>rating</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="rating"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="4"
               data-component="body">
    <br>
<p>The review's rating. Example: <code>4</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_id"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value=""
               data-component="body">
    <br>
<p>The listing's ID.</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>user_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="user_id"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value=""
               data-component="body">
    <br>
<p>The logged user's ID.</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-plugins-posts--postId--reviews"
               value="ad"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>ad</code></p>
        </div>
        </form>

                    <h2 id="reviews-DELETEapi-plugins-posts--postId--reviews--ids-">Delete review(s)</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>NOTE: Let's consider that only the reviews of the same listings can be deleted in bulk.</p>

<span id="example-requests-DELETEapi-plugins-posts--postId--reviews--ids-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request DELETE \
    "https://demo.laraclassifier.local/api/plugins/posts/2/reviews/reprehenderit" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/plugins/posts/2/reviews/reprehenderit"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "DELETE",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHt